/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.ISlotTracker;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHandlerSlotTracker;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class BackpackInventoryHandler
extends ItemStackHandler
implements IItemHandlerSimpleInserter {
    public static final String INVENTORY_TAG = "inventory";
    private static final String REAL_COUNT_TAG = "realCount";
    private final IBackpackWrapper backpackWrapper;
    private final CompoundTag contentsNbt;
    private final Runnable backpackSaveHandler;
    private final List<IntConsumer> onContentsChangedListeners = new ArrayList<IntConsumer>();
    private boolean persistent = true;
    private final Map<Integer, CompoundTag> stackNbts = new LinkedHashMap<Integer, CompoundTag>();
    private ISlotTracker slotTracker = new ISlotTracker.Noop();
    private int slotLimit;
    private int maxStackSizeMultiplier;
    private boolean isInitializing = true;

    public BackpackInventoryHandler(int numberOfInventorySlots, IBackpackWrapper backpackWrapper, CompoundTag contentsNbt, Runnable backpackSaveHandler, int slotLimit) {
        super(numberOfInventorySlots);
        this.backpackWrapper = backpackWrapper;
        this.contentsNbt = contentsNbt;
        this.backpackSaveHandler = backpackSaveHandler;
        this.setSlotLimit(slotLimit);
        this.deserializeNBT(contentsNbt.m_128469_(INVENTORY_TAG));
        this.initStackNbts();
        this.isInitializing = false;
    }

    public ISlotTracker getSlotTracker() {
        this.initSlotTracker();
        return this.slotTracker;
    }

    public void setSize(int size) {
        super.setSize(this.stacks.size());
    }

    private void initStackNbts() {
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            ItemStack slotStack = (ItemStack)this.stacks.get(slot);
            if (slotStack.m_41619_()) continue;
            this.stackNbts.put(slot, this.getSlotsStackNbt(slot, slotStack));
        }
    }

    public void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.persistent && this.updateSlotNbt(slot)) {
            this.saveInventory();
            for (IntConsumer onContentsChangedListener : this.onContentsChangedListeners) {
                onContentsChangedListener.accept(slot);
            }
        }
    }

    private boolean updateSlotNbt(int slot) {
        ItemStack slotStack = this.getStackInSlot(slot);
        if (slotStack.m_41619_()) {
            if (this.stackNbts.containsKey(slot)) {
                this.stackNbts.remove(slot);
                return true;
            }
        } else {
            CompoundTag itemTag = this.getSlotsStackNbt(slot, slotStack);
            if (!this.stackNbts.containsKey(slot) || !this.stackNbts.get(slot).equals((Object)itemTag)) {
                this.stackNbts.put(slot, itemTag);
                return true;
            }
        }
        return false;
    }

    private CompoundTag getSlotsStackNbt(int slot, ItemStack slotStack) {
        CompoundTag itemTag = new CompoundTag();
        itemTag.m_128405_("Slot", slot);
        itemTag.m_128405_(REAL_COUNT_TAG, slotStack.m_41613_());
        slotStack.m_41739_(itemTag);
        return itemTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.slotTracker.clear();
        this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size());
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            ItemStack slotStack = ItemStack.m_41712_((CompoundTag)itemTags);
            if (itemTags.m_128441_(REAL_COUNT_TAG)) {
                slotStack.m_41764_(itemTags.m_128451_(REAL_COUNT_TAG));
            }
            this.stacks.set(slot, (Object)slotStack);
        }
        this.slotTracker.refreshSlotIndexesFrom(this);
        this.onLoad();
    }

    public int getSlotLimit(int slot) {
        return this.slotLimit;
    }

    public int getStackLimit(int slot, ItemStack stack) {
        int adjustedMaxStackSizeMultiplier = this.maxStackSizeMultiplier > 1 && Config.COMMON.stackUpgrade.canItemStack(stack.m_41720_()) ? this.maxStackSizeMultiplier : 1;
        return Math.min(this.slotLimit, stack.m_41741_() * adjustedMaxStackSizeMultiplier);
    }

    public void setSlotLimit(int slotLimit) {
        this.slotLimit = slotLimit;
        this.maxStackSizeMultiplier = slotLimit / 64;
        if (!this.isInitializing) {
            this.slotTracker.refreshSlotIndexesFrom(this);
        }
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (existing.m_41613_() <= amount) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.f_41583_);
                this.slotTracker.removeAndSetSlotIndexes(this, slot, ItemStack.f_41583_);
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            ItemStack newStack = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - amount));
            this.stacks.set(slot, (Object)newStack);
            this.slotTracker.removeAndSetSlotIndexes(this, slot, newStack);
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)amount);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        this.initSlotTracker();
        return this.slotTracker.insertItemIntoHandler(this, this::insertItemInternal, slot, stack, simulate);
    }

    private void initSlotTracker() {
        if (!(this.slotTracker instanceof InventoryHandlerSlotTracker)) {
            this.slotTracker = new InventoryHandlerSlotTracker(this.backpackWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
            this.slotTracker.refreshSlotIndexesFrom(this);
        }
    }

    private ItemStack insertItemInternal(int slot, ItemStack stack, boolean simulate) {
        ItemStack ret = this.runOnBeforeInsert(slot, stack, simulate, this, this.backpackWrapper);
        if (ret.m_41619_()) {
            return ret;
        }
        if ((ret = super.insertItem(slot, ret, simulate)) != stack && !simulate) {
            this.slotTracker.removeAndSetSlotIndexes(this, slot, this.getStackInSlot(slot));
        }
        if (ret == stack) {
            return ret;
        }
        this.runOnAfterInsert(slot, simulate, this, this.backpackWrapper);
        return ret;
    }

    private void runOnAfterInsert(int slot, boolean simulate, IItemHandlerSimpleInserter handler, IBackpackWrapper backpackWrapper) {
        if (!simulate) {
            backpackWrapper.getUpgradeHandler().getWrappersThatImplementFromMainBackpack(IInsertResponseUpgrade.class).forEach(u -> u.onAfterInsert(handler, slot));
        }
    }

    private ItemStack runOnBeforeInsert(int slot, ItemStack stack, boolean simulate, IItemHandlerSimpleInserter handler, IBackpackWrapper backpackWrapper) {
        List<IInsertResponseUpgrade> wrappers = backpackWrapper.getUpgradeHandler().getWrappersThatImplementFromMainBackpack(IInsertResponseUpgrade.class);
        ItemStack remaining = stack;
        for (IInsertResponseUpgrade upgrade : wrappers) {
            remaining = upgrade.onBeforeInsert(handler, slot, remaining, simulate);
            if (!remaining.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remaining;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        super.setStackInSlot(slot, stack);
        this.slotTracker.removeAndSetSlotIndexes(this, slot, stack);
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.isNotDisallowed(stack) && this.backpackWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).matchesFilter(slot, stack);
    }

    private boolean isNotDisallowed(ItemStack stack) {
        return !Config.COMMON.disallowedItems.isItemDisallowed(stack.m_41720_()) && (!(stack.m_41720_() instanceof BackpackItem) || this.hasInceptionUpgrade() && this.isBackpackWithoutInceptionUpgrade(stack));
    }

    private boolean hasInceptionUpgrade() {
        return this.backpackWrapper.getUpgradeHandler().hasUpgrade(InceptionUpgradeItem.TYPE);
    }

    private boolean isBackpackWithoutInceptionUpgrade(ItemStack stack) {
        return stack.m_41720_() instanceof BackpackItem && stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(w -> w.getUpgradeHandler().hasUpgrade(InceptionUpgradeItem.TYPE)).orElse(false) == false;
    }

    public void saveInventory() {
        this.contentsNbt.m_128365_(INVENTORY_TAG, (Tag)this.serializeNBT());
        this.backpackSaveHandler.run();
    }

    public void copyStacksTo(BackpackInventoryHandler otherHandler) {
        InventoryHelper.copyTo(this, otherHandler);
    }

    public void addListener(IntConsumer onContentsChanged) {
        this.onContentsChangedListeners.add(onContentsChanged);
    }

    public void clearListeners() {
        this.onContentsChangedListeners.clear();
    }

    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        nbtTagList.addAll(this.stackNbts.values());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", this.getSlots());
        return nbt;
    }

    public int getStackSizeMultiplier() {
        return this.maxStackSizeMultiplier;
    }

    @Override
    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        this.initSlotTracker();
        return this.slotTracker.insertItemIntoHandler(this, this::insertItemInternal, stack, simulate);
    }
}

