/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeRenderDataType;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.TankPosition;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.JukeboxUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.SmeltingUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class BackpackRenderInfo {
    private static final String RENDER_INFO_TAG = "renderInfo";
    private static final String TANKS_TAG = "tanks";
    private static final String UPGRADES_TAG = "upgrades";
    private static final String BATTERY_TAG = "battery";
    private static final String TANK_POSITION_TAG = "position";
    private static final String TANK_INFO_TAG = "info";
    private static final String ITEM_DISPLAY_TAG = "itemDisplay";
    private static final Map<String, UpgradeRenderDataType<?>> RENDER_DATA_TYPES = Map.of(SmeltingUpgradeRenderData.TYPE.getName(), SmeltingUpgradeRenderData.TYPE, JukeboxUpgradeRenderData.TYPE.getName(), JukeboxUpgradeRenderData.TYPE);
    private final ItemStack backpack;
    private final Supplier<Runnable> getBackpackSaveHandler;
    private final Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> tankRenderInfos = new LinkedHashMap<TankPosition, IRenderedTankUpgrade.TankRenderInfo>();
    @Nullable
    private IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = null;
    private final Map<UpgradeRenderDataType<?>, IUpgradeRenderData> upgradeData = new HashMap();
    private ItemDisplayRenderInfo itemDisplayRenderInfo = new ItemDisplayRenderInfo();

    public BackpackRenderInfo(ItemStack backpack, Supplier<Runnable> getBackpackSaveHandler) {
        this.backpack = backpack;
        this.getBackpackSaveHandler = getBackpackSaveHandler;
        this.deserialize();
    }

    public <T extends IUpgradeRenderData> Optional<T> getUpgradeRenderData(UpgradeRenderDataType<T> upgradeRenderDataType) {
        if (!this.upgradeData.containsKey(upgradeRenderDataType)) {
            return Optional.empty();
        }
        return upgradeRenderDataType.cast(this.upgradeData.get(upgradeRenderDataType));
    }

    public <T extends IUpgradeRenderData> void setUpgradeRenderData(UpgradeRenderDataType<T> upgradeRenderDataType, T renderData) {
        this.upgradeData.put(upgradeRenderDataType, renderData);
        this.serializeUpgradeData(upgrades -> upgrades.m_128365_(upgradeRenderDataType.getName(), (Tag)renderData.serializeNBT()));
        this.save();
    }

    private void serializeUpgradeData(Consumer<CompoundTag> modifyUpgradesTag) {
        CompoundTag renderInfo = this.getRenderInfoTag();
        CompoundTag upgrades = renderInfo.m_128469_(UPGRADES_TAG);
        modifyUpgradesTag.accept(upgrades);
        renderInfo.m_128365_(UPGRADES_TAG, (Tag)upgrades);
        NBTHelper.setCompoundNBT(this.backpack, RENDER_INFO_TAG, renderInfo);
    }

    private void deserialize() {
        this.deserializeTanks();
        this.deserializeBattery();
        this.deserializeUpgrades();
        this.deserializeItemDisplay();
    }

    private void deserializeItemDisplay() {
        this.itemDisplayRenderInfo = ItemDisplayRenderInfo.deserialize(this.getRenderInfoTag().m_128469_(ITEM_DISPLAY_TAG));
    }

    private void deserializeUpgrades() {
        CompoundTag renderInfo = this.getRenderInfoTag();
        CompoundTag upgrades = renderInfo.m_128469_(UPGRADES_TAG);
        upgrades.m_128431_().forEach(key -> {
            if (RENDER_DATA_TYPES.containsKey(key)) {
                UpgradeRenderDataType<?> upgradeRenderDataType = RENDER_DATA_TYPES.get(key);
                this.upgradeData.put(upgradeRenderDataType, (IUpgradeRenderData)upgradeRenderDataType.deserialize(upgrades.m_128469_(key)));
            }
        });
    }

    private void save() {
        this.getBackpackSaveHandler.get().run();
    }

    public void deserializeFrom(CompoundTag renderInfoNbt) {
        this.resetUpgradeInfo();
        this.backpack.m_41700_(RENDER_INFO_TAG, (Tag)renderInfoNbt);
        this.deserialize();
    }

    public CompoundTag getNbt() {
        return this.getRenderInfoTag();
    }

    public void resetUpgradeInfo() {
        this.tankRenderInfos.clear();
        this.batteryRenderInfo = null;
        this.getRenderInfoTag().m_128473_(TANKS_TAG);
        this.getRenderInfoTag().m_128473_(BATTERY_TAG);
        this.save();
    }

    public void setTankRenderInfo(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        this.tankRenderInfos.put(tankPosition, tankRenderInfo);
        this.serializeTank(tankPosition, tankRenderInfo);
        this.save();
    }

    private void deserializeTanks() {
        CompoundTag renderInfo = this.getRenderInfoTag();
        ListTag tanks = renderInfo.m_128437_(TANKS_TAG, 10);
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundTag tank = tanks.m_128728_(i);
            this.tankRenderInfos.put(TankPosition.valueOf(tank.m_128461_(TANK_POSITION_TAG).toUpperCase(Locale.ENGLISH)), IRenderedTankUpgrade.TankRenderInfo.deserialize(tank.m_128469_(TANK_INFO_TAG)));
        }
    }

    private void deserializeBattery() {
        this.batteryRenderInfo = NBTHelper.getCompound(this.getRenderInfoTag(), BATTERY_TAG).map(IRenderedBatteryUpgrade.BatteryRenderInfo::deserialize).orElse(null);
    }

    private void serializeTank(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        CompoundTag tankInfo = tankRenderInfo.serialize();
        CompoundTag renderInfo = this.getRenderInfoTag();
        ListTag tanks = renderInfo.m_128437_(TANKS_TAG, 10);
        boolean infoSet = false;
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundTag tank = tanks.m_128728_(i);
            if (!tank.m_128461_(TANK_POSITION_TAG).equals(tankPosition.m_7912_())) continue;
            tank.m_128365_(TANK_INFO_TAG, (Tag)tankInfo);
            infoSet = true;
        }
        if (!infoSet) {
            CompoundTag tankPositionInfo = new CompoundTag();
            tankPositionInfo.m_128359_(TANK_POSITION_TAG, tankPosition.m_7912_());
            tankPositionInfo.m_128365_(TANK_INFO_TAG, (Tag)tankInfo);
            tanks.add((Object)tankPositionInfo);
            renderInfo.m_128365_(TANKS_TAG, (Tag)tanks);
        }
        NBTHelper.setCompoundNBT(this.backpack, RENDER_INFO_TAG, renderInfo);
    }

    public Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> getTankRenderInfos() {
        return this.tankRenderInfos;
    }

    public ItemDisplayRenderInfo getItemDisplayRenderInfo() {
        return this.itemDisplayRenderInfo;
    }

    public void setItemDisplayRenderInfo(ItemStack item, int rotation) {
        this.itemDisplayRenderInfo.setItem(item);
        this.itemDisplayRenderInfo.setRotation(rotation);
        CompoundTag renderInfo = this.getRenderInfoTag();
        renderInfo.m_128365_(ITEM_DISPLAY_TAG, (Tag)this.itemDisplayRenderInfo.serialize());
        NBTHelper.setCompoundNBT(this.backpack, RENDER_INFO_TAG, renderInfo);
        this.save();
    }

    public Optional<IRenderedBatteryUpgrade.BatteryRenderInfo> getBatteryRenderInfo() {
        return Optional.ofNullable(this.batteryRenderInfo);
    }

    public void setBatteryRenderInfo(IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo) {
        this.batteryRenderInfo = batteryRenderInfo;
        CompoundTag batteryInfo = batteryRenderInfo.serialize();
        CompoundTag renderInfo = this.getRenderInfoTag();
        renderInfo.m_128365_(BATTERY_TAG, (Tag)batteryInfo);
        NBTHelper.setCompoundNBT(this.backpack, RENDER_INFO_TAG, renderInfo);
        this.save();
    }

    @Nonnull
    private CompoundTag getRenderInfoTag() {
        return NBTHelper.getCompound(this.backpack, RENDER_INFO_TAG).orElse(new CompoundTag());
    }

    public Map<UpgradeRenderDataType<?>, IUpgradeRenderData> getUpgradeRenderData() {
        return this.upgradeData;
    }

    public void removeUpgradeRenderData(UpgradeRenderDataType<?> type) {
        this.upgradeData.remove(type);
        this.serializeUpgradeData(upgrades -> upgrades.m_128473_(type.getName()));
        this.save();
    }

    public static class ItemDisplayRenderInfo {
        private static final String ITEM_TAG = "item";
        private static final String ROTATION_TAG = "rotation";
        private ItemStack item;
        private int rotation;

        private ItemDisplayRenderInfo(ItemStack item, int rotation) {
            this.item = item;
            this.rotation = rotation;
        }

        public ItemDisplayRenderInfo() {
            this(ItemStack.f_41583_, 0);
        }

        public CompoundTag serialize() {
            CompoundTag ret = new CompoundTag();
            if (!this.item.m_41619_()) {
                ret.m_128365_(ITEM_TAG, (Tag)this.item.serializeNBT());
                ret.m_128405_(ROTATION_TAG, this.rotation);
            }
            return ret;
        }

        private void setItem(ItemStack item) {
            this.item = item;
        }

        public static ItemDisplayRenderInfo deserialize(CompoundTag tag) {
            if (tag.m_128441_(ITEM_TAG)) {
                return new ItemDisplayRenderInfo(ItemStack.m_41712_((CompoundTag)tag.m_128469_(ITEM_TAG)), tag.m_128451_(ROTATION_TAG));
            }
            return new ItemDisplayRenderInfo();
        }

        private void setRotation(int rot) {
            this.rotation = rot;
        }

        public int getRotation() {
            return this.rotation;
        }

        public ItemStack getItem() {
            return this.item;
        }
    }
}

