/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.init.ModBlockColors;
import net.p3pp3rf1y.sophisticatedbackpacks.client.init.ModItemColors;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackBlockEntityRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackDynamicModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackLayerRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.ClientBackpackContentsTooltip;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModParticles;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackInsertMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.battery.BatteryUpgradeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.BackpackSoundHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RecipeHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RegistryHelper;

public class ClientEventHandler {
    private static final String BACKPACK_REG_NAME = "backpack";
    public static final ModelLayerLocation BACKPACK_LAYER = new ModelLayerLocation(new ResourceLocation("sophisticatedbackpacks", "backpack"), "main");

    private ClientEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientEventHandler::loadComplete);
        modBus.addListener(ClientEventHandler::clientSetup);
        modBus.addListener(ClientEventHandler::stitchTextures);
        modBus.addListener(ClientEventHandler::onModelRegistry);
        modBus.addListener(ClientEventHandler::registerLayer);
        modBus.addListener(ClientEventHandler::registerEntityRenderers);
        modBus.addListener(ClientEventHandler::registerReloadListener);
        modBus.addListener(ModParticles::registerFactories);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(ClientEventHandler::onPlayerJoinServer);
        eventBus.addListener(ClientEventHandler::onDrawScreen);
        eventBus.addListener(EventPriority.HIGH, ClientEventHandler::onRightClick);
        eventBus.addListener(ClientBackpackContentsTooltip::onWorldLoad);
        eventBus.addListener(BackpackSoundHandler::tick);
        eventBus.addListener(BackpackSoundHandler::onWorldUnload);
    }

    private static void onDrawScreen(ScreenEvent.DrawScreenEvent.Post event) {
        AbstractContainerScreen containerGui;
        Minecraft mc;
        block6: {
            block5: {
                mc = Minecraft.m_91087_();
                Screen gui = mc.f_91080_;
                if (!(gui instanceof AbstractContainerScreen)) break block5;
                containerGui = (AbstractContainerScreen)gui;
                if (!(gui instanceof CreativeModeInventoryScreen) && mc.f_91074_ != null) break block6;
            }
            return;
        }
        AbstractContainerMenu menu = containerGui.m_6262_();
        ItemStack held = menu.m_142621_();
        if (!held.m_41619_() && !(held.m_41720_() instanceof BackpackItem)) {
            Slot under = containerGui.getSlotUnderMouse();
            PoseStack poseStack = event.getPoseStack();
            for (Slot s : menu.f_38839_) {
                ItemStack stack = s.m_7993_();
                if (!s.m_8010_((Player)mc.f_91074_) || stack.m_41613_() != 1) continue;
                stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> {
                    if (s == under) {
                        int x = event.getMouseX();
                        int y = event.getMouseY();
                        poseStack.m_85836_();
                        poseStack.m_85837_(0.0, 0.0, containerGui instanceof BackpackScreen ? -100.0 : 100.0);
                        containerGui.renderTooltip(poseStack, Collections.singletonList(new TranslatableComponent("gui.sophisticatedbackpacks.tooltip.right_click_to_add_to_backpack")), Optional.of(new BackpackItem.BackpackContentsTooltip(stack)), x, y, mc.f_91062_);
                        poseStack.m_85849_();
                    } else {
                        int x = containerGui.getGuiLeft() + s.f_40220_;
                        int y = containerGui.getGuiTop() + s.f_40221_;
                        poseStack.m_85836_();
                        poseStack.m_85837_(0.0, 0.0, containerGui instanceof BackpackScreen ? 100.0 : 499.0);
                        mc.f_91062_.m_92750_(poseStack, "+", (float)x + 10.0f, (float)y + 8.0f, 0xFFFF00);
                        poseStack.m_85849_();
                    }
                });
            }
        }
    }

    private static void onRightClick(ScreenEvent.MouseReleasedEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen container = (AbstractContainerScreen)screen;
            if (!(screen instanceof CreativeModeInventoryScreen) && event.getButton() == 1) {
                ItemStack stack;
                Slot under = container.getSlotUnderMouse();
                ItemStack held = container.m_6262_().m_142621_();
                if (under != null && !held.m_41619_() && mc.f_91074_ != null && under.m_8010_((Player)mc.f_91074_) && (stack = under.m_7993_()).m_41720_() instanceof BackpackItem && stack.m_41613_() == 1) {
                    PacketHandler.sendToServer(new BackpackInsertMessage(under.f_40219_));
                    screen.m_6348_(0.0, 0.0, -1);
                    event.setCanceled(true);
                }
            }
        }
    }

    private static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            ModItemColors.init();
            ModBlockColors.init();
        });
    }

    private static void onModelRegistry(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)RegistryHelper.getRL(BACKPACK_REG_NAME), (IModelLoader)BackpackDynamicModel.Loader.INSTANCE);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BACKPACK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.IRON_BACKPACK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GOLD_BACKPACK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.DIAMOND_BACKPACK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.NETHERITE_BACKPACK.get()), (RenderType)RenderType.m_110463_());
    }

    public static void registerReloadListener(ParticleFactoryRegisterEvent event) {
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> ClientEventHandler.registerBackpackLayer()));
    }

    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModItems.EVERLASTING_BACKPACK_ITEM_ENTITY.get(), ItemEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.BACKPACK_TILE_TYPE.get(), BackpackBlockEntityRenderer::new);
    }

    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BACKPACK_LAYER, BackpackModel::createBodyLayer);
    }

    private static void registerBackpackLayer() {
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        Map skinMap = renderManager.getSkinMap();
        for (EntityRenderer renderer : skinMap.values()) {
            if (!(renderer instanceof LivingEntityRenderer)) continue;
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)renderer;
            livingEntityRenderer.m_115326_(new BackpackLayerRenderer(livingEntityRenderer));
        }
        renderManager.f_114362_.forEach((e, r) -> {
            if (r instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)r;
                livingEntityRenderer.m_115326_(new BackpackLayerRenderer(livingEntityRenderer));
            }
        });
    }

    public static void stitchTextures(TextureStitchEvent.Pre evt) {
        if (evt.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
            evt.addSprite(BackpackContainer.EMPTY_UPGRADE_SLOT_BACKGROUND);
            evt.addSprite(TankUpgradeContainer.EMPTY_TANK_INPUT_SLOT_BACKGROUND);
            evt.addSprite(TankUpgradeContainer.EMPTY_TANK_OUTPUT_SLOT_BACKGROUND);
            evt.addSprite(BatteryUpgradeContainer.EMPTY_BATTERY_INPUT_SLOT_BACKGROUND);
            evt.addSprite(BatteryUpgradeContainer.EMPTY_BATTERY_OUTPUT_SLOT_BACKGROUND);
        }
    }

    private static void onPlayerJoinServer(ClientPlayerNetworkEvent.LoggedInEvent evt) {
        RecipeHelper.setWorld((Level)Minecraft.m_91087_().f_91073_);
    }
}

