/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackBackgroundProperties;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackGuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackOpenMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.BackpackSettingsTabControl;

public class SettingsScreen
extends AbstractContainerScreen<SettingsContainer> {
    private BackpackSettingsTabControl settingsTabControl;

    public SettingsScreen(SettingsContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_97727_ = 114 + ((SettingsContainer)this.m_6262_()).getNumberOfRows() * 18;
        this.f_97726_ = ((SettingsContainer)this.m_6262_()).getBackpackBackgroundProperties().getSlotsOnLine() * 18 + 14;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97730_ = 8 + ((SettingsContainer)this.m_6262_()).getBackpackBackgroundProperties().getPlayerInventoryXOffset();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.settingsTabControl = new BackpackSettingsTabControl(this, new Position(this.f_97735_ + this.f_97726_, this.f_97736_ + 4));
        this.m_7787_(this.settingsTabControl);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        BackpackBackgroundProperties backpackBackgroundProperties = ((SettingsContainer)this.m_6262_()).getBackpackBackgroundProperties();
        BackpackGuiHelper.renderBackpackBackground(new Position((this.f_96543_ - this.f_97726_) / 2, (this.f_96544_ - this.f_97727_) / 2), matrixStack, ((SettingsContainer)this.m_6262_()).getBackpackInventorySlots().size(), ((SettingsContainer)this.m_6262_()).getSlotsOnLine(), backpackBackgroundProperties.getTextureName(), this.f_97726_, ((SettingsContainer)this.f_97732_).getNumberOfRows());
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ((SettingsContainer)this.f_97732_).detectSettingsChangeAndReload();
        this.m_7333_(matrixStack);
        this.settingsTabControl.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85837_(0.0, 0.0, 200.0);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.settingsTabControl.renderTooltip((Screen)this, matrixStack, mouseX, mouseY);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        for (int slotId = 0; slotId < ((SettingsContainer)this.f_97732_).ghostSlots.size(); ++slotId) {
            Slot slot = ((SettingsContainer)this.f_97732_).ghostSlots.get(slotId);
            this.m_97799_(matrixStack, slot);
            this.settingsTabControl.renderSlotOverlays(matrixStack, slot, this::renderSlotOverlay);
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            this.f_97734_ = slot;
            this.renderSlotOverlay(matrixStack, slot, this.getSlotColor(slotId));
        }
    }

    protected void m_97799_(PoseStack poseStack, Slot slot) {
        Optional<ItemStack> memorizedStack = ((SettingsContainer)this.m_6262_()).getMemorizedStackInSlot(slot.getSlotIndex());
        ItemStack itemstack = slot.m_7993_();
        if (memorizedStack.isPresent()) {
            itemstack = memorizedStack.get();
        }
        this.m_93250_(100);
        this.f_96542_.f_115093_ = 100.0f;
        RenderSystem.m_69482_();
        poseStack.m_85836_();
        this.settingsTabControl.renderGuiItem(this.f_96542_, itemstack, slot);
        poseStack.m_85849_();
        this.f_96542_.f_115093_ = 0.0f;
        this.m_93250_(0);
        if (memorizedStack.isPresent()) {
            this.drawMemorizedStackOverlay(poseStack, slot.f_40220_, slot.f_40221_);
        }
    }

    private void drawMemorizedStackOverlay(PoseStack poseStack, int x, int y) {
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69465_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiHelper.GUI_CONTROLS);
        this.m_93228_(poseStack, x, y, 77, 0, 16, 16);
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        poseStack.m_85849_();
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot != null) {
            this.settingsTabControl.handleSlotClick(slot, mouseButton);
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Slot slot = this.m_97744_(mouseX, mouseY);
        if (slot != null) {
            this.settingsTabControl.handleSlotClick(slot, button);
        }
        return true;
    }

    @Nullable
    protected Slot m_97744_(double mouseX, double mouseY) {
        for (int i = 0; i < ((SettingsContainer)this.f_97732_).ghostSlots.size(); ++i) {
            Slot slot = ((SettingsContainer)this.f_97732_).ghostSlots.get(i);
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            return slot;
        }
        return null;
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && this.hasClickedOutsideOfSettings(mouseX, mouseY);
    }

    private boolean hasClickedOutsideOfSettings(double mouseX, double mouseY) {
        return this.settingsTabControl.getTabRectangles().stream().noneMatch(r -> r.m_110087_((int)mouseX, (int)mouseY));
    }

    private void renderSlotOverlay(PoseStack matrixStack, Slot slot, int slotColor) {
        this.renderSlotOverlay(matrixStack, slot.f_40220_, slot.f_40221_, 16, slotColor);
    }

    private void renderSlotOverlay(PoseStack matrixStack, int xPos, int yPos, int height, int slotColor) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.m_93179_(matrixStack, xPos, yPos, xPos + 16, yPos + height, slotColor, slotColor);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            PacketHandler.sendToServer(new BackpackOpenMessage());
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public static SettingsScreen constructScreen(SettingsContainer settingsContainer, Inventory playerInventory, Component title) {
        return new SettingsScreen(settingsContainer, playerInventory, title);
    }

    public BackpackSettingsTabControl getSettingsTabControl() {
        return this.settingsTabControl;
    }
}

