/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.UpgradeInventoryPartBase;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.UpgradeSettingsTab;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerType;

public class UpgradeGuiManager {
    private static final Map<UpgradeContainerType<?, ?>, IUpgradeSettingsFactory<?, ?>> UPGRADE_TABS = new HashMap();
    private static final Map<UpgradeContainerType<?, ?>, IUpgradeInventoryPartFactory<?, ?>> UPGRADE_INVENTORY_PARTS = new HashMap();

    private UpgradeGuiManager() {
    }

    public static <W extends IUpgradeWrapper, C extends UpgradeContainerBase<W, C>, S extends UpgradeSettingsTab<C>> void registerTab(UpgradeContainerType<W, C> containerType, IUpgradeSettingsFactory<C, S> upgradeSettingsFactory) {
        UPGRADE_TABS.put(containerType, upgradeSettingsFactory);
    }

    public static <W extends IUpgradeWrapper, C extends UpgradeContainerBase<W, C>, I extends UpgradeInventoryPartBase<C>> void registerInventoryPart(UpgradeContainerType<W, C> containerType, IUpgradeInventoryPartFactory<C, I> factory) {
        UPGRADE_INVENTORY_PARTS.put(containerType, factory);
    }

    public static <C extends UpgradeContainerBase<?, ?>> UpgradeSettingsTab<C> getTab(C container, Position position, BackpackScreen screen) {
        return UpgradeGuiManager.getTabFactory(container).create(container, position, screen);
    }

    public static <C extends UpgradeContainerBase<?, ?>> Optional<UpgradeInventoryPartBase<C>> getInventoryPart(int upgradeSlot, C container, Position position, int height, BackpackScreen screen) {
        return UpgradeGuiManager.getInventoryPartFactory(container).map(f -> f.create(upgradeSlot, container, position, height, screen));
    }

    private static <C extends UpgradeContainerBase<?, ?>, S extends UpgradeSettingsTab<C>> IUpgradeSettingsFactory<C, S> getTabFactory(C container) {
        return UpgradeGuiManager.getTabFactory(container.getType());
    }

    private static <W extends IUpgradeWrapper, C extends UpgradeContainerBase<W, C>, S extends UpgradeSettingsTab<C>> IUpgradeSettingsFactory<C, S> getTabFactory(UpgradeContainerType<W, C> containerType) {
        return UPGRADE_TABS.get(containerType);
    }

    private static <C extends UpgradeContainerBase<?, ?>, I extends UpgradeInventoryPartBase<C>> Optional<IUpgradeInventoryPartFactory<C, I>> getInventoryPartFactory(C container) {
        if (!UPGRADE_INVENTORY_PARTS.containsKey(container.getType())) {
            return Optional.empty();
        }
        return Optional.of(UpgradeGuiManager.getInventoryPartFactory(container.getType()));
    }

    private static <W extends IUpgradeWrapper, C extends UpgradeContainerBase<W, C>, I extends UpgradeInventoryPartBase<C>> IUpgradeInventoryPartFactory<C, I> getInventoryPartFactory(UpgradeContainerType<W, C> containerType) {
        return UPGRADE_INVENTORY_PARTS.get(containerType);
    }

    public static interface IUpgradeSettingsFactory<C extends UpgradeContainerBase<?, ?>, S extends UpgradeSettingsTab<C>> {
        public S create(C var1, Position var2, BackpackScreen var3);
    }

    public static interface IUpgradeInventoryPartFactory<C extends UpgradeContainerBase<?, ?>, I extends UpgradeInventoryPartBase<C>> {
        public I create(int var1, C var2, Position var3, int var4, BackpackScreen var5);
    }
}

