/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.RequestBackpackInventoryContentsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.util.CountAbbreviator;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class ClientBackpackContentsTooltip
implements ClientTooltipComponent {
    private static final String BACKPACK_ITEM_NAME = "backpack";
    private static final int REFRESH_INTERVAL = 20;
    private static boolean shouldRefreshContents = true;
    private static long lastRequestTime = 0L;
    @Nullable
    private static UUID backpackUuid = null;
    private static List<IUpgradeWrapper> upgrades = new ArrayList<IUpgradeWrapper>();
    private static List<ItemStack> sortedContents = new ArrayList<ItemStack>();
    private static final List<Component> tooltipLines = new ArrayList<Component>();
    private static int height = 0;
    private static int width = 0;
    private final ItemStack backpack;
    private static final TextureBlitData UPGRADE_ON = new TextureBlitData(GuiHelper.ICONS, Dimension.SQUARE_256, new UV(4, 128), Dimension.RECTANGLE_4_10);
    private static final TextureBlitData UPGRADE_OFF = new TextureBlitData(GuiHelper.ICONS, Dimension.SQUARE_256, new UV(0, 128), Dimension.RECTANGLE_4_10);
    private static final int MAX_STACKS_ON_LINE = 9;
    private static final int DEFAULT_STACK_WIDTH = 18;
    private static final int COUNT_PADDING = 2;

    public static void onWorldLoad(WorldEvent.Load event) {
        shouldRefreshContents = true;
        lastRequestTime = 0L;
    }

    private static void initContents(LocalPlayer player, IBackpackWrapper wrapper) {
        UUID newUuid = wrapper.getContentsUuid().orElse(null);
        if (backpackUuid == null && newUuid != null || backpackUuid != null && !backpackUuid.equals(newUuid)) {
            lastRequestTime = 0L;
            backpackUuid = newUuid;
            shouldRefreshContents = true;
        }
        ClientBackpackContentsTooltip.requestContents(player, wrapper);
        ClientBackpackContentsTooltip.refreshContents(wrapper);
    }

    private static void requestContents(LocalPlayer player, IBackpackWrapper wrapper) {
        if (lastRequestTime + 20L < player.f_19853_.m_46467_()) {
            lastRequestTime = player.f_19853_.m_46467_();
            wrapper.getContentsUuid().ifPresent(uuid -> PacketHandler.sendToServer(new RequestBackpackInventoryContentsMessage((UUID)uuid)));
        }
    }

    private static void refreshContents(IBackpackWrapper wrapper) {
        if (shouldRefreshContents) {
            shouldRefreshContents = false;
            sortedContents.clear();
            upgrades.clear();
            if (backpackUuid != null) {
                wrapper.onContentsNbtUpdated();
                sortedContents = InventoryHelper.getCompactedStacksSortedByCount((IItemHandler)wrapper.getInventoryHandler());
                upgrades = new ArrayList<IUpgradeWrapper>(wrapper.getUpgradeHandler().getSlotWrappers().values());
                tooltipLines.clear();
                ClientBackpackContentsTooltip.addMultiplierTooltip(wrapper);
                ClientBackpackContentsTooltip.addFluidTooltip(wrapper);
                ClientBackpackContentsTooltip.addEnergyTooltip(wrapper);
                if (upgrades.isEmpty() && sortedContents.isEmpty()) {
                    tooltipLines.add((Component)new TranslatableComponent("item.sophisticatedbackpacks.backpack.tooltip.empty").m_130940_(ChatFormatting.YELLOW));
                }
            }
            ClientBackpackContentsTooltip.calculateHeight();
            ClientBackpackContentsTooltip.calculateWidth();
        }
    }

    private static void calculateWidth() {
        int upgradesWidth = ClientBackpackContentsTooltip.calculateUpgradesWidth();
        int contentsWidth = ClientBackpackContentsTooltip.calculateContentsWidth();
        int tooltipContentsWidth = ClientBackpackContentsTooltip.calculateTooltipLinesWidth();
        int stacksWidth = Math.max(upgradesWidth, contentsWidth);
        width = Math.max(stacksWidth, tooltipContentsWidth);
    }

    private static int calculateTooltipLinesWidth() {
        return tooltipLines.stream().map(ClientBackpackContentsTooltip::getTooltipWidth).max(Comparator.naturalOrder()).orElse(0);
    }

    private static int calculateUpgradesWidth() {
        int upgradesWidth = 0;
        for (IUpgradeWrapper upgradeWrapper : upgrades) {
            upgradesWidth += (upgradeWrapper.canBeDisabled() ? 4 : 0) + 18;
        }
        return upgradesWidth;
    }

    private static int calculateContentsWidth() {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int contentsWidth = 0;
        for (int i = 0; i < sortedContents.size() && i < 9; ++i) {
            int countWidth = ClientBackpackContentsTooltip.getStackCountWidth(fontRenderer, sortedContents.get(i));
            contentsWidth += Math.max(countWidth, 18);
        }
        return contentsWidth;
    }

    private static int getStackCountWidth(Font fontRenderer, ItemStack stack) {
        return fontRenderer.m_92895_(CountAbbreviator.abbreviate(stack.m_41613_())) + 2;
    }

    private static int getTooltipWidth(Component component) {
        return Minecraft.m_91087_().f_91062_.m_92724_(component.m_7532_());
    }

    private static void addMultiplierTooltip(IBackpackWrapper wrapper) {
        int multiplier = wrapper.getInventoryHandler().getStackSizeMultiplier();
        if (multiplier > 1) {
            tooltipLines.add((Component)new TranslatableComponent("item.sophisticatedbackpacks.backpack.tooltip.stack_multiplier", new Object[]{new TextComponent(Integer.toString(multiplier)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GREEN));
        }
    }

    private static void addEnergyTooltip(IBackpackWrapper wrapper) {
        wrapper.getEnergyStorage().ifPresent(energyStorage -> tooltipLines.add((Component)new TranslatableComponent(TranslationHelper.translItemTooltip(BACKPACK_ITEM_NAME) + ".energy", new Object[]{new TextComponent(CountAbbreviator.abbreviate(energyStorage.getEnergyStored())).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED)));
    }

    private static void addFluidTooltip(IBackpackWrapper wrapper) {
        wrapper.getFluidHandler().ifPresent(fluidHandler -> {
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                FluidStack fluid = fluidHandler.getFluidInTank(tank);
                if (fluid.isEmpty()) {
                    tooltipLines.add((Component)new TranslatableComponent(TranslationHelper.translItemTooltip(BACKPACK_ITEM_NAME) + ".fluid_empty").m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                tooltipLines.add((Component)new TranslatableComponent(TranslationHelper.translItemTooltip(BACKPACK_ITEM_NAME) + ".fluid", new Object[]{new TextComponent(CountAbbreviator.abbreviate(fluid.getAmount())).m_130940_(ChatFormatting.WHITE), new TranslatableComponent(fluid.getTranslationKey()).m_130940_(ChatFormatting.BLUE)}));
            }
        });
    }

    private static void calculateHeight() {
        int upgradesHeight = upgrades.isEmpty() ? 0 : 32;
        int inventoryHeight = sortedContents.isEmpty() ? 0 : 12 + (1 + (sortedContents.size() - 1) / 9) * 20;
        int totalHeight = upgradesHeight + inventoryHeight + tooltipLines.size() * 10;
        height = totalHeight > 0 ? totalHeight : 12;
    }

    public static void refreshContents() {
        shouldRefreshContents = true;
    }

    public ClientBackpackContentsTooltip(BackpackItem.BackpackContentsTooltip tooltip) {
        this.backpack = tooltip.getBackpack();
    }

    public int m_142069_(Font font) {
        return width;
    }

    public int m_142103_() {
        return height;
    }

    public void m_183452_(Font font, int leftX, int topY, PoseStack poseStack, ItemRenderer itemRenderer, int blitOffset) {
        this.backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player == null) {
                return;
            }
            ClientBackpackContentsTooltip.initContents(player, wrapper);
            this.renderComponent(font, leftX, topY, poseStack, itemRenderer, blitOffset, (IBackpackWrapper)wrapper, minecraft);
        });
    }

    private void renderComponent(Font font, int leftX, int topY, PoseStack poseStack, ItemRenderer itemRenderer, int blitOffset, IBackpackWrapper wrapper, Minecraft minecraft) {
        for (Component tooltipLine : tooltipLines) {
            topY = this.renderTooltipLine(poseStack, leftX, topY, font, blitOffset, tooltipLine);
        }
        this.renderContentsTooltip(minecraft, font, leftX, topY, poseStack, itemRenderer, blitOffset);
    }

    private void renderContentsTooltip(Minecraft minecraft, Font font, int leftX, int topY, PoseStack poseStack, ItemRenderer itemRenderer, double blitOffset) {
        if (!upgrades.isEmpty()) {
            topY = this.renderTooltipLine(poseStack, leftX, topY, font, blitOffset, (Component)new TranslatableComponent("item.sophisticatedbackpacks.backpack.tooltip.upgrades").m_130940_(ChatFormatting.YELLOW));
            topY = this.renderUpgrades(poseStack, leftX, topY, itemRenderer);
        }
        if (!sortedContents.isEmpty()) {
            topY = this.renderTooltipLine(poseStack, leftX, topY, font, blitOffset, (Component)new TranslatableComponent("item.sophisticatedbackpacks.backpack.tooltip.inventory").m_130940_(ChatFormatting.YELLOW));
            this.renderContents(minecraft, leftX, topY, itemRenderer, font);
        }
    }

    private int renderTooltipLine(PoseStack poseStack, int leftX, int topY, Font font, double blitOffset, Component tooltip) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, blitOffset + 200.0);
        MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_92841_(tooltip, (float)leftX, (float)topY, 0xFFFFFF, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)renderTypeBuffer, false, 0, 0xF000F0);
        renderTypeBuffer.m_109911_();
        poseStack.m_85837_(0.0, 0.0, -(blitOffset + 200.0));
        poseStack.m_85849_();
        return topY + 10;
    }

    private int renderUpgrades(PoseStack matrixStack, int leftX, int topY, ItemRenderer itemRenderer) {
        int x = leftX;
        for (IUpgradeWrapper upgradeWrapper : upgrades) {
            if (upgradeWrapper.canBeDisabled()) {
                GuiHelper.blit(matrixStack, x, topY + 3, upgradeWrapper.isEnabled() ? UPGRADE_ON : UPGRADE_OFF);
                x += 4;
            }
            itemRenderer.m_115203_(upgradeWrapper.getUpgradeStack(), x, topY);
            itemRenderer.m_115203_(upgradeWrapper.getUpgradeStack(), x, topY);
            x += 18;
        }
        return topY += 20;
    }

    private void renderContents(Minecraft minecraft, int leftX, int topY, ItemRenderer itemRenderer, Font font) {
        int x = leftX;
        for (int i = 0; i < sortedContents.size(); ++i) {
            int y = topY + i / 9 * 20;
            if (i % 9 == 0) {
                x = leftX;
            }
            ItemStack stack = sortedContents.get(i);
            int stackWidth = Math.max(ClientBackpackContentsTooltip.getStackCountWidth(minecraft.f_91062_, stack), 18);
            int xOffset = stackWidth - 18;
            itemRenderer.m_115203_(stack, x + xOffset, y);
            itemRenderer.m_115174_(font, stack, x + xOffset, y, CountAbbreviator.abbreviate(stack.m_41613_()));
            x += stackWidth;
        }
    }
}

