/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntComparators;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackAccessLogger;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackSettingsManager;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackSettingsHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackUpgradeHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.NoopBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackBackgroundProperties;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackInventorySlot;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.HighStackCountSynchronizer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IFilterSlot;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SyncContainerClientDataMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ISlotColorCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.backpack.BackpackSettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.nosort.NoSortSettingsCategory;

public class BackpackContainer
extends AbstractContainerMenu
implements ISyncedContainer {
    public static final ResourceLocation EMPTY_UPGRADE_SLOT_BACKGROUND = new ResourceLocation("sophisticatedbackpacks", "item/empty_upgrade_slot");
    public static final int NUMBER_OF_PLAYER_SLOTS = 36;
    private static final String OPEN_TAB_ID_TAG = "openTabId";
    private static final String SORT_BY_TAG = "sortBy";
    private static final String UPGRADE_ENABLED_TAG = "upgradeEnabled";
    private static final String UPGRADE_SLOT_TAG = "upgradeSlot";
    private static final String ACTION_TAG = "action";
    private final IBackpackWrapper backpackWrapper;
    private final Player player;
    private int backpackSlotNumber = -1;
    private final BackpackContext backpackContext;
    private final Map<Integer, UpgradeContainerBase<?, ?>> upgradeContainers = new LinkedHashMap();
    private Consumer<BackpackContainer> upgradeChangeListener = null;
    private final BackpackBackgroundProperties backpackBackgroundProperties;
    public final NonNullList<ItemStack> lastUpgradeSlots = NonNullList.m_122779_();
    public final List<Slot> upgradeSlots = Lists.newArrayList();
    public final NonNullList<ItemStack> remoteUpgradeSlots = NonNullList.m_122779_();
    public final NonNullList<ItemStack> lastRealSlots = NonNullList.m_122779_();
    public final List<Slot> realInventorySlots = Lists.newArrayList();
    protected final NonNullList<ItemStack> remoteRealSlots = NonNullList.m_122779_();
    private final IBackpackWrapper parentBackpackWrapper;
    private final Map<Integer, ItemStack> slotStacksToUpdate = new HashMap<Integer, ItemStack>();
    private boolean isUpdatingFromPacket = false;
    private CompoundTag lastSettingsNbt = null;
    private long errorResultExpirationTime = 0L;
    @Nullable
    private UpgradeSlotChangeResult errorUpgradeSlotChangeResult;
    private static final Method ON_SWAP_CRAFT = ObfuscationReflectionHelper.findMethod(Slot.class, (String)"m_6405_", (Class[])new Class[]{Integer.TYPE});

    public Optional<UpgradeSlotChangeResult> getErrorUpgradeSlotChangeResult() {
        if (this.errorUpgradeSlotChangeResult != null && this.player.f_19853_.m_46467_() >= this.errorResultExpirationTime) {
            this.errorResultExpirationTime = 0L;
            this.errorUpgradeSlotChangeResult = null;
        }
        return Optional.ofNullable(this.errorUpgradeSlotChangeResult);
    }

    public BackpackContainer(int windowId, Player player, BackpackContext backpackContext) {
        super((MenuType)ModItems.BACKPACK_CONTAINER_TYPE.get(), windowId);
        this.player = player;
        this.backpackContext = backpackContext;
        this.parentBackpackWrapper = backpackContext.getParentBackpackWrapper(player).orElse(NoopBackpackWrapper.INSTANCE);
        this.backpackWrapper = backpackContext.getBackpackWrapper(player);
        this.removeOpenTabIfKeepOff();
        this.backpackWrapper.fillWithLoot(player);
        this.backpackBackgroundProperties = this.getNumberOfBackpackInventorySlots() + this.backpackWrapper.getColumnsTaken() * this.backpackWrapper.getNumberOfSlotRows() <= 81 ? BackpackBackgroundProperties.REGULAR : BackpackBackgroundProperties.WIDE;
        this.initSlotsAndContainers(player, backpackContext.getBackpackSlotIndex(), backpackContext.shouldLockBackpackSlot(player));
        this.backpackWrapper.getContentsUuid().ifPresent(backpackUuid -> {
            ItemStack backpack = this.backpackWrapper.getBackpack();
            BackpackAccessLogger.logPlayerAccess(player, backpack.m_41720_(), backpackUuid, backpack.m_41786_().getString(), this.backpackWrapper.getClothColor(), this.backpackWrapper.getBorderColor(), this.backpackWrapper.getColumnsTaken());
        });
    }

    private void sendBackpackSettingsToClient() {
        if (this.player.f_19853_.f_46443_) {
            return;
        }
        this.backpackWrapper.getContentsUuid().ifPresent(uuid -> {
            CompoundTag settingsContents = new CompoundTag();
            CompoundTag settingsNbt = this.backpackWrapper.getSettingsHandler().getNbt();
            if (!settingsNbt.m_128456_()) {
                settingsContents.m_128365_("settings", (Tag)settingsNbt);
                PacketHandler.sendToClient((ServerPlayer)this.player, new BackpackContentsMessage((UUID)uuid, settingsContents));
            }
        });
    }

    public IBackpackWrapper getParentBackpackWrapper() {
        return this.parentBackpackWrapper;
    }

    public int getColumnsTaken() {
        return this.backpackWrapper.getColumnsTaken();
    }

    private void initSlotsAndContainers(Player player, int backpackSlotIndex, boolean shouldLockBackpackSlot) {
        int yPosition = this.addBackpackInventorySlots();
        this.addPlayerInventorySlots(player.m_150109_(), yPosition, backpackSlotIndex, shouldLockBackpackSlot);
        this.addBackpackUpgradeSlots(yPosition);
        this.addUpgradeSettingsContainers(player);
    }

    private void addUpgradeSettingsContainers(Player player) {
        BackpackUpgradeHandler upgradeHandler = this.backpackWrapper.getUpgradeHandler();
        upgradeHandler.getSlotWrappers().forEach((slot, wrapper) -> UpgradeContainerRegistry.instantiateContainer(player, slot, wrapper).ifPresent(container -> this.upgradeContainers.put((Integer)slot, (UpgradeContainerBase<?, ?>)container)));
        for (UpgradeContainerBase<?, ?> container : this.upgradeContainers.values()) {
            container.getSlots().forEach(this::addUpgradeSlot);
            container.onInit();
        }
        this.backpackWrapper.getOpenTabId().ifPresent(id -> {
            if (this.upgradeContainers.containsKey(id)) {
                this.upgradeContainers.get(id).setIsOpen(true);
            }
        });
    }

    private void addBackpackUpgradeSlots(int lastInventoryRowY) {
        BackpackUpgradeHandler upgradeHandler = this.backpackWrapper.getUpgradeHandler();
        int numberOfSlots = upgradeHandler.getSlots();
        if (numberOfSlots == 0) {
            return;
        }
        int slotIndex = 0;
        int yPosition = lastInventoryRowY - 22 * numberOfSlots;
        while (slotIndex < upgradeHandler.getSlots()) {
            this.addUpgradeSlot((Slot)new BackpackUpgradeSlot(upgradeHandler, slotIndex, yPosition));
            ++slotIndex;
            yPosition += 22;
        }
    }

    protected void addUpgradeSlot(Slot slot) {
        slot.f_40219_ = this.getTotalSlotsNumber();
        this.upgradeSlots.add(slot);
        this.lastUpgradeSlots.add((Object)ItemStack.f_41583_);
        this.remoteUpgradeSlots.add((Object)ItemStack.f_41583_);
    }

    protected void addNoSortSlot(Slot slot) {
        slot.f_40219_ = this.getInventorySlotsSize();
        this.realInventorySlots.add(slot);
        this.lastRealSlots.add((Object)ItemStack.f_41583_);
        this.remoteRealSlots.add((Object)ItemStack.f_41583_);
    }

    protected Slot m_38897_(Slot slot) {
        slot.f_40219_ = this.getInventorySlotsSize();
        this.f_38839_.add((Object)slot);
        this.f_38841_.add((Object)ItemStack.f_41583_);
        this.f_150394_.add((Object)ItemStack.f_41583_);
        this.realInventorySlots.add(slot);
        this.lastRealSlots.add((Object)ItemStack.f_41583_);
        this.remoteRealSlots.add((Object)ItemStack.f_41583_);
        return slot;
    }

    public void setUpgradeChangeListener(Consumer<BackpackContainer> upgradeChangeListener) {
        this.upgradeChangeListener = upgradeChangeListener;
    }

    private int addBackpackInventorySlots() {
        BackpackInventoryHandler inventoryHandler = this.backpackWrapper.getInventoryHandler();
        int slotIndex = 0;
        int yPosition = 18;
        Set<Integer> noSortSlotIndexes = this.getNoSortSlotIndexes();
        while (slotIndex < inventoryHandler.getSlots()) {
            int lineIndex = slotIndex % this.getSlotsOnLine();
            int finalSlotIndex = slotIndex;
            BackpackInventorySlot slot = new BackpackInventorySlot(this.player.f_19853_.f_46443_, this.backpackWrapper, inventoryHandler, finalSlotIndex, lineIndex, yPosition);
            if (noSortSlotIndexes.contains(slotIndex)) {
                this.addNoSortSlot((Slot)slot);
            } else {
                this.m_38897_((Slot)slot);
            }
            if (++slotIndex % this.getSlotsOnLine() != 0) continue;
            yPosition += 18;
        }
        return this.getNumberOfRows() * 18 + 18;
    }

    private void addPlayerInventorySlots(Inventory playerInventory, int yPosition, int backpackSlotIndex, boolean shouldLockBackpackSlot) {
        int playerInventoryXOffset = this.backpackBackgroundProperties.getPlayerInventoryXOffset();
        yPosition += 14;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slotIndex = j + i * 9 + 9;
                int xPosition = playerInventoryXOffset + 8 + j * 18;
                Slot slot = this.addBackpackSafeSlot(playerInventory, yPosition, slotIndex, xPosition, backpackSlotIndex, shouldLockBackpackSlot);
                this.addSlotAndUpdateBackpackSlotNumber(backpackSlotIndex, shouldLockBackpackSlot, slotIndex, slot);
            }
            yPosition += 18;
        }
        yPosition += 4;
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            int xPosition = playerInventoryXOffset + 8 + slotIndex * 18;
            Slot slot = this.addBackpackSafeSlot(playerInventory, yPosition, slotIndex, xPosition, backpackSlotIndex, shouldLockBackpackSlot);
            this.addSlotAndUpdateBackpackSlotNumber(backpackSlotIndex, shouldLockBackpackSlot, slotIndex, slot);
        }
    }

    public void m_182410_(int stateId, List<ItemStack> items, ItemStack carried) {
        this.backpackWrapper.setPersistent(this.player.f_19853_.f_46443_);
        this.isUpdatingFromPacket = true;
        super.m_182410_(stateId, items, carried);
        this.isUpdatingFromPacket = false;
        this.backpackWrapper.setPersistent(true);
        this.backpackWrapper.getInventoryHandler().saveInventory();
        this.backpackWrapper.getUpgradeHandler().saveInventory();
    }

    private Slot addBackpackSafeSlot(Inventory playerInventory, int yPosition, int slotIndex, int xPosition, int backpackSlotIndex, boolean shouldLockBackpackSlot) {
        Slot slot = shouldLockBackpackSlot && slotIndex == backpackSlotIndex ? new Slot((Container)playerInventory, slotIndex, xPosition, yPosition){

            public boolean m_8010_(Player playerIn) {
                return false;
            }

            public void m_6654_() {
                super.m_6654_();
                BackpackContainer.this.closeBackpackScreenIfSomethingMessedWithBackpackStack(this.m_7993_());
            }
        } : new Slot((Container)playerInventory, slotIndex, xPosition, yPosition);
        return this.m_38897_(slot);
    }

    public void closeBackpackScreenIfSomethingMessedWithBackpackStack(ItemStack supposedToBeBackpackStack) {
        if (!this.isClientSide() && this.isNotCorrectBackpack(supposedToBeBackpackStack)) {
            this.player.m_6915_();
        }
    }

    private boolean isNotCorrectBackpack(ItemStack supposedToBeBackpackStack) {
        return supposedToBeBackpackStack.m_41619_() || !(supposedToBeBackpackStack.m_41720_() instanceof BackpackItem) || supposedToBeBackpackStack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(w -> w != (this.isFirstLevelBackpack() ? this.backpackWrapper : this.parentBackpackWrapper)).orElse(true) != false;
    }

    private boolean isClientSide() {
        return this.player.f_19853_.f_46443_;
    }

    private void addSlotAndUpdateBackpackSlotNumber(int backpackSlotIndex, boolean lockBackpackSlot, int slotIndex, Slot slot) {
        if (lockBackpackSlot && slotIndex == backpackSlotIndex) {
            this.backpackSlotNumber = slot.f_40219_;
        }
    }

    public int getNumberOfRows() {
        return this.backpackWrapper.getNumberOfSlotRows();
    }

    public int getSlotsOnLine() {
        return this.backpackBackgroundProperties.getSlotsOnLine() - this.backpackWrapper.getColumnsTaken();
    }

    public boolean m_6875_(Player player) {
        return this.backpackContext.canInteractWith(player);
    }

    public static BackpackContainer fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        return new BackpackContainer(windowId, playerInventory.f_35978_, BackpackContext.fromBuffer(packetBuffer));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            Optional<UpgradeContainerBase<?, ?>> upgradeContainer = this.getSlotUpgradeContainer(slot);
            ItemStack slotStack = upgradeContainer.map(c -> c.getSlotStackToTransfer(slot)).orElse(slot.m_7993_());
            itemstack = slotStack.m_41777_();
            if (!this.mergeSlotStack(slot, index, slotStack)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_40234_(slotStack, itemstack);
            if (upgradeContainer.isPresent()) {
                upgradeContainer.ifPresent(c -> c.onTakeFromSlot(slot, this.player, slotStack));
            } else {
                slot.m_142406_(this.player, slotStack);
            }
        }
        return itemstack;
    }

    private boolean mergeSlotStack(Slot slot, int index, ItemStack slotStack) {
        if (this.isUpgradeSlot(index)) {
            return this.mergeStackToBackpack(slotStack) || this.mergeStackToPlayersInventory(slotStack);
        }
        if (this.isBackpackInventorySlot(index)) {
            if (this.shouldShiftClickIntoOpenTabFirst()) {
                return this.mergeStackToOpenUpgradeTab(slotStack) || this.mergeStackToPlayersInventory(slotStack);
            }
            return this.mergeStackToPlayersInventory(slotStack) || this.mergeStackToOpenUpgradeTab(slotStack);
        }
        if (this.isUpgradeSettingsSlot(index)) {
            if (this.getSlotUpgradeContainer(slot).map(c -> c.mergeIntoBackpackFirst(slot)).orElse(true).booleanValue()) {
                return this.mergeStackToBackpack(slotStack) || this.mergeStackToPlayersInventory(slotStack);
            }
            return this.mergeStackToPlayersInventory(slotStack) || this.mergeStackToBackpack(slotStack);
        }
        if (this.shouldShiftClickIntoOpenTabFirst()) {
            return this.mergeStackToOpenUpgradeTab(slotStack) || this.mergeStackToUpgradeSlots(slotStack) || this.mergeStackToBackpack(slotStack);
        }
        return this.mergeStackToUpgradeSlots(slotStack) || this.mergeStackToBackpack(slotStack) || this.mergeStackToOpenUpgradeTab(slotStack);
    }

    private boolean shouldShiftClickIntoOpenTabFirst() {
        return BackpackSettingsManager.getBackpackSettingValue(this.player, this.backpackWrapper.getSettingsHandler().getTypeCategory(BackpackSettingsCategory.class), BackpackSettingsManager.SHIFT_CLICK_INTO_OPEN_TAB_FIRST);
    }

    public Optional<ItemStack> getMemorizedStackInSlot(int slotId) {
        return this.backpackWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).getSlotFilterItem(slotId).map(ItemStack::new);
    }

    private boolean mergeStackToUpgradeSlots(ItemStack slotStack) {
        return !this.upgradeSlots.isEmpty() && this.m_38903_(slotStack, this.getInventorySlotsSize(), this.getInventorySlotsSize() + this.getNumberOfUpgradeSlots(), false);
    }

    public int getInventorySlotsSize() {
        return this.realInventorySlots.size();
    }

    private boolean mergeStackToOpenUpgradeTab(ItemStack slotStack) {
        return this.getOpenContainer().map(c -> {
            List<Slot> slots = c.getSlots();
            if (slots.isEmpty()) {
                return false;
            }
            int firstSlotIndex = slots.get((int)0).f_40219_;
            int lastSlotIndex = slots.get((int)(slots.size() - 1)).f_40219_;
            return this.mergeItemStack(slotStack, firstSlotIndex, lastSlotIndex + 1, false, true);
        }).orElse(false);
    }

    private boolean mergeStackToBackpack(ItemStack slotStack) {
        return this.m_38903_(slotStack, 0, this.getNumberOfBackpackInventorySlots(), false);
    }

    private boolean mergeStackToPlayersInventory(ItemStack slotStack) {
        return this.mergeItemStack(slotStack, this.getNumberOfBackpackInventorySlots(), this.getInventorySlotsSize(), true, true);
    }

    public boolean isPlayersInventorySlot(int slotNumber) {
        return slotNumber >= this.getNumberOfBackpackInventorySlots() && slotNumber < this.getInventorySlotsSize();
    }

    private boolean isUpgradeSettingsSlot(int index) {
        return index >= this.getNumberOfBackpackInventorySlots() + this.getNumberOfUpgradeSlots() + 36;
    }

    public boolean isBackpackInventorySlot(int index) {
        return index < this.getNumberOfBackpackInventorySlots();
    }

    private boolean isUpgradeSlot(int index) {
        return index >= this.getFirstUpgradeSlot() && index - this.getFirstUpgradeSlot() < this.getNumberOfUpgradeSlots();
    }

    public int getFirstUpgradeSlot() {
        return this.getInventorySlotsSize();
    }

    public Optional<UpgradeContainerBase<?, ?>> getSlotUpgradeContainer(Slot slot) {
        if (this.isUpgradeSettingsSlot(slot.f_40219_)) {
            for (UpgradeContainerBase<?, ?> upgradeContainer : this.upgradeContainers.values()) {
                if (!upgradeContainer.containsSlot(slot)) continue;
                return Optional.of(upgradeContainer);
            }
        }
        return Optional.empty();
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        if (this.isUpgradeSettingsSlot(slotId) && this.m_38853_(slotId) instanceof IFilterSlot && this.m_38853_(slotId).m_5857_(this.m_142621_())) {
            Slot slot = this.m_38853_(slotId);
            ItemStack cursorStack = this.m_142621_().m_41777_();
            if (cursorStack.m_41613_() > 1) {
                cursorStack.m_41764_(1);
            }
            slot.m_5852_(cursorStack);
            return;
        }
        if (this.isUpgradeSlot(slotId) && this.m_38853_(slotId) instanceof BackpackUpgradeSlot) {
            Slot slot = this.m_38853_(slotId);
            ItemStack slotStack = slot.m_7993_();
            if (slot.m_5857_(this.m_142621_())) {
                BackpackUpgradeSlot upgradeSlot = (BackpackUpgradeSlot)slot;
                ItemStack cursorStack = this.m_142621_();
                IBackpackUpgradeItem backpackUpgradeItem = (IBackpackUpgradeItem)cursorStack.m_41720_();
                int newColumnsTaken = backpackUpgradeItem.getInventoryColumnsTaken();
                int currentColumnsTaken = 0;
                if (!slotStack.m_41619_()) {
                    currentColumnsTaken = ((IBackpackUpgradeItem)slotStack.m_41720_()).getInventoryColumnsTaken();
                }
                if (this.needsSlotsThatAreOccupied(cursorStack, currentColumnsTaken, upgradeSlot, newColumnsTaken)) {
                    return;
                }
                int columnsToRemove = newColumnsTaken - currentColumnsTaken;
                if (slotStack.m_41619_() || upgradeSlot.canSwapStack(player, cursorStack)) {
                    this.m_142503_(slotStack);
                    upgradeSlot.m_5852_(cursorStack);
                    this.updateColumnsTaken(columnsToRemove);
                    upgradeSlot.m_6654_();
                }
            } else if ((this.m_142621_().m_41619_() || slot.m_5857_(this.m_142621_())) && !slotStack.m_41619_() && slot.m_8010_(player)) {
                int k2 = dragType == 0 ? Math.min(slotStack.m_41613_(), slotStack.m_41741_()) : Math.min(slotStack.m_41741_() + 1, slotStack.m_41613_() + 1) / 2;
                int columnsTaken = ((IBackpackUpgradeItem)slotStack.m_41720_()).getInventoryColumnsTaken();
                if (clickType == ClickType.QUICK_MOVE) {
                    this.m_7648_(player, slotId);
                } else {
                    this.m_142503_(slot.m_6201_(k2));
                }
                this.updateColumnsTaken(-columnsTaken);
                slot.m_142406_(player, this.m_142621_());
            }
            return;
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    private void updateColumnsTaken(int columnsToRemove) {
        if (columnsToRemove != 0) {
            this.backpackWrapper.setColumnsTaken(Math.max(0, this.backpackWrapper.getColumnsTaken() + columnsToRemove));
            this.backpackWrapper.onContentsNbtUpdated();
            this.refreshAllSlots();
        }
    }

    private boolean needsSlotsThatAreOccupied(ItemStack cursorStack, int currentColumnsTaken, BackpackUpgradeSlot upgradeSlot, int newColumnsTaken) {
        if (currentColumnsTaken >= newColumnsTaken) {
            return false;
        }
        int slotsToCheck = (newColumnsTaken - currentColumnsTaken) * this.getNumberOfRows();
        BackpackInventoryHandler invHandler = this.backpackWrapper.getInventoryHandler();
        HashSet<Integer> errorSlots = new HashSet<Integer>();
        int slots = this.getNumberOfBackpackInventorySlots();
        for (int slotIndex = slots - 1; slotIndex >= slots - slotsToCheck; --slotIndex) {
            if (invHandler.getStackInSlot(slotIndex).m_41619_()) continue;
            errorSlots.add(slotIndex);
        }
        if (!errorSlots.isEmpty()) {
            upgradeSlot.updateSlotChangeError(new UpgradeSlotChangeResult.Fail(TranslationHelper.translError("add.needs_occupied_inventory_slots", slotsToCheck, cursorStack.m_41786_()), Collections.emptySet(), errorSlots, Collections.emptySet()));
            return true;
        }
        return false;
    }

    public int getNumberOfBackpackInventorySlots() {
        return this.backpackWrapper.getInventoryHandler().getSlots();
    }

    public BackpackBackgroundProperties getBackpackBackgroundProperties() {
        return this.backpackBackgroundProperties;
    }

    public int getNumberOfUpgradeSlots() {
        return this.backpackWrapper.getUpgradeHandler().getSlots();
    }

    public Map<Integer, UpgradeContainerBase<?, ?>> getUpgradeContainers() {
        return this.upgradeContainers;
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_("containerId")) {
            int containerId = data.m_128451_("containerId");
            if (this.upgradeContainers.containsKey(containerId)) {
                this.upgradeContainers.get(containerId).handleMessage(data);
            }
        } else if (data.m_128441_(OPEN_TAB_ID_TAG)) {
            this.setOpenTabId(data.m_128451_(OPEN_TAB_ID_TAG));
        } else if (data.m_128441_(SORT_BY_TAG)) {
            this.setSortBy(SortBy.fromName(data.m_128461_(SORT_BY_TAG)));
        } else if (data.m_128441_(ACTION_TAG)) {
            String actionName;
            switch (actionName = data.m_128461_(ACTION_TAG)) {
                case "sort": {
                    this.sort();
                    break;
                }
                case "openSettings": {
                    this.openSettings();
                    break;
                }
            }
        } else if (data.m_128441_(UPGRADE_ENABLED_TAG)) {
            this.setUpgradeEnabled(data.m_128451_(UPGRADE_SLOT_TAG), data.m_128471_(UPGRADE_ENABLED_TAG));
        }
    }

    public void setOpenTabId(int tabId) {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.m_128405_(OPEN_TAB_ID_TAG, tabId));
        }
        if (tabId == -1) {
            this.backpackWrapper.removeOpenTabId();
        } else {
            this.backpackWrapper.setOpenTabId(tabId);
        }
    }

    public void removeOpenTabId() {
        this.setOpenTabId(-1);
    }

    public SortBy getSortBy() {
        return this.backpackWrapper.getSortBy();
    }

    private void sendToServer(Consumer<CompoundTag> addData) {
        CompoundTag data = new CompoundTag();
        addData.accept(data);
        PacketHandler.sendToServer(new SyncContainerClientDataMessage(data));
    }

    public void setSortBy(SortBy sortBy) {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.m_128359_(SORT_BY_TAG, sortBy.m_7912_()));
        }
        this.backpackWrapper.setSortBy(sortBy);
    }

    public void sort() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.m_128359_(ACTION_TAG, "sort"));
            return;
        }
        this.backpackWrapper.sort();
    }

    public boolean isFirstLevelBackpack() {
        return this.parentBackpackWrapper == NoopBackpackWrapper.INSTANCE;
    }

    public BackpackContext getBackpackContext() {
        return this.backpackContext;
    }

    public boolean canDisableUpgrade(int upgradeSlot) {
        Map<Integer, IUpgradeWrapper> slotWrappers = this.backpackWrapper.getUpgradeHandler().getSlotWrappers();
        if (!slotWrappers.containsKey(upgradeSlot)) {
            return false;
        }
        return slotWrappers.get(upgradeSlot).canBeDisabled();
    }

    public boolean getUpgradeEnabled(int upgradeSlot) {
        Map<Integer, IUpgradeWrapper> slotWrappers = this.backpackWrapper.getUpgradeHandler().getSlotWrappers();
        if (!slotWrappers.containsKey(upgradeSlot)) {
            return false;
        }
        return slotWrappers.get(upgradeSlot).isEnabled();
    }

    public void setUpgradeEnabled(int upgradeSlot, boolean enabled) {
        Map<Integer, IUpgradeWrapper> slotWrappers = this.backpackWrapper.getUpgradeHandler().getSlotWrappers();
        if (!slotWrappers.containsKey(upgradeSlot)) {
            return;
        }
        if (this.isClientSide()) {
            this.sendToServer(data -> {
                data.m_128379_(UPGRADE_ENABLED_TAG, enabled);
                data.m_128405_(UPGRADE_SLOT_TAG, upgradeSlot);
            });
        }
        slotWrappers.get(upgradeSlot).setEnabled(enabled);
    }

    public Optional<UpgradeContainerBase<?, ?>> getOpenContainer() {
        return this.backpackWrapper.getOpenTabId().flatMap(id -> this.upgradeContainers.containsKey(id) ? Optional.of(this.upgradeContainers.get(id)) : Optional.empty());
    }

    public void openSettings() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.m_128359_(ACTION_TAG, "openSettings"));
            return;
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)this.player), (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new SettingsContainer(w, pl, this.backpackContext), (Component)new TranslatableComponent(TranslationHelper.translGui("settings.title"))), this.backpackContext::toBuffer);
    }

    public List<Integer> getSlotOverlayColors(int slot) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        this.backpackWrapper.getSettingsHandler().getCategoriesThatImplement(ISlotColorCategory.class).forEach(c -> c.getSlotColor(slot).ifPresent(ret::add));
        return ret;
    }

    public int getUpgradeSlotsSize() {
        return this.upgradeSlots.size();
    }

    public <T extends UpgradeContainerBase<?, ?>> Optional<T> getOpenOrFirstCraftingContainer() {
        UpgradeContainerBase<?, ?> firstContainer = null;
        for (UpgradeContainerBase<?, ?> container : this.upgradeContainers.values()) {
            if (!(container instanceof ICraftingContainer)) continue;
            if (container.isOpen()) {
                return Optional.of(container);
            }
            if (firstContainer != null) continue;
            firstContainer = container;
        }
        return Optional.ofNullable(firstContainer);
    }

    public NonNullList<ItemStack> m_38927_() {
        NonNullList list = NonNullList.m_122779_();
        this.realInventorySlots.forEach(slot -> list.add((Object)slot.m_7993_()));
        this.upgradeSlots.forEach(upgradeSlot -> list.add((Object)upgradeSlot.m_7993_()));
        return list;
    }

    public int getTotalSlotsNumber() {
        return this.getInventorySlotsSize() + this.upgradeSlots.size();
    }

    public void m_38946_() {
        if (this.backpackSlotNumber != -1) {
            this.closeBackpackScreenIfSomethingMessedWithBackpackStack(this.m_38853_(this.backpackSlotNumber).m_7993_());
        }
        this.m_150445_();
        this.broadcastChangesIn(this.lastUpgradeSlots, this.remoteUpgradeSlots, this.upgradeSlots, this.getFirstUpgradeSlot());
        this.broadcastChangesIn(this.lastRealSlots, this.remoteRealSlots, this.realInventorySlots, 0);
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)this.backpackWrapper.getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = this.backpackWrapper.getSettingsHandler().getNbt().m_6426_();
            this.sendBackpackSettingsToClient();
            this.refreshInventorySlotsIfNeeded();
        }
    }

    public void m_182423_() {
        this.broadcastFullStateOf(this.lastUpgradeSlots, this.upgradeSlots, this.getFirstUpgradeSlot());
        this.broadcastFullStateOf(this.lastRealSlots, this.realInventorySlots, 0);
        this.m_150429_();
    }

    private void broadcastFullStateOf(NonNullList<ItemStack> lastSlotsCollection, List<Slot> slotsCollection, int slotIndexOffset) {
        for (int i = 0; i < slotsCollection.size(); ++i) {
            ItemStack itemstack = slotsCollection.get(i).m_7993_();
            this.triggerSlotListeners(i, itemstack, () -> ((ItemStack)itemstack).m_41777_(), lastSlotsCollection, slotIndexOffset);
        }
    }

    private void broadcastChangesIn(NonNullList<ItemStack> lastSlotsCollection, NonNullList<ItemStack> remoteSlotsCollection, List<Slot> slotsCollection, int slotIndexOffset) {
        for (int i = 0; i < slotsCollection.size(); ++i) {
            ItemStack itemstack = slotsCollection.get(i).m_7993_();
            com.google.common.base.Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).m_41777_());
            this.triggerSlotListeners(i, itemstack, (Supplier<ItemStack>)supplier, lastSlotsCollection, slotIndexOffset);
            this.synchronizeSlotToRemote(i, itemstack, (Supplier<ItemStack>)supplier, remoteSlotsCollection, slotIndexOffset);
        }
    }

    private void triggerSlotListeners(int stackIndex, ItemStack slotStack, Supplier<ItemStack> slotStackCopy, NonNullList<ItemStack> lastSlotsCollection, int slotIndexOffset) {
        ItemStack itemstack = (ItemStack)lastSlotsCollection.get(stackIndex);
        if (!ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)slotStack)) {
            boolean clientStackChanged = !slotStack.equals(itemstack, true);
            ItemStack stackCopy = slotStackCopy.get();
            lastSlotsCollection.set(stackIndex, (Object)stackCopy);
            if (clientStackChanged) {
                for (ContainerListener containerlistener : this.f_38848_) {
                    containerlistener.m_7934_((AbstractContainerMenu)this, stackIndex + slotIndexOffset, stackCopy);
                }
            }
        }
    }

    private void synchronizeSlotToRemote(int slotIndex, ItemStack slotStack, Supplier<ItemStack> slotStackCopy, NonNullList<ItemStack> remoteSlotsCollection, int slotIndexOffset) {
        ItemStack itemstack;
        if (!this.f_150398_ && !ItemStack.m_41728_((ItemStack)(itemstack = (ItemStack)remoteSlotsCollection.get(slotIndex)), (ItemStack)slotStack)) {
            ItemStack stackCopy = slotStackCopy.get();
            remoteSlotsCollection.set(slotIndex, (Object)stackCopy);
            if (this.f_150397_ != null) {
                this.f_150397_.m_142074_((AbstractContainerMenu)this, slotIndex + slotIndexOffset, stackCopy);
            }
        }
    }

    private void refreshInventorySlotsIfNeeded() {
        Set<Integer> noSortSlotIndexes = this.getNoSortSlotIndexes();
        boolean needRefresh = false;
        if (this.realInventorySlots.size() - this.f_38839_.size() != noSortSlotIndexes.size()) {
            needRefresh = true;
        } else {
            for (Slot slot : this.realInventorySlots) {
                if (this.f_38839_.contains((Object)slot) || noSortSlotIndexes.contains(slot.f_40219_)) continue;
                needRefresh = true;
                break;
            }
        }
        if (!needRefresh) {
            return;
        }
        this.f_38839_.clear();
        this.f_38841_.clear();
        this.realInventorySlots.clear();
        this.lastRealSlots.clear();
        this.remoteRealSlots.clear();
        int yPosition = this.addBackpackInventorySlots();
        this.addPlayerInventorySlots(this.player.m_150109_(), yPosition, this.backpackContext.getBackpackSlotIndex(), this.backpackContext.shouldLockBackpackSlot(this.player));
    }

    private void refreshAllSlots() {
        this.f_38839_.clear();
        this.f_38841_.clear();
        this.realInventorySlots.clear();
        this.lastRealSlots.clear();
        this.remoteRealSlots.clear();
        this.upgradeSlots.clear();
        this.lastUpgradeSlots.clear();
        this.remoteUpgradeSlots.clear();
        this.upgradeContainers.clear();
        this.initSlotsAndContainers(this.player, this.backpackContext.getBackpackSlotIndex(), this.backpackContext.shouldLockBackpackSlot(this.player));
    }

    private Set<Integer> getNoSortSlotIndexes() {
        BackpackSettingsHandler settingsHandler = this.backpackWrapper.getSettingsHandler();
        HashSet<Integer> slotIndexesExcludedFromSort = new HashSet<Integer>();
        slotIndexesExcludedFromSort.addAll(settingsHandler.getTypeCategory(NoSortSettingsCategory.class).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(settingsHandler.getTypeCategory(MemorySettingsCategory.class).getSlotIndexes());
        return slotIndexesExcludedFromSort;
    }

    public void detectSettingsChangeAndReload() {
        this.backpackWrapper.getContentsUuid().ifPresent(uuid -> {
            BackpackStorage storage = BackpackStorage.get();
            if (storage.removeUpdatedBackpackSettingsFlag((UUID)uuid)) {
                this.backpackWrapper.getSettingsHandler().reloadFrom(storage.getOrCreateBackpackContents((UUID)uuid));
                this.refreshInventorySlotsIfNeeded();
            }
        });
    }

    public Slot m_38853_(int slotId) {
        if (slotId >= this.getInventorySlotsSize()) {
            return this.upgradeSlots.get(slotId - this.getInventorySlotsSize());
        }
        return this.realInventorySlots.get(slotId);
    }

    private void onSwapCraft(Slot slot, int numItemsCrafted) {
        try {
            ON_SWAP_CRAFT.invoke((Object)slot, numItemsCrafted);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            SophisticatedBackpacks.LOGGER.error("Error invoking onSwapCraft method in Slot class", (Throwable)e);
        }
    }

    protected void m_150430_(int slotId, int dragType, ClickType clickType, Player player) {
        block67: {
            block70: {
                ItemStack slotStack;
                ItemStack itemstack4;
                Slot slot2;
                Inventory inventory;
                block72: {
                    block71: {
                        block69: {
                            ClickAction clickaction;
                            block68: {
                                block66: {
                                    inventory = player.m_150109_();
                                    if (clickType != ClickType.QUICK_CRAFT) break block66;
                                    int i = this.f_38846_;
                                    this.f_38846_ = BackpackContainer.m_38947_((int)dragType);
                                    if ((i != 1 || this.f_38846_ != 2) && i != this.f_38846_) {
                                        this.m_38951_();
                                    } else if (this.m_142621_().m_41619_()) {
                                        this.m_38951_();
                                    } else if (this.f_38846_ == 0) {
                                        this.f_38845_ = BackpackContainer.m_38928_((int)dragType);
                                        if (BackpackContainer.m_38862_((int)this.f_38845_, (Player)player)) {
                                            this.f_38846_ = 1;
                                            this.f_38847_.clear();
                                        } else {
                                            this.m_38951_();
                                        }
                                    } else if (this.f_38846_ == 1) {
                                        ItemStack itemstack;
                                        Slot slot = this.m_38853_(slotId);
                                        if (BackpackContainer.canItemQuickReplace(slot, itemstack = this.m_142621_()) && slot.m_5857_(itemstack) && (this.f_38845_ == 2 || itemstack.m_41613_() > this.f_38847_.size()) && this.m_5622_(slot)) {
                                            this.f_38847_.add(slot);
                                        }
                                    } else if (this.f_38846_ == 2) {
                                        if (!this.f_38847_.isEmpty()) {
                                            if (this.f_38847_.size() == 1) {
                                                int l = ((Slot)this.f_38847_.iterator().next()).f_40219_;
                                                this.m_38951_();
                                                this.m_150430_(l, this.f_38845_, ClickType.PICKUP, player);
                                                return;
                                            }
                                            ItemStack carried = this.m_142621_().m_41777_();
                                            int j1 = this.m_142621_().m_41613_();
                                            for (Slot slot1 : this.f_38847_) {
                                                ItemStack itemstack1 = this.m_142621_();
                                                if (slot1 == null || !BackpackContainer.canItemQuickReplace(slot1, itemstack1) || !slot1.m_5857_(itemstack1) || this.f_38845_ != 2 && itemstack1.m_41613_() < this.f_38847_.size() || !this.m_5622_(slot1)) continue;
                                                ItemStack carriedCopy = carried.m_41777_();
                                                int j = slot1.m_6657_() ? slot1.m_7993_().m_41613_() : 0;
                                                BackpackContainer.m_38922_((Set)this.f_38847_, (int)this.f_38845_, (ItemStack)carriedCopy, (int)j);
                                                int slotStackLimit = slot1.m_5866_(carriedCopy);
                                                if (!(slot1 instanceof BackpackInventorySlot) && slotStackLimit > carriedCopy.m_41741_()) {
                                                    slotStackLimit = carriedCopy.m_41741_();
                                                }
                                                if (carriedCopy.m_41613_() > slotStackLimit) {
                                                    carriedCopy.m_41764_(slotStackLimit);
                                                }
                                                j1 -= carriedCopy.m_41613_() - j;
                                                slot1.m_5852_(carriedCopy);
                                            }
                                            carried.m_41764_(j1);
                                            this.m_142503_(carried);
                                        }
                                        this.m_38951_();
                                    } else {
                                        this.m_38951_();
                                    }
                                    break block67;
                                }
                                if (this.f_38846_ == 0) break block68;
                                this.m_38951_();
                                break block67;
                            }
                            if (clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1) break block69;
                            ClickAction clickAction = clickaction = dragType == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
                            if (slotId == -999) {
                                if (!this.m_142621_().m_41619_()) {
                                    if (clickaction == ClickAction.PRIMARY) {
                                        player.m_36176_(this.m_142621_(), true);
                                        this.m_142503_(ItemStack.f_41583_);
                                    } else {
                                        player.m_36176_(this.m_142621_().m_41620_(1), true);
                                    }
                                }
                            } else if (clickType == ClickType.QUICK_MOVE) {
                                if (slotId < 0) {
                                    return;
                                }
                                Slot slot6 = this.m_38853_(slotId);
                                if (!slot6.m_8010_(player)) {
                                    return;
                                }
                                if (this.isBackpackInventorySlot(slotId)) {
                                    this.m_7648_(this.player, slotId).m_41777_();
                                } else {
                                    ItemStack itemstack8 = this.m_7648_(this.player, slotId);
                                    while (!itemstack8.m_41619_() && ItemStack.m_41746_((ItemStack)slot6.m_7993_(), (ItemStack)itemstack8)) {
                                        itemstack8 = this.m_7648_(this.player, slotId);
                                    }
                                }
                            } else {
                                if (slotId < 0) {
                                    return;
                                }
                                Slot slot7 = this.m_38853_(slotId);
                                ItemStack slotStack2 = slot7.m_7993_();
                                ItemStack carriedStack = this.m_142621_();
                                player.m_141945_(carriedStack, slot7.m_7993_(), clickaction);
                                if (!carriedStack.m_150926_(slot7, clickaction, player) && !slotStack2.m_150932_(carriedStack, slot7, clickaction, player, this.m_150446_())) {
                                    if (slotStack2.m_41619_()) {
                                        if (!carriedStack.m_41619_()) {
                                            int l2 = clickaction == ClickAction.PRIMARY ? carriedStack.m_41613_() : 1;
                                            this.m_142503_(slot7.m_150656_(carriedStack, l2));
                                        }
                                    } else if (slot7.m_8010_(player)) {
                                        if (carriedStack.m_41619_()) {
                                            int i3 = clickaction == ClickAction.PRIMARY ? Math.min(slotStack2.m_41613_(), slotStack2.m_41741_()) : Math.min(slotStack2.m_41741_() + 1, slotStack2.m_41613_() + 1) / 2;
                                            Optional optional1 = slot7.m_150641_(i3, Integer.MAX_VALUE, player);
                                            optional1.ifPresent(p_150421_ -> {
                                                this.m_142503_((ItemStack)p_150421_);
                                                slot7.m_142406_(player, p_150421_);
                                            });
                                        } else if (slot7.m_5857_(carriedStack)) {
                                            if (ItemStack.m_150942_((ItemStack)slotStack2, (ItemStack)carriedStack)) {
                                                int j3 = clickaction == ClickAction.PRIMARY ? carriedStack.m_41613_() : 1;
                                                this.m_142503_(slot7.m_150656_(carriedStack, j3));
                                            } else if (carriedStack.m_41613_() <= slot7.m_5866_(carriedStack)) {
                                                slot7.m_5852_(carriedStack);
                                                this.m_142503_(slotStack2);
                                            }
                                        } else if (ItemStack.m_150942_((ItemStack)slotStack2, (ItemStack)carriedStack)) {
                                            Optional optional = slot7.m_150641_(slotStack2.m_41613_(), carriedStack.m_41741_() - carriedStack.m_41613_(), player);
                                            optional.ifPresent(p_150428_ -> {
                                                carriedStack.m_41769_(p_150428_.m_41613_());
                                                slot7.m_142406_(player, p_150428_);
                                            });
                                        }
                                    }
                                }
                                slot7.m_6654_();
                            }
                            break block67;
                        }
                        if (clickType != ClickType.SWAP) break block70;
                        slot2 = this.m_38853_(slotId);
                        itemstack4 = inventory.m_8020_(dragType);
                        slotStack = slot2.m_7993_();
                        if (itemstack4.m_41619_() && slotStack.m_41619_()) break block67;
                        if (!itemstack4.m_41619_()) break block71;
                        if (slot2.m_8010_(player)) {
                            if (slotStack.m_41613_() <= slotStack.m_41741_()) {
                                inventory.m_6836_(dragType, slotStack);
                                this.onSwapCraft(slot2, slotStack.m_41613_());
                                slot2.m_5852_(ItemStack.f_41583_);
                                slot2.m_142406_(player, slotStack);
                            } else {
                                inventory.m_6836_(dragType, slotStack.m_41620_(slotStack.m_41741_()));
                                slot2.m_6654_();
                            }
                        }
                        break block67;
                    }
                    if (!slotStack.m_41619_()) break block72;
                    if (slot2.m_5857_(itemstack4)) {
                        int l1 = slot2.m_5866_(itemstack4);
                        if (itemstack4.m_41613_() > l1) {
                            slot2.m_5852_(itemstack4.m_41620_(l1));
                        } else {
                            slot2.m_5852_(itemstack4);
                            inventory.m_6836_(dragType, ItemStack.f_41583_);
                        }
                    }
                    break block67;
                }
                if (slotStack.m_41613_() > slotStack.m_41741_() || !slot2.m_8010_(player) || !slot2.m_5857_(itemstack4)) break block67;
                int i2 = slot2.m_5866_(itemstack4);
                if (itemstack4.m_41613_() > i2) {
                    slot2.m_5852_(itemstack4.m_41620_(i2));
                    slot2.m_142406_(player, slotStack);
                    if (!inventory.m_36054_(slotStack)) {
                        player.m_36176_(slotStack, true);
                    }
                } else {
                    slot2.m_5852_(itemstack4);
                    inventory.m_6836_(dragType, slotStack);
                    slot2.m_142406_(player, slotStack);
                }
                break block67;
            }
            if (clickType == ClickType.CLONE && player.m_150110_().f_35937_ && this.m_142621_().m_41619_() && slotId >= 0) {
                Slot slot5 = this.m_38853_(slotId);
                if (slot5.m_6657_()) {
                    ItemStack itemstack6 = slot5.m_7993_().m_41777_();
                    itemstack6.m_41764_(itemstack6.m_41741_());
                    this.m_142503_(itemstack6);
                }
            } else if (clickType == ClickType.THROW && this.m_142621_().m_41619_() && slotId >= 0) {
                Slot slot4 = this.m_38853_(slotId);
                int i1 = dragType == 0 ? 1 : slot4.m_7993_().m_41613_();
                ItemStack itemstack8 = slot4.m_150647_(i1, slot4.m_7993_().m_41741_(), player);
                player.m_36176_(itemstack8, true);
            } else if (clickType == ClickType.PICKUP_ALL && slotId >= 0) {
                Slot slot3 = this.m_38853_(slotId);
                ItemStack carriedStack = this.m_142621_();
                if (!(carriedStack.m_41619_() || slot3.m_6657_() && slot3.m_8010_(player))) {
                    int k1 = dragType == 0 ? 0 : this.getInventorySlotsSize() - 1;
                    int j2 = dragType == 0 ? 1 : -1;
                    for (int k2 = 0; k2 < 2; ++k2) {
                        for (int k3 = k1; k3 >= 0 && k3 < this.getInventorySlotsSize() && carriedStack.m_41613_() < carriedStack.m_41741_(); k3 += j2) {
                            Slot slot8 = this.m_38853_(k3);
                            if (!slot8.m_6657_() || !BackpackContainer.canItemQuickReplace(slot8, carriedStack) || !slot8.m_8010_(player) || !this.m_5882_(carriedStack, slot8)) continue;
                            ItemStack itemstack12 = slot8.m_7993_();
                            if (k2 == 0 && itemstack12.m_41613_() == itemstack12.m_41741_()) continue;
                            ItemStack itemstack13 = slot8.m_150647_(itemstack12.m_41613_(), carriedStack.m_41741_() - carriedStack.m_41613_(), player);
                            carriedStack.m_41769_(itemstack13.m_41613_());
                        }
                    }
                    k1 = dragType == 0 ? 0 : this.upgradeSlots.size() - 1;
                    for (int j = 0; j < 2; ++j) {
                        for (int upgradeSlotId = k1; upgradeSlotId >= 0 && upgradeSlotId < this.upgradeSlots.size() && carriedStack.m_41613_() < carriedStack.m_41741_(); upgradeSlotId += j2) {
                            Slot upgradeSlot = this.upgradeSlots.get(upgradeSlotId);
                            if (!upgradeSlot.m_6657_() || !BackpackContainer.canItemQuickReplace(upgradeSlot, carriedStack) || !upgradeSlot.m_8010_(this.player) || !this.m_5882_(carriedStack, upgradeSlot)) continue;
                            ItemStack itemstack3 = upgradeSlot.m_7993_();
                            if (j == 0 && itemstack3.m_41613_() == itemstack3.m_41741_()) continue;
                            int l = Math.min(carriedStack.m_41741_() - carriedStack.m_41613_(), itemstack3.m_41613_());
                            ItemStack itemstack4 = upgradeSlot.m_6201_(l);
                            carriedStack.m_41769_(l);
                            if (itemstack4.m_41619_()) {
                                upgradeSlot.m_5852_(ItemStack.f_41583_);
                            }
                            upgradeSlot.m_142406_(this.player, itemstack4);
                        }
                    }
                }
            }
        }
        this.sendSlotUpdates();
    }

    public void sendSlotUpdates() {
        if (!this.player.f_19853_.f_46443_) {
            ServerPlayer serverPlayer = (ServerPlayer)this.player;
            this.slotStacksToUpdate.forEach((slot, stack) -> serverPlayer.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(serverPlayer.f_36096_.f_38840_, this.m_182425_(), slot.intValue(), stack)));
            this.slotStacksToUpdate.clear();
        }
    }

    public static boolean canItemQuickReplace(@Nullable Slot slot, ItemStack stack) {
        boolean flag;
        boolean bl = flag = slot == null || !slot.m_6657_();
        if (!flag && stack.m_41656_(slot.m_7993_()) && ItemStack.m_41658_((ItemStack)slot.m_7993_(), (ItemStack)stack)) {
            return slot.m_7993_().m_41613_() <= BackpackContainer.calculateMaxCountForStack(slot.m_6641_(), stack);
        }
        return flag;
    }

    private static int calculateMaxCountForStack(int slotLimit, ItemStack stack) {
        return slotLimit / 64 * stack.m_41741_();
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.mergeItemStack(stack, startIndex, endIndex, reverseDirection, false);
    }

    protected boolean mergeItemStack(ItemStack sourceStack, int startIndex, int endIndex, boolean reverseDirection, boolean transferMaxStackSizeFromSource) {
        int toTransfer;
        boolean mergedSomething = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        int n = toTransfer = transferMaxStackSizeFromSource ? Math.min(sourceStack.m_41741_(), sourceStack.m_41613_()) : sourceStack.m_41613_();
        if (sourceStack.m_41753_() || this.m_38853_(startIndex).m_6641_() > 64) {
            while (toTransfer > 0 && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                ItemStack destStack;
                Slot slot = this.m_38853_(i);
                if (slot.m_5857_(sourceStack) && !(destStack = slot.m_7993_()).m_41619_() && ItemStack.m_150942_((ItemStack)sourceStack, (ItemStack)destStack)) {
                    int maxSize;
                    int j = destStack.m_41613_() + toTransfer;
                    if (j <= (maxSize = BackpackContainer.calculateMaxCountForStack(slot.m_6641_(), sourceStack))) {
                        sourceStack.m_41774_(toTransfer);
                        destStack.m_41764_(j);
                        toTransfer = 0;
                        slot.m_6654_();
                        mergedSomething = true;
                    } else if (destStack.m_41613_() < maxSize) {
                        sourceStack.m_41774_(maxSize - destStack.m_41613_());
                        toTransfer -= maxSize - destStack.m_41613_();
                        destStack.m_41764_(maxSize);
                        slot.m_6654_();
                        mergedSomething = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (toTransfer > 0) {
            int firstIndex = reverseDirection ? endIndex - 1 : startIndex;
            int increment = reverseDirection ? -1 : 1;
            MemorySettingsCategory memory = this.backpackWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
            int slotIndex = firstIndex;
            while ((reverseDirection ? slotIndex >= startIndex : slotIndex < endIndex) && toTransfer > 0) {
                Slot slot;
                ItemStack destStack;
                if (memory.getSlotIndexes().contains(slotIndex) && memory.matchesFilter(slotIndex, sourceStack) && (destStack = (slot = this.m_38853_(slotIndex)).m_7993_()).m_41619_()) {
                    slot.m_5852_(sourceStack.m_41620_(slot.m_6641_()));
                    slot.m_6654_();
                    toTransfer = sourceStack.m_41613_();
                    mergedSomething = true;
                }
                slotIndex += increment;
            }
        }
        if (toTransfer > 0) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot destSlot = this.m_38853_(i);
                ItemStack itemstack1 = destSlot.m_7993_();
                if (itemstack1.m_41619_() && destSlot.m_5857_(sourceStack) && !(destSlot instanceof IFilterSlot)) {
                    boolean errorMerging = false;
                    if (toTransfer > destSlot.m_6641_()) {
                        destSlot.m_5852_(sourceStack.m_41620_(destSlot.m_6641_()));
                    } else if (this.isUpgradeSlot(i)) {
                        IBackpackUpgradeItem backpackUpgradeItem;
                        int newColumnsTaken;
                        BackpackUpgradeSlot upgradeSlot = (BackpackUpgradeSlot)this.m_38853_(i);
                        if (!this.needsSlotsThatAreOccupied(sourceStack, 0, upgradeSlot, newColumnsTaken = (backpackUpgradeItem = (IBackpackUpgradeItem)sourceStack.m_41720_()).getInventoryColumnsTaken())) {
                            destSlot.m_5852_(sourceStack.m_41620_(toTransfer));
                            this.updateColumnsTaken(newColumnsTaken);
                        } else {
                            errorMerging = true;
                        }
                    } else {
                        destSlot.m_5852_(sourceStack.m_41620_(toTransfer));
                    }
                    if (!errorMerging) {
                        destSlot.m_6654_();
                        mergedSomething = true;
                        break;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return mergedSomething;
    }

    public void m_150416_(ContainerSynchronizer synchronizer) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.backpackWrapper.getInventoryHandler().getStackSizeMultiplier() > 1) {
                super.m_150416_((ContainerSynchronizer)new HighStackCountSynchronizer(serverPlayer));
                return;
            }
        }
        super.m_150416_(synchronizer);
    }

    public void m_6877_(Player player) {
        for (Slot slot : this.upgradeSlots) {
            if (slot instanceof BackpackUpgradeSlot || !this.isInventorySlotInUpgradeTab(player, slot) || !(slot.m_7993_().m_41720_() instanceof BackpackItem) || this.backpackWrapper.getInventoryHandler().isItemValid(0, slot.m_7993_())) continue;
            ItemStack slotStack = slot.m_7993_();
            slot.m_5852_(ItemStack.f_41583_);
            if (player.m_36356_(slotStack)) continue;
            player.m_36176_(slotStack, false);
        }
        super.m_6877_(player);
        if (!player.f_19853_.f_46443_) {
            this.removeOpenTabIfKeepOff();
        }
    }

    private void removeOpenTabIfKeepOff() {
        if (Boolean.FALSE.equals(BackpackSettingsManager.getBackpackSettingValue(this.player, this.backpackWrapper.getSettingsHandler().getTypeCategory(BackpackSettingsCategory.class), BackpackSettingsManager.KEEP_TAB_OPEN))) {
            this.backpackWrapper.removeOpenTabId();
        }
    }

    private boolean isInventorySlotInUpgradeTab(Player player, Slot slot) {
        return slot.m_8010_(player) && !(slot instanceof ResultSlot);
    }

    public void setSlotStackToUpdate(int slot, ItemStack stack) {
        this.slotStacksToUpdate.put(slot, stack);
    }

    public void m_150404_(int slotIndex, ItemStack stack) {
        if (slotIndex < this.getInventorySlotsSize()) {
            this.remoteRealSlots.set(slotIndex, (Object)stack.m_41777_());
        } else {
            this.remoteUpgradeSlots.set(slotIndex, (Object)stack.m_41777_());
        }
    }

    public void m_182414_(int slotIndex, ItemStack stack) {
        if (slotIndex < this.getInventorySlotsSize()) {
            this.remoteRealSlots.set(slotIndex, (Object)stack);
        } else {
            this.remoteUpgradeSlots.set(slotIndex - this.getInventorySlotsSize(), (Object)stack);
        }
    }

    public OptionalInt m_182417_(Container container, int slotIdx) {
        for (int i = 0; i < this.getTotalSlotsNumber(); ++i) {
            Slot slot = this.m_38853_(i);
            if (slot.f_40218_ != container || slotIdx != slot.m_150661_()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public void m_150429_() {
        int i;
        for (i = 0; i < this.getInventorySlotsSize(); ++i) {
            this.remoteRealSlots.set(i, (Object)this.realInventorySlots.get(i).m_7993_().m_41777_());
        }
        for (i = 0; i < this.upgradeSlots.size(); ++i) {
            this.remoteUpgradeSlots.set(i, (Object)this.upgradeSlots.get(i).m_7993_().m_41777_());
        }
        NonNullList allRemoteSlots = NonNullList.m_122779_();
        allRemoteSlots.addAll(this.remoteRealSlots);
        allRemoteSlots.addAll(this.remoteUpgradeSlots);
        this.f_150396_ = this.m_142621_().m_41777_();
        if (this.f_150397_ != null) {
            this.f_150397_.m_142589_((AbstractContainerMenu)this, allRemoteSlots, this.f_150396_, new int[0]);
        }
    }

    public class BackpackUpgradeSlot
    extends SlotItemHandler {
        private boolean wasEmpty;

        public BackpackUpgradeSlot(BackpackUpgradeHandler upgradeHandler, int slotIndex, int yPosition) {
            super((IItemHandler)upgradeHandler, slotIndex, -15, yPosition);
            this.wasEmpty = false;
        }

        public void m_6654_() {
            super.m_6654_();
            if (!BackpackContainer.this.isUpdatingFromPacket && this.wasEmpty != this.m_7993_().m_41619_() || this.updateWrappersAndCheckForReloadNeeded()) {
                this.reloadUpgradeControl();
                if (!BackpackContainer.this.isFirstLevelBackpack()) {
                    BackpackContainer.this.parentBackpackWrapper.getUpgradeHandler().refreshUpgradeWrappers();
                }
                BackpackContainer.this.backpackContext.onUpgradeChanged(BackpackContainer.this.player);
            }
            this.wasEmpty = this.m_7993_().m_41619_();
        }

        public boolean m_5857_(ItemStack stack) {
            if (stack.m_41619_() || !(stack.m_41720_() instanceof IBackpackUpgradeItem)) {
                return false;
            }
            UpgradeSlotChangeResult result = ((IBackpackUpgradeItem)stack.m_41720_()).canAddUpgradeTo(BackpackContainer.this.backpackWrapper, stack, BackpackContainer.this.isFirstLevelBackpack());
            this.updateSlotChangeError(result);
            return result.isSuccessful();
        }

        private void updateSlotChangeError(UpgradeSlotChangeResult result) {
            if (BackpackContainer.this.player.f_19853_.f_46443_ && !result.isSuccessful()) {
                BackpackContainer.this.errorUpgradeSlotChangeResult = result;
                BackpackContainer.this.errorResultExpirationTime = BackpackContainer.this.player.f_19853_.m_46467_() + 60L;
            }
        }

        public boolean m_8010_(Player player) {
            boolean ret = super.m_8010_(player);
            if (!ret) {
                return false;
            }
            UpgradeSlotChangeResult result = ((IBackpackUpgradeItem)this.m_7993_().m_41720_()).canRemoveUpgradeFrom(BackpackContainer.this.backpackWrapper);
            this.updateSlotChangeError(result);
            return result.isSuccessful();
        }

        public boolean canSwapStack(Player player, ItemStack stackToPut) {
            boolean ret = super.m_8010_(player);
            if (!ret) {
                return false;
            }
            UpgradeSlotChangeResult result = ((IBackpackUpgradeItem)this.m_7993_().m_41720_()).canSwapUpgradeFor(stackToPut, BackpackContainer.this.backpackWrapper);
            this.updateSlotChangeError(result);
            return result.isSuccessful();
        }

        private boolean updateWrappersAndCheckForReloadNeeded() {
            int checkedContainersCount = 0;
            for (Map.Entry<Integer, IUpgradeWrapper> slotWrapper : BackpackContainer.this.backpackWrapper.getUpgradeHandler().getSlotWrappers().entrySet()) {
                UpgradeContainerBase<?, ?> container = BackpackContainer.this.upgradeContainers.get(slotWrapper.getKey());
                if (slotWrapper.getValue().hideSettingsTab()) {
                    if (container == null) continue;
                    return true;
                }
                if (container == null || container.getUpgradeWrapper().isEnabled() != slotWrapper.getValue().isEnabled()) {
                    return true;
                }
                if (container.getUpgradeWrapper() == slotWrapper.getValue()) continue;
                if (container.getUpgradeWrapper().getUpgradeStack().m_41720_() != slotWrapper.getValue().getUpgradeStack().m_41720_()) {
                    return true;
                }
                container.setUpgradeWrapper(slotWrapper.getValue());
                ++checkedContainersCount;
            }
            return checkedContainersCount != BackpackContainer.this.upgradeContainers.size();
        }

        private void reloadUpgradeControl() {
            BackpackContainer.this.backpackWrapper.removeOpenTabId();
            this.removeUpgradeSettingsSlots();
            BackpackContainer.this.upgradeContainers.clear();
            BackpackContainer.this.addUpgradeSettingsContainers(BackpackContainer.this.player);
            this.onUpgradesChanged();
        }

        private void removeUpgradeSettingsSlots() {
            ArrayList slotNumbersToRemove = new ArrayList();
            for (UpgradeContainerBase<?, ?> container : BackpackContainer.this.upgradeContainers.values()) {
                container.getSlots().forEach(slot -> {
                    int upgradeSlotIndex = slot.f_40219_ - BackpackContainer.this.getInventorySlotsSize();
                    slotNumbersToRemove.add(upgradeSlotIndex);
                    BackpackContainer.this.upgradeSlots.remove(slot);
                });
            }
            slotNumbersToRemove.sort(IntComparators.OPPOSITE_COMPARATOR);
            Iterator<UpgradeContainerBase<Object, Object>> iterator = slotNumbersToRemove.iterator();
            while (iterator.hasNext()) {
                int slotNumber = (Integer)((Object)iterator.next());
                BackpackContainer.this.lastUpgradeSlots.remove(slotNumber);
                BackpackContainer.this.remoteUpgradeSlots.remove(slotNumber);
            }
        }

        private void onUpgradesChanged() {
            if (BackpackContainer.this.upgradeChangeListener != null) {
                BackpackContainer.this.upgradeChangeListener.accept(BackpackContainer.this);
            }
        }

        @Nullable
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return new Pair((Object)InventoryMenu.f_39692_, (Object)EMPTY_UPGRADE_SLOT_BACKGROUND);
        }
    }
}

