/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.craftingtweaks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingGridBuilder;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.GridBalanceHandler;
import net.blay09.mods.craftingtweaks.api.GridTransferHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.ICraftingContainer;

public class CraftingUpgradeTweakProvider
implements CraftingGridProvider {
    public String getModId() {
        return "sophisticatedbackpacks";
    }

    public boolean handles(AbstractContainerMenu abstractContainerMenu) {
        return abstractContainerMenu instanceof BackpackContainer;
    }

    public void buildCraftingGrids(CraftingGridBuilder builder, AbstractContainerMenu containerMenu) {
        if (!(containerMenu instanceof BackpackContainer)) {
            return;
        }
        BackpackContainer backpackContainer = (BackpackContainer)containerMenu;
        builder.addGrid(CraftingUpgradeTweakProvider.getCraftingGridStart(backpackContainer), CraftingUpgradeTweakProvider.getCraftingGridSize(backpackContainer)).clearHandler((craftingGrid, player, menu, forced) -> this.clearGrid(player, menu, forced)).rotateHandler((craftingGrid, player, menu, reverse) -> this.rotateGrid(menu, reverse)).balanceHandler((GridBalanceHandler)new BackpackCraftingGridBalanceHandler()).transferHandler((GridTransferHandler)new BackpackCraftingGridTransferHandler()).hideAllTweakButtons();
    }

    public void clearGrid(Player player, AbstractContainerMenu menu, boolean forced) {
        if (!(menu instanceof BackpackContainer)) {
            return;
        }
        BackpackContainer backpackContainer = (BackpackContainer)menu;
        CraftingUpgradeTweakProvider.getCraftMatrix(backpackContainer).ifPresent(craftMatrix -> {
            int start = CraftingUpgradeTweakProvider.getCraftingGridStart(backpackContainer);
            int size = CraftingUpgradeTweakProvider.getCraftingGridSize(backpackContainer);
            for (int i = start; i < start + size; ++i) {
                int slotIndex = backpackContainer.m_38853_(i).m_150661_();
                ItemStack itemStack = craftMatrix.m_8020_(slotIndex);
                if (itemStack.m_41619_()) continue;
                ItemStack returnStack = itemStack.m_41777_();
                player.m_150109_().m_36054_(returnStack);
                craftMatrix.m_6836_(slotIndex, returnStack.m_41613_() == 0 ? ItemStack.f_41583_ : returnStack);
                if (returnStack.m_41613_() <= 0 || !forced) continue;
                player.m_36176_(returnStack, false);
                craftMatrix.m_6836_(slotIndex, ItemStack.f_41583_);
            }
            backpackContainer.m_38946_();
        });
    }

    private int rotateSlotId(int slotId, boolean counterClockwise) {
        if (!counterClockwise) {
            switch (slotId) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 5;
                }
                case 3: {
                    return 0;
                }
                case 5: {
                    return 8;
                }
                case 6: {
                    return 3;
                }
                case 7: {
                    return 6;
                }
                case 8: {
                    return 7;
                }
            }
        } else {
            switch (slotId) {
                case 0: {
                    return 3;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 6;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 5;
                }
            }
        }
        return 0;
    }

    private boolean ignoresSlotId(int slotId) {
        return slotId == 4;
    }

    private void rotateGrid(AbstractContainerMenu containerMenu, boolean counterClockwise) {
        if (!(containerMenu instanceof BackpackContainer)) {
            return;
        }
        BackpackContainer backpackContainer = (BackpackContainer)containerMenu;
        CraftingUpgradeTweakProvider.getCraftMatrix(backpackContainer).ifPresent(craftMatrix -> {
            int slotIndex;
            int i;
            int start = CraftingUpgradeTweakProvider.getCraftingGridStart(backpackContainer);
            int size = CraftingUpgradeTweakProvider.getCraftingGridSize(backpackContainer);
            SimpleContainer matrixClone = new SimpleContainer(size);
            for (i = 0; i < size; ++i) {
                slotIndex = backpackContainer.m_38853_(start + i).m_150661_();
                matrixClone.m_6836_(i, craftMatrix.m_8020_(slotIndex));
            }
            for (i = 0; i < size; ++i) {
                if (this.ignoresSlotId(i)) continue;
                slotIndex = containerMenu.m_38853_(start + this.rotateSlotId(i, counterClockwise)).m_150661_();
                craftMatrix.m_6836_(slotIndex, matrixClone.m_8020_(i));
            }
            backpackContainer.m_38946_();
        });
    }

    private static Optional<Container> getCraftMatrix(BackpackContainer container) {
        return CraftingUpgradeTweakProvider.getOpenCraftingContainer(container).map(ICraftingContainer::getCraftMatrix);
    }

    public boolean requiresServerSide() {
        return true;
    }

    private static Optional<ICraftingContainer> getOpenCraftingContainer(BackpackContainer container) {
        return container.getOpenContainer().flatMap(c -> {
            Optional<Object> optional;
            if (c instanceof ICraftingContainer) {
                ICraftingContainer craftingContainer = (ICraftingContainer)((Object)c);
                optional = Optional.of(craftingContainer);
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
    }

    private static int getCraftingGridStart(BackpackContainer container) {
        return CraftingUpgradeTweakProvider.getOpenCraftingContainer(container).map(cc -> {
            List<Slot> recipeSlots = cc.getRecipeSlots();
            if (!recipeSlots.isEmpty()) {
                return recipeSlots.get((int)0).f_40219_;
            }
            return 0;
        }).orElse(0);
    }

    private static int getCraftingGridSize(BackpackContainer container) {
        return CraftingUpgradeTweakProvider.getOpenCraftingContainer(container).isPresent() ? 9 : 0;
    }

    private static class BackpackCraftingGridBalanceHandler
    implements GridBalanceHandler<AbstractContainerMenu> {
        private BackpackCraftingGridBalanceHandler() {
        }

        public void balanceGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu) {
            if (!(menu instanceof BackpackContainer)) {
                return;
            }
            BackpackContainer backpackContainer = (BackpackContainer)menu;
            CraftingUpgradeTweakProvider.getCraftMatrix(backpackContainer).ifPresent(craftMatrix -> {
                ArrayListMultimap itemMap = ArrayListMultimap.create();
                HashMultiset itemCount = HashMultiset.create();
                int start = CraftingUpgradeTweakProvider.getCraftingGridStart(backpackContainer);
                int size = CraftingUpgradeTweakProvider.getCraftingGridSize(backpackContainer);
                for (int i = start; i < start + size; ++i) {
                    int slotIndex = menu.m_38853_(i).m_150661_();
                    ItemStack itemStack = craftMatrix.m_8020_(slotIndex);
                    if (itemStack.m_41619_() || itemStack.m_41741_() <= 1) continue;
                    ResourceLocation registryName = itemStack.m_41720_().getRegistryName();
                    String key = Objects.toString(registryName);
                    itemMap.put((Object)key, (Object)itemStack);
                    itemCount.add((Object)key, itemStack.m_41613_());
                }
                for (String key : itemMap.keySet()) {
                    List balanceList = itemMap.get((Object)key);
                    int totalCount = itemCount.count((Object)key);
                    int countPerStack = totalCount / balanceList.size();
                    int restCount = totalCount % balanceList.size();
                    for (ItemStack itemStack : balanceList) {
                        itemStack.m_41764_(countPerStack);
                    }
                    int idx = 0;
                    while (restCount > 0) {
                        ItemStack itemStack;
                        itemStack = (ItemStack)balanceList.get(idx);
                        if (itemStack.m_41613_() < itemStack.m_41741_()) {
                            itemStack.m_41769_(1);
                            --restCount;
                        }
                        if (++idx < balanceList.size()) continue;
                        idx = 0;
                    }
                }
                menu.m_38946_();
            });
        }

        public void spreadGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu) {
            if (!(menu instanceof BackpackContainer)) {
                return;
            }
            BackpackContainer backpackContainer = (BackpackContainer)menu;
            CraftingUpgradeTweakProvider.getCraftMatrix(backpackContainer).ifPresent(craftMatrix -> {
                boolean emptyBiggestSlot;
                do {
                    ItemStack biggestSlotStack = null;
                    int biggestSlotSize = 1;
                    int start = CraftingUpgradeTweakProvider.getCraftingGridStart(backpackContainer);
                    int size = CraftingUpgradeTweakProvider.getCraftingGridSize(backpackContainer);
                    for (int i = start; i < start + size; ++i) {
                        int slotIndex = menu.m_38853_(i).m_150661_();
                        ItemStack itemStack = craftMatrix.m_8020_(slotIndex);
                        if (itemStack.m_41619_() || itemStack.m_41613_() <= biggestSlotSize) continue;
                        biggestSlotStack = itemStack;
                        biggestSlotSize = itemStack.m_41613_();
                    }
                    if (biggestSlotStack == null) {
                        return;
                    }
                    emptyBiggestSlot = false;
                    for (int i = start; i < start + size; ++i) {
                        int slotIndex = menu.m_38853_(i).m_150661_();
                        ItemStack itemStack = craftMatrix.m_8020_(slotIndex);
                        if (!itemStack.m_41619_()) continue;
                        if (biggestSlotStack.m_41613_() > 1) {
                            craftMatrix.m_6836_(slotIndex, biggestSlotStack.m_41620_(1));
                            continue;
                        }
                        emptyBiggestSlot = true;
                    }
                } while (emptyBiggestSlot);
                this.balanceGrid(grid, player, menu);
            });
        }
    }

    private static class BackpackCraftingGridTransferHandler
    implements GridTransferHandler<AbstractContainerMenu> {
        private BackpackCraftingGridTransferHandler() {
        }

        public ItemStack putIntoGrid(CraftingGrid craftingGrid, Player player, AbstractContainerMenu menu, int slotId, ItemStack itemStack) {
            if (!(menu instanceof BackpackContainer)) {
                return itemStack;
            }
            BackpackContainer backpackContainer = (BackpackContainer)menu;
            return CraftingUpgradeTweakProvider.getCraftMatrix(backpackContainer).map(craftMatrix -> {
                ItemStack craftStack = craftMatrix.m_8020_(slotId);
                if (!craftStack.m_41619_()) {
                    int spaceLeft;
                    if (craftStack.m_41656_(itemStack) && ItemStack.m_41658_((ItemStack)craftStack, (ItemStack)itemStack) && (spaceLeft = Math.min(craftMatrix.m_6893_(), craftStack.m_41741_()) - craftStack.m_41613_()) > 0) {
                        ItemStack splitStack = itemStack.m_41620_(Math.min(spaceLeft, itemStack.m_41613_()));
                        craftStack.m_41769_(splitStack.m_41613_());
                        if (itemStack.m_41613_() <= 0) {
                            return ItemStack.f_41583_;
                        }
                    }
                } else {
                    ItemStack transferStack = itemStack.m_41620_(Math.min(itemStack.m_41613_(), craftMatrix.m_6893_()));
                    craftMatrix.m_6836_(slotId, transferStack);
                }
                return itemStack.m_41613_() <= 0 ? ItemStack.f_41583_ : itemStack;
            }).orElse(itemStack);
        }

        public boolean transferIntoGrid(CraftingGrid craftingGrid, Player player, AbstractContainerMenu menu, Slot fromSlot) {
            if (!(menu instanceof BackpackContainer)) {
                return false;
            }
            BackpackContainer backpackContainer = (BackpackContainer)menu;
            return CraftingUpgradeTweakProvider.getCraftMatrix(backpackContainer).map(craftMatrix -> {
                int start = CraftingUpgradeTweakProvider.getCraftingGridStart(backpackContainer);
                int size = CraftingUpgradeTweakProvider.getCraftingGridSize(backpackContainer);
                ItemStack itemStack = fromSlot.m_7993_();
                if (itemStack.m_41619_()) {
                    return false;
                }
                int firstEmptySlot = -1;
                for (int i = start; i < start + size; ++i) {
                    int slotIndex = menu.m_38853_(i).m_150661_();
                    ItemStack craftStack = craftMatrix.m_8020_(slotIndex);
                    if (!craftStack.m_41619_()) {
                        int spaceLeft;
                        if (!craftStack.m_41656_(itemStack) || !ItemStack.m_41658_((ItemStack)craftStack, (ItemStack)itemStack) || (spaceLeft = Math.min(craftMatrix.m_6893_(), craftStack.m_41741_()) - craftStack.m_41613_()) <= 0) continue;
                        ItemStack splitStack = itemStack.m_41620_(Math.min(spaceLeft, itemStack.m_41613_()));
                        craftStack.m_41769_(splitStack.m_41613_());
                        if (itemStack.m_41613_() > 0) continue;
                        return true;
                    }
                    if (firstEmptySlot != -1) continue;
                    firstEmptySlot = slotIndex;
                }
                if (itemStack.m_41613_() > 0 && firstEmptySlot != -1) {
                    ItemStack transferStack = itemStack.m_41620_(Math.min(itemStack.m_41613_(), craftMatrix.m_6893_()));
                    craftMatrix.m_6836_(firstEmptySlot, transferStack);
                    return true;
                }
                return false;
            }).orElse(false);
        }

        public boolean canTransferFrom(Player player, AbstractContainerMenu menu, Slot sourceSlot, CraftingGrid craftingGrid) {
            if (!(menu instanceof BackpackContainer)) {
                return false;
            }
            BackpackContainer backpackContainer = (BackpackContainer)menu;
            return sourceSlot.m_8010_(player) && sourceSlot.f_40219_ < backpackContainer.realInventorySlots.size();
        }
    }
}

