/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.crafting;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RegistryHelper;

public class ItemEnabledCondition
implements ICondition {
    private static final ResourceLocation NAME = RegistryHelper.getRL("item_enabled");
    private final String itemRegistryName;

    public ItemEnabledCondition(Item item) {
        this(item.getRegistryName().m_135815_());
    }

    public ItemEnabledCondition(String itemRegistryName) {
        this.itemRegistryName = itemRegistryName;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        return Config.COMMON.enabledItems.isItemEnabled(this.itemRegistryName);
    }

    public static class Serializer
    implements IConditionSerializer<ItemEnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ItemEnabledCondition value) {
            json.addProperty("itemRegistryName", value.itemRegistryName);
        }

        public ItemEnabledCondition read(JsonObject json) {
            return new ItemEnabledCondition(GsonHelper.m_13906_((JsonObject)json, (String)"itemRegistryName"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

