/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.crafting;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedbackpacks.crafting.RecipeWrapperSerializer;

public class SmithingBackpackUpgradeRecipe
extends UpgradeRecipe
implements IWrapperRecipe<UpgradeRecipe> {
    public static final Serializer SERIALIZER = new Serializer();
    private final UpgradeRecipe compose;

    public SmithingBackpackUpgradeRecipe(UpgradeRecipe compose) {
        super(compose.m_6423_(), Objects.requireNonNull((Ingredient)ObfuscationReflectionHelper.getPrivateValue(UpgradeRecipe.class, (Object)compose, (String)"f_44518_")), Objects.requireNonNull((Ingredient)ObfuscationReflectionHelper.getPrivateValue(UpgradeRecipe.class, (Object)compose, (String)"f_44519_")), compose.m_8043_());
        this.compose = compose;
    }

    public ItemStack m_5874_(Container inv) {
        ItemStack upgradedBackpack = this.getCraftingResult().m_41777_();
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            this.getBackpack(inv).flatMap(backpack -> Optional.ofNullable(backpack.m_41783_())).ifPresent(tag -> upgradedBackpack.m_41751_(tag.m_6426_()));
            upgradedBackpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
                BackpackItem backpackItem = (BackpackItem)upgradedBackpack.m_41720_();
                wrapper.setSlotNumbers(backpackItem.getNumberOfSlots(), backpackItem.getNumberOfUpgradeSlots());
            });
        }
        return upgradedBackpack;
    }

    private ItemStack getCraftingResult() {
        return Objects.requireNonNull((ItemStack)ObfuscationReflectionHelper.getPrivateValue(UpgradeRecipe.class, (Object)this, (String)"f_44520_"));
    }

    private Optional<ItemStack> getBackpack(Container inv) {
        ItemStack slotStack = inv.m_8020_(0);
        if (slotStack.m_41720_() instanceof BackpackItem) {
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public Serializer getSerializer() {
        return SERIALIZER;
    }

    @Override
    public UpgradeRecipe getCompose() {
        return this.compose;
    }

    public static class Serializer
    extends RecipeWrapperSerializer<UpgradeRecipe, SmithingBackpackUpgradeRecipe> {
        public Serializer() {
            super(SmithingBackpackUpgradeRecipe::new, RecipeSerializer.f_44096_);
        }
    }
}

