/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;

public class RequestBackpackInventoryContentsMessage {
    private final UUID backpackUuid;

    public RequestBackpackInventoryContentsMessage(UUID backpackUuid) {
        this.backpackUuid = backpackUuid;
    }

    public static void encode(RequestBackpackInventoryContentsMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130077_(msg.backpackUuid);
    }

    public static RequestBackpackInventoryContentsMessage decode(FriendlyByteBuf packetBuffer) {
        return new RequestBackpackInventoryContentsMessage(packetBuffer.m_130259_());
    }

    static void onMessage(RequestBackpackInventoryContentsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> RequestBackpackInventoryContentsMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer player, RequestBackpackInventoryContentsMessage msg) {
        Tag upgradeNbt;
        if (player == null) {
            return;
        }
        CompoundTag backpackContents = BackpackStorage.get().getOrCreateBackpackContents(msg.backpackUuid);
        CompoundTag inventoryContents = new CompoundTag();
        Tag inventoryNbt = backpackContents.m_128423_("inventory");
        if (inventoryNbt != null) {
            inventoryContents.m_128365_("inventory", inventoryNbt);
        }
        if ((upgradeNbt = backpackContents.m_128423_("upgradeInventory")) != null) {
            inventoryContents.m_128365_("upgradeInventory", upgradeNbt);
        }
        PacketHandler.sendToClient(player, new BackpackContentsMessage(msg.backpackUuid, inventoryContents));
    }
}

