/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackSettingsManager;

public class SyncPlayerSettingsMessage {
    @Nullable
    private final CompoundTag settingsNbt;

    public SyncPlayerSettingsMessage(@Nullable CompoundTag settingsNbt) {
        this.settingsNbt = settingsNbt;
    }

    public static void encode(SyncPlayerSettingsMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130079_(msg.settingsNbt);
    }

    public static SyncPlayerSettingsMessage decode(FriendlyByteBuf packetBuffer) {
        return new SyncPlayerSettingsMessage(packetBuffer.m_130260_());
    }

    static void onMessage(SyncPlayerSettingsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncPlayerSettingsMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(SyncPlayerSettingsMessage msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || msg.settingsNbt == null) {
            return;
        }
        BiConsumer<Player, CompoundTag> setSettings = BackpackSettingsManager::setPlayerBackpackSettingsTag;
        setSettings.accept((Player)player, msg.settingsNbt);
    }
}

