/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHelper;

public class SyncSlotStackMessage {
    private final int windowId;
    private final int stateId;
    private final int slotNumber;
    private final ItemStack stack;

    public SyncSlotStackMessage(int windowId, int stateId, int slotNumber, ItemStack stack) {
        this.windowId = windowId;
        this.stateId = stateId;
        this.slotNumber = slotNumber;
        this.stack = stack;
    }

    public static void encode(SyncSlotStackMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeByte(msg.windowId);
        packetBuffer.m_130130_(msg.stateId);
        packetBuffer.writeShort(msg.slotNumber);
        PacketHelper.writeItemStack(msg.stack, packetBuffer);
    }

    public static SyncSlotStackMessage decode(FriendlyByteBuf packetBuffer) {
        return new SyncSlotStackMessage(packetBuffer.readUnsignedByte(), packetBuffer.m_130242_(), packetBuffer.readShort(), PacketHelper.readItemStack(packetBuffer));
    }

    static void onMessage(SyncSlotStackMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncSlotStackMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(SyncSlotStackMessage msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !(player.f_36096_ instanceof BackpackContainer) && !(player.f_36096_ instanceof SettingsContainer) || player.f_36096_.f_38840_ != msg.windowId) {
            return;
        }
        player.f_36096_.m_182406_(msg.slotNumber, msg.stateId, msg.stack);
    }
}

