/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.settings.itemdisplay;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ISlotColorCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class ItemDisplaySettingsCategory
implements ISettingsCategory,
ISlotColorCategory {
    public static final String NAME = "item_display";
    private static final String SLOT_TAG = "slot";
    private static final String ROTATION_TAG = "rotation";
    private static final String COLOR_TAG = "color";
    private CompoundTag categoryNbt;
    private final Consumer<CompoundTag> saveNbt;
    private DyeColor color = DyeColor.RED;
    private final IBackpackWrapper backpackWrapper;
    private int slotIndex = -1;
    private int rotation = 0;

    public ItemDisplaySettingsCategory(IBackpackWrapper backpackWrapper, CompoundTag categoryNbt, Consumer<CompoundTag> saveNbt) {
        this.backpackWrapper = backpackWrapper;
        this.categoryNbt = categoryNbt;
        this.saveNbt = saveNbt;
        this.deserialize();
    }

    public void unselectSlot() {
        this.slotIndex = -1;
        this.categoryNbt.m_128473_(SLOT_TAG);
        this.saveNbt.accept(this.categoryNbt);
        this.updateRenderInfo();
    }

    private void updateRenderInfo() {
        BackpackRenderInfo renderInfo = this.backpackWrapper.getRenderInfo();
        if (this.slotIndex >= 0) {
            ItemStack stackCopy = this.backpackWrapper.getInventoryHandler().getStackInSlot(this.slotIndex).m_41777_();
            stackCopy.m_41764_(1);
            renderInfo.setItemDisplayRenderInfo(stackCopy, this.rotation);
        } else {
            renderInfo.setItemDisplayRenderInfo(ItemStack.f_41583_, 0);
        }
    }

    public void selectSlot(int slot) {
        this.slotIndex = slot;
        this.categoryNbt.m_128405_(SLOT_TAG, slot);
        this.saveNbt.accept(this.categoryNbt);
        this.updateRenderInfo();
    }

    public Optional<Integer> getSlot() {
        return this.slotIndex >= 0 ? Optional.of(this.slotIndex) : Optional.empty();
    }

    public int getRotation() {
        return this.rotation;
    }

    public void rotate(boolean clockwise) {
        this.rotation = (this.rotation + (clockwise ? 1 : -1) * 45 + 360) % 360;
        this.categoryNbt.m_128405_(ROTATION_TAG, this.rotation);
        this.saveNbt.accept(this.categoryNbt);
        this.updateRenderInfo();
    }

    public void setColor(DyeColor color) {
        this.color = color;
        this.categoryNbt.m_128405_(COLOR_TAG, color.m_41060_());
        this.saveNbt.accept(this.categoryNbt);
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public void reloadFrom(CompoundTag categoryNbt) {
        this.categoryNbt = categoryNbt;
        this.deserialize();
    }

    private void deserialize() {
        this.slotIndex = NBTHelper.getInt(this.categoryNbt, SLOT_TAG).orElse(-1);
        this.rotation = NBTHelper.getInt(this.categoryNbt, ROTATION_TAG).orElse(0);
        this.color = NBTHelper.getInt(this.categoryNbt, COLOR_TAG).map(c -> {
            this.color = DyeColor.m_41053_((int)c);
            return this.color;
        }).orElse(DyeColor.RED);
    }

    public void itemChanged(int changedSlotIndex) {
        if (changedSlotIndex != this.slotIndex) {
            return;
        }
        this.updateRenderInfo();
    }

    @Override
    public Optional<Integer> getSlotColor(int slotNumber) {
        return this.slotIndex == slotNumber ? Optional.of(ColorHelper.getColor(this.color.m_41068_())) : Optional.empty();
    }
}

