/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.settings.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class MemorySettingsCategory
implements ISettingsCategory {
    public static final String NAME = "memory";
    private static final String SLOT_FILTER_ITEMS_TAG = "slotFilterItems";
    private final IBackpackWrapper backpackWrapper;
    private CompoundTag categoryNbt;
    private final Consumer<CompoundTag> saveNbt;
    private final Map<Integer, Item> slotFilterItems = new TreeMap<Integer, Item>();
    private final Map<Item, Set<Integer>> filterItemSlots = new HashMap<Item, Set<Integer>>();

    public MemorySettingsCategory(IBackpackWrapper backpackWrapper, CompoundTag categoryNbt, Consumer<CompoundTag> saveNbt) {
        this.backpackWrapper = backpackWrapper;
        this.categoryNbt = categoryNbt;
        this.saveNbt = saveNbt;
        this.deserialize();
    }

    private void deserialize() {
        if (this.categoryNbt.m_128441_("slotFilterStacks")) {
            this.categoryNbt.m_128473_("slotFilterStacks");
            this.saveNbt.accept(this.categoryNbt);
        }
        NBTHelper.getMap(this.categoryNbt.m_128469_(SLOT_FILTER_ITEMS_TAG), Integer::valueOf, (k, v) -> Optional.ofNullable((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(v.m_7916_())))).ifPresent(map -> map.forEach(this::addSlotItem));
    }

    public boolean matchesFilter(int slotNumber, ItemStack stack) {
        if (!this.slotFilterItems.containsKey(slotNumber)) {
            return true;
        }
        return !stack.m_41619_() && stack.m_41720_() == this.slotFilterItems.get(slotNumber);
    }

    public Optional<Item> getSlotFilterItem(int slotNumber) {
        return Optional.ofNullable(this.slotFilterItems.get(slotNumber));
    }

    public boolean isSlotSelected(int slotNumber) {
        return this.slotFilterItems.containsKey(slotNumber);
    }

    public void unselectAllSlots() {
        this.slotFilterItems.clear();
        this.filterItemSlots.clear();
        this.serializeFilterItems();
    }

    public void selectSlots(int minSlot, int maxSlot) {
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            ItemStack stackInSlot;
            BackpackInventoryHandler inventoryHandler = this.backpackWrapper.getInventoryHandler();
            if (slot >= inventoryHandler.getSlots() || (stackInSlot = inventoryHandler.getStackInSlot(slot)).m_41619_()) continue;
            Item item = stackInSlot.m_41720_();
            this.addSlotItem(slot, item);
        }
        this.serializeFilterItems();
    }

    private void addSlotItem(int slot, Item item) {
        this.slotFilterItems.put(slot, item);
        this.filterItemSlots.computeIfAbsent(item, k -> new TreeSet()).add(slot);
    }

    public void selectSlot(int slotNumber) {
        this.selectSlots(slotNumber, slotNumber + 1);
    }

    public void unselectSlot(int slotNumber) {
        Item item = this.slotFilterItems.remove(slotNumber);
        Set<Integer> itemSlots = this.filterItemSlots.get(item);
        itemSlots.remove(slotNumber);
        if (itemSlots.isEmpty()) {
            this.filterItemSlots.remove(item);
        }
        this.serializeFilterItems();
    }

    private void serializeFilterItems() {
        NBTHelper.putMap(this.categoryNbt, SLOT_FILTER_ITEMS_TAG, this.slotFilterItems, String::valueOf, i -> StringTag.m_129297_((String)i.getRegistryName().toString()));
        this.saveNbt.accept(this.categoryNbt);
    }

    @Override
    public void reloadFrom(CompoundTag categoryNbt) {
        this.categoryNbt = categoryNbt;
        this.slotFilterItems.clear();
        this.filterItemSlots.clear();
        this.deserialize();
    }

    public Set<Integer> getSlotIndexes() {
        return this.slotFilterItems.keySet();
    }

    public Map<Item, Set<Integer>> getFilterItemSlots() {
        return this.filterItemSlots;
    }
}

