/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.ContentsFilterType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.util.ItemStackKey;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class ContentsFilterLogic
extends FilterLogic {
    private final Supplier<BackpackInventoryHandler> getInventoryHandler;

    public ContentsFilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount, Supplier<BackpackInventoryHandler> getInventoryHandler) {
        super(upgrade, saveHandler, filterSlotCount);
        this.getInventoryHandler = getInventoryHandler;
    }

    public ContentsFilterType getFilterType() {
        if (this.shouldFilterByBackpack()) {
            return ContentsFilterType.BACKPACK;
        }
        return this.isAllowList() ? ContentsFilterType.ALLOW : ContentsFilterType.BLOCK;
    }

    public void setDepositFilterType(ContentsFilterType contentsFilterType) {
        switch (contentsFilterType) {
            case ALLOW: {
                this.setFilterByBackpack(false);
                this.setAllowList(true);
                break;
            }
            case BLOCK: {
                this.setFilterByBackpack(false);
                this.setAllowList(false);
                break;
            }
            case BACKPACK: {
                this.setFilterByBackpack(true);
                this.save();
            }
        }
    }

    @Override
    public boolean matchesFilter(ItemStack stack) {
        if (!this.shouldFilterByBackpack()) {
            return super.matchesFilter(stack);
        }
        for (ItemStackKey filterStack : this.getInventoryHandler.get().getSlotTracker().getFullStacks()) {
            if (!this.stackMatchesFilter(stack, filterStack.getStack())) continue;
            return true;
        }
        for (ItemStackKey filterStack : this.getInventoryHandler.get().getSlotTracker().getPartialStacks()) {
            if (!this.stackMatchesFilter(stack, filterStack.getStack())) continue;
            return true;
        }
        return false;
    }

    private void setFilterByBackpack(boolean filterByBackpack) {
        NBTHelper.setBoolean(this.upgrade, "filterByBackpack", filterByBackpack);
        this.save();
    }

    private boolean shouldFilterByBackpack() {
        return NBTHelper.getBoolean(this.upgrade, "filterByBackpack").orElse(false);
    }
}

