/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedbackpacks.util.ItemStackHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class FilterLogicBase {
    protected final ItemStack upgrade;
    protected final Consumer<ItemStack> saveHandler;
    protected final String parentTagKey;
    private boolean allowListDefault = false;
    @Nullable
    protected Set<ResourceLocation> tagNames = null;

    public FilterLogicBase(ItemStack upgrade, Consumer<ItemStack> saveHandler, String parentTagKey) {
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.parentTagKey = parentTagKey;
    }

    public void setAllowByDefault() {
        this.allowListDefault = true;
    }

    protected void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public boolean stackMatchesFilter(ItemStack stack, ItemStack filter) {
        if (filter.m_41619_()) {
            return false;
        }
        PrimaryMatch primaryMatch = this.getPrimaryMatch();
        if (primaryMatch == PrimaryMatch.MOD ? !stack.m_41720_().getRegistryName().m_135827_().equals(filter.m_41720_().getRegistryName().m_135827_()) : primaryMatch == PrimaryMatch.ITEM && !ItemStack.m_41746_((ItemStack)stack, (ItemStack)filter)) {
            return false;
        }
        if (this.shouldMatchDurability() && stack.m_41773_() != filter.m_41773_()) {
            return false;
        }
        return !this.shouldMatchNbt() || ItemStackHelper.areItemStackTagsEqualIgnoreDurability(stack, filter);
    }

    public Set<ResourceLocation> getTagNames() {
        if (this.tagNames == null) {
            this.initTags();
        }
        return Collections.unmodifiableSet(this.tagNames);
    }

    public void addTagName(ResourceLocation tagName) {
        if (this.tagNames == null) {
            this.initTags();
        }
        this.tagNames.add(tagName);
        this.serializeTags();
    }

    private void serializeTags() {
        if (this.tagNames == null) {
            return;
        }
        NBTHelper.setList(this.upgrade, this.parentTagKey, "tags", this.tagNames, t -> StringTag.m_129297_((String)t.toString()));
    }

    public void removeTagName(ResourceLocation tagName) {
        if (this.tagNames == null) {
            this.initTags();
        }
        this.tagNames.remove(tagName);
        this.serializeTags();
    }

    protected void initTags() {
        this.tagNames = NBTHelper.getCollection(this.upgrade, this.parentTagKey, "tags", 8, elementNbt -> Optional.of(new ResourceLocation(elementNbt.m_7916_())), TreeSet::new).orElse(new TreeSet());
    }

    public void setAllowList(boolean isAllowList) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "isAllowList", isAllowList);
        this.save();
    }

    public boolean isAllowList() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "isAllowList").orElse(this.allowListDefault);
    }

    public boolean shouldMatchDurability() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchDurability").orElse(false);
    }

    public void setMatchDurability(boolean matchDurability) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchDurability", matchDurability);
        this.save();
    }

    public void setMatchNbt(boolean matchNbt) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchNbt", matchNbt);
        this.save();
    }

    public boolean shouldMatchNbt() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchNbt").orElse(false);
    }

    public void setPrimaryMatch(PrimaryMatch primaryMatch) {
        NBTHelper.setEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", primaryMatch);
        this.save();
    }

    public PrimaryMatch getPrimaryMatch() {
        return NBTHelper.getEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", PrimaryMatch::fromName).orElse(PrimaryMatch.ITEM);
    }

    public boolean shouldMatchAnyTag() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchAnyTag").orElse(true);
    }

    public void setMatchAnyTag(boolean matchAnyTag) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchAnyTag", matchAnyTag);
        this.save();
    }
}

