/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public abstract class UpgradeWrapperBase<W extends IUpgradeWrapper, T extends UpgradeItemBase<W>>
implements IUpgradeWrapper {
    protected final IBackpackWrapper backpackWrapper;
    protected final Consumer<ItemStack> upgradeSaveHandler;
    protected final ItemStack upgrade;
    protected final T upgradeItem;
    private long cooldown = 0L;

    protected UpgradeWrapperBase(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        this.backpackWrapper = backpackWrapper;
        this.upgrade = upgrade;
        this.upgradeItem = (UpgradeItemBase)upgrade.m_41720_();
        this.upgradeSaveHandler = upgradeSaveHandler;
    }

    @Override
    public ItemStack getUpgradeStack() {
        return this.upgrade;
    }

    protected void save() {
        this.upgradeSaveHandler.accept(this.upgrade);
    }

    protected void setCooldown(Level world, int time) {
        this.cooldown = world.m_46467_() + (long)time;
    }

    public long getCooldownTime() {
        return this.cooldown;
    }

    public boolean isInCooldown(Level world) {
        return this.getCooldownTime() > world.m_46467_();
    }

    @Override
    public boolean isEnabled() {
        return NBTHelper.getBoolean(this.upgrade, "enabled").orElse(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        NBTHelper.setBoolean(this.upgrade, "enabled", enabled);
        this.save();
        this.backpackWrapper.getUpgradeHandler().refreshUpgradeWrappers();
    }
}

