/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.battery;

import java.util.Collections;
import java.util.HashSet;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeType;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.battery.BatteryUpgradeWrapper;

public class BatteryUpgradeItem
extends UpgradeItemBase<BatteryUpgradeWrapper> {
    public static final UpgradeType<BatteryUpgradeWrapper> TYPE = new UpgradeType<BatteryUpgradeWrapper>(BatteryUpgradeWrapper::new);

    @Override
    public UpgradeType<BatteryUpgradeWrapper> getType() {
        return TYPE;
    }

    @Override
    public int getInventoryColumnsTaken() {
        return 2;
    }

    @Override
    public UpgradeSlotChangeResult canAddUpgradeTo(IBackpackWrapper backpackWrapper, ItemStack upgradeStack, boolean firstLevelBackpack) {
        HashSet<Integer> errorUpgradeSlots = new HashSet<Integer>();
        backpackWrapper.getUpgradeHandler().getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof BatteryUpgradeWrapper) {
                errorUpgradeSlots.add((Integer)slot);
            }
        });
        if (!errorUpgradeSlots.isEmpty()) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.translError("add.battery_exists", new Object[0]), errorUpgradeSlots, Collections.emptySet(), Collections.emptySet());
        }
        int multiplierRequired = (int)Math.ceil((float)BatteryUpgradeWrapper.getEnergyStored(upgradeStack) / (float)BatteryUpgradeWrapper.getMaxEnergyStored(backpackWrapper));
        if (multiplierRequired > 1) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.translError("add.battery_energy_high", multiplierRequired), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        return new UpgradeSlotChangeResult.Success();
    }
}

