/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IItemHandlerInteractionUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.FilteredItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositFilterType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class DepositUpgradeWrapper
extends UpgradeWrapperBase<DepositUpgradeWrapper, DepositUpgradeItem>
implements IFilteredUpgrade,
IItemHandlerInteractionUpgrade {
    private final DepositFilterLogic filterLogic;

    public DepositUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new DepositFilterLogic(upgrade, upgradeSaveHandler, ((DepositUpgradeItem)this.upgradeItem).getFilterSlotCount());
    }

    @Override
    public DepositFilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public void onHandlerInteract(IItemHandler itemHandler, Player player) {
        if (this.filterLogic.getDepositFilterType() == DepositFilterType.INVENTORY) {
            this.filterLogic.setInventory(itemHandler);
        }
        AtomicInteger stacksAdded = new AtomicInteger(0);
        InventoryHelper.transfer((IItemHandler)this.backpackWrapper.getInventoryForUpgradeProcessing(), new FilteredItemHandler<IItemHandler>(itemHandler, Collections.singletonList(this.filterLogic), Collections.emptyList()), s -> stacksAdded.incrementAndGet());
        int stacksDeposited = stacksAdded.get();
        String translKey = stacksDeposited > 0 ? "gui.sophisticatedbackpacks.status.stacks_deposited" : "gui.sophisticatedbackpacks.status.nothing_to_deposit";
        player.m_5661_((Component)new TranslatableComponent(translKey, new Object[]{stacksDeposited}), true);
    }
}

