/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.feeding;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.feeding.FeedingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.feeding.HungerLevel;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class FeedingUpgradeWrapper
extends UpgradeWrapperBase<FeedingUpgradeWrapper, FeedingUpgradeItem>
implements ITickableUpgrade,
IFilteredUpgrade {
    private static final int COOLDOWN = 100;
    private static final int STILL_HUNGRY_COOLDOWN = 10;
    private static final int FEEDING_RANGE = 3;
    private final FilterLogic filterLogic;

    public FeedingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((FeedingUpgradeItem)this.upgradeItem).getFilterSlotCount(), ItemStack::m_41614_);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        if (this.isInCooldown(world) || entity != null && !(entity instanceof Player)) {
            return;
        }
        if (entity == null) {
            world.m_142425_((EntityTypeTest)EntityType.f_20532_, new AABB(pos).m_82400_(3.0), p -> true).forEach(p -> this.feedPlayerAndGetHungry((Player)p, world));
        } else if (this.feedPlayerAndGetHungry((Player)entity, world)) {
            this.setCooldown(world, 10);
            return;
        }
        this.setCooldown(world, 100);
    }

    private boolean feedPlayerAndGetHungry(Player player, Level world) {
        int hungerLevel = 20 - player.m_36324_().m_38702_();
        if (hungerLevel == 0) {
            return false;
        }
        return this.tryFeedingFoodFromBackpack(world, hungerLevel, player) && player.m_36324_().m_38702_() < 20;
    }

    private boolean tryFeedingFoodFromBackpack(Level world, int hungerLevel, Player player) {
        boolean isHurt = player.m_21223_() < player.m_21233_() - 0.1f;
        IItemHandlerSimpleInserter inventory = this.backpackWrapper.getInventoryForUpgradeProcessing();
        AtomicBoolean fedPlayer = new AtomicBoolean(false);
        InventoryHelper.iterate((IItemHandler)inventory, (slot, stack) -> {
            if (stack.m_41614_() && this.filterLogic.matchesFilter((ItemStack)stack) && (this.isHungryEnoughForFood(hungerLevel, (ItemStack)stack) || this.shouldFeedImmediatelyWhenHurt() && hungerLevel > 0 && isHurt)) {
                ItemStack mainHandItem = player.m_21205_();
                player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, stack);
                if (stack.m_41682_(world, player, InteractionHand.MAIN_HAND).m_19089_() == InteractionResult.CONSUME) {
                    player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)mainHandItem);
                    ItemStack containerItem = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)stack.m_41777_(), (int)0, (ItemStack)stack.m_41720_().m_5922_(stack, world, (LivingEntity)player));
                    inventory.setStackInSlot(slot.intValue(), (ItemStack)stack);
                    if (!ItemStack.m_41728_((ItemStack)containerItem, (ItemStack)stack)) {
                        player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).ifPresent(playerInventory -> InventoryHelper.insertOrDropItem(player, containerItem, new IItemHandler[]{inventory, playerInventory}));
                    }
                    fedPlayer.set(true);
                    return true;
                }
                player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)mainHandItem);
            }
            return false;
        }, () -> false, ret -> ret);
        return fedPlayer.get();
    }

    private boolean isHungryEnoughForFood(int hungerLevel, ItemStack stack) {
        HungerLevel feedAtHungerLevel = this.getFeedAtHungerLevel();
        if (feedAtHungerLevel == HungerLevel.ANY) {
            return true;
        }
        int nutrition = stack.m_41720_().m_41473_().m_38744_();
        return (feedAtHungerLevel == HungerLevel.HALF ? nutrition / 2 : nutrition) <= hungerLevel;
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public HungerLevel getFeedAtHungerLevel() {
        return NBTHelper.getEnumConstant(this.upgrade, "feedAtHungerLevel", HungerLevel::fromName).orElse(HungerLevel.HALF);
    }

    public void setFeedAtHungerLevel(HungerLevel hungerLevel) {
        NBTHelper.setEnumConstant(this.upgrade, "feedAtHungerLevel", hungerLevel);
        this.save();
    }

    public boolean shouldFeedImmediatelyWhenHurt() {
        return NBTHelper.getBoolean(this.upgrade, "feedImmediatelyWhenHurt").orElse(true);
    }

    public void setFeedImmediatelyWhenHurt(boolean feedImmediatelyWhenHurt) {
        NBTHelper.setBoolean(this.upgrade, "feedImmediatelyWhenHurt", feedImmediatelyWhenHurt);
        this.save();
    }
}

