/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.ArrayList;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InventoryOrder;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.SubBackpacksHandler;

public class InceptionFluidHandler
implements IBackpackFluidHandler {
    @Nullable
    private final IBackpackFluidHandler wrappedFluidHandler;
    private final InventoryOrder inventoryOrder;
    private final SubBackpacksHandler subBackpacksHandler;
    private IBackpackFluidHandler[] fluidHandlers;
    protected int[] baseIndex;
    protected int tankCount;
    private final ItemStack backpack;

    public InceptionFluidHandler(@Nullable IBackpackFluidHandler wrappedFluidHandler, ItemStack backpack, InventoryOrder inventoryOrder, SubBackpacksHandler subBackpacksHandler) {
        this.wrappedFluidHandler = wrappedFluidHandler;
        this.backpack = backpack;
        this.inventoryOrder = inventoryOrder;
        this.subBackpacksHandler = subBackpacksHandler;
        subBackpacksHandler.addRefreshListener(sbs -> this.refreshHandlers());
        this.refreshHandlers();
    }

    private void refreshHandlers() {
        ArrayList<IBackpackFluidHandler> handlers = new ArrayList<IBackpackFluidHandler>();
        if (this.wrappedFluidHandler != null && this.inventoryOrder == InventoryOrder.MAIN_FIRST) {
            handlers.add(this.wrappedFluidHandler);
        }
        this.subBackpacksHandler.getSubBackpacks().forEach(sbp -> sbp.getFluidHandler().ifPresent(handlers::add));
        if (this.wrappedFluidHandler != null && this.inventoryOrder == InventoryOrder.INCEPTED_FIRST) {
            handlers.add(this.wrappedFluidHandler);
        }
        this.fluidHandlers = handlers.toArray(new IBackpackFluidHandler[0]);
        this.baseIndex = new int[this.fluidHandlers.length];
        int index = 0;
        for (int i = 0; i < this.fluidHandlers.length; ++i) {
            this.baseIndex[i] = index += this.fluidHandlers[i].getTanks();
        }
        this.tankCount = index;
    }

    public int getTanks() {
        return this.tankCount;
    }

    private int getHandlerIndexForTank(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    protected IFluidHandler getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.fluidHandlers.length) {
            return EmptyFluidHandler.INSTANCE;
        }
        return this.fluidHandlers[index];
    }

    protected int getTankFromIndex(int tank, int handlerIndex) {
        if (handlerIndex <= 0 || handlerIndex >= this.baseIndex.length) {
            return tank;
        }
        return tank - this.baseIndex[handlerIndex - 1];
    }

    private <T> T getFluidHandlerValue(int overallTank, BiFunction<IFluidHandler, Integer, T> getValue) {
        int handlerIndex = this.getHandlerIndexForTank(overallTank);
        return getValue.apply(this.getHandlerFromIndex(handlerIndex), this.getTankFromIndex(overallTank, handlerIndex));
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluidHandlerValue(tank, IFluidHandler::getFluidInTank);
    }

    public int getTankCapacity(int tank) {
        return this.getFluidHandlerValue(tank, IFluidHandler::getTankCapacity);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.getFluidHandlerValue(tank, (h, t) -> h.isFluidValid(t.intValue(), stack));
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreInOutLimit) {
        int filled = 0;
        FluidStack toFill = resource;
        for (IBackpackFluidHandler fluidHandler : this.fluidHandlers) {
            if ((filled += fluidHandler.fill(toFill, action, ignoreInOutLimit)) == resource.getAmount()) {
                return resource.getAmount();
            }
            toFill = new FluidStack(toFill.getFluid(), resource.getAmount() - filled);
        }
        return filled;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.fill(resource, action, false);
    }

    @Override
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreInOutLimit) {
        int drained = 0;
        FluidStack toDrain = resource;
        for (IBackpackFluidHandler fluidHandler : this.fluidHandlers) {
            if ((drained += fluidHandler.drain(toDrain, action, ignoreInOutLimit).getAmount()) == resource.getAmount()) {
                return resource;
            }
            toDrain = new FluidStack(toDrain.getFluid(), resource.getAmount() - drained);
        }
        return drained == 0 ? FluidStack.EMPTY : new FluidStack(resource.getFluid(), drained);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.drain(resource, action, false);
    }

    @Override
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action, boolean ignoreInOutLimit) {
        for (IBackpackFluidHandler fluidHandler : this.fluidHandlers) {
            FluidStack drained = fluidHandler.drain(maxDrain, action, ignoreInOutLimit);
            if (drained.isEmpty()) continue;
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(maxDrain, action, false);
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.backpack;
    }
}

