/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.SoundStopNotificationMessage;

public class BackpackSoundHandler {
    private static final int SOUND_STOP_CHECK_INTERVAL = 10;
    private static final Map<UUID, SoundInstance> backpackSounds = new ConcurrentHashMap<UUID, SoundInstance>();
    private static long lastPlaybackChecked = 0L;

    private BackpackSoundHandler() {
    }

    public static void playBackpackSound(UUID backpackUuid, SoundInstance sound) {
        BackpackSoundHandler.stopBackpackSound(backpackUuid);
        backpackSounds.put(backpackUuid, sound);
        Minecraft.m_91087_().m_91106_().m_120367_(sound);
    }

    public static void stopBackpackSound(UUID backpackUuid) {
        if (backpackSounds.containsKey(backpackUuid)) {
            Minecraft.m_91087_().m_91106_().m_120399_(backpackSounds.remove(backpackUuid));
            PacketHandler.sendToServer(new SoundStopNotificationMessage(backpackUuid));
        }
    }

    public static void tick(TickEvent.WorldTickEvent event) {
        if (!backpackSounds.isEmpty() && lastPlaybackChecked < event.world.m_46467_() - 10L) {
            lastPlaybackChecked = event.world.m_46467_();
            backpackSounds.entrySet().removeIf(entry -> {
                if (!Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)entry.getValue())) {
                    PacketHandler.sendToServer(new SoundStopNotificationMessage((UUID)entry.getKey()));
                    return true;
                }
                return false;
            });
        }
    }

    public static void playBackpackSound(SoundEvent soundEvent, UUID backpackUuid, BlockPos pos) {
        BackpackSoundHandler.playBackpackSound(backpackUuid, (SoundInstance)SimpleSoundInstance.m_119747_((SoundEvent)soundEvent, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
    }

    public static void playBackpackSound(SoundEvent soundEvent, UUID backpackUuid, int entityId) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        Entity entity = world.m_6815_(entityId);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        BackpackSoundHandler.playBackpackSound(backpackUuid, (SoundInstance)new EntityBoundSoundInstance(soundEvent, SoundSource.RECORDS, 2.0f, 1.0f, entity));
    }

    public static void onWorldUnload(WorldEvent.Unload evt) {
        backpackSounds.clear();
        lastPlaybackChecked = 0L;
    }
}

