/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.magnet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModFluids;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IContentsFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.magnet.IMagnetPreventionChecker;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.magnet.MagnetUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.XpHelper;

public class MagnetUpgradeWrapper
extends UpgradeWrapperBase<MagnetUpgradeWrapper, MagnetUpgradeItem>
implements IContentsFilteredUpgrade,
ITickableUpgrade,
IPickupResponseUpgrade {
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    private static final String ALLOW_MACHINE_MOVEMENT = "AllowMachineRemoteMovement";
    private static final int COOLDOWN_TICKS = 10;
    private static final int FULL_COOLDOWN_TICKS = 40;
    private final ContentsFilterLogic filterLogic;
    private static final Set<IMagnetPreventionChecker> magnetCheckers = new HashSet<IMagnetPreventionChecker>();

    public static void addMagnetPreventionChecker(IMagnetPreventionChecker checker) {
        magnetCheckers.add(checker);
    }

    public MagnetUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((MagnetUpgradeItem)this.upgradeItem).getFilterSlotCount(), backpackWrapper::getInventoryHandler);
    }

    @Override
    public ContentsFilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public ItemStack pickup(Level world, ItemStack stack, boolean simulate) {
        ItemStack ret;
        if (this.isInLongCooldown(world)) {
            return stack;
        }
        if (!this.filterLogic.matchesFilter(stack)) {
            return stack;
        }
        int originalCount = stack.m_41613_();
        if (originalCount == (ret = this.backpackWrapper.getInventoryForUpgradeProcessing().insertItem(stack, simulate)).m_41613_()) {
            this.setCooldown(world, 40);
        }
        return ret;
    }

    private boolean isInLongCooldown(Level world) {
        return this.getCooldownTime() - 10L > world.m_46467_();
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        int cooldown;
        if (this.isInCooldown(world)) {
            return;
        }
        int n = cooldown = this.shouldPickupItems() ? this.pickupItems(entity, world, pos) : 40;
        if (this.shouldPickupXp() && this.canFillBackpackWithXp()) {
            cooldown = Math.min(cooldown, this.pickupXpOrbs(entity, world, pos));
        }
        this.setCooldown(world, cooldown);
    }

    private boolean canFillBackpackWithXp() {
        return this.backpackWrapper.getFluidHandler().map(fluidHandler -> fluidHandler.fill(new FluidStack((Fluid)ModFluids.XP_STILL.get(), 1), IFluidHandler.FluidAction.SIMULATE) > 0).orElse(false);
    }

    private int pickupXpOrbs(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        List xpEntities = world.m_6443_(ExperienceOrb.class, new AABB(pos).m_82400_((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (xpEntities.isEmpty()) {
            return 10;
        }
        int cooldown = 40;
        for (ExperienceOrb xpOrb : xpEntities) {
            if (!xpOrb.m_6084_() || this.canNotPickup((Entity)xpOrb, entity)) continue;
            if (!this.tryToFillTank(xpOrb, world)) break;
            cooldown = 10;
        }
        return cooldown;
    }

    private boolean tryToFillTank(ExperienceOrb xpOrb, Level world) {
        int amountToTransfer = XpHelper.experienceToLiquid(xpOrb.m_20801_());
        return this.backpackWrapper.getFluidHandler().map(fluidHandler -> {
            int amountAdded = fluidHandler.fill(new FluidStack((Fluid)ModFluids.XP_STILL.get(), amountToTransfer), IFluidHandler.FluidAction.EXECUTE);
            if (amountAdded > 0) {
                Vec3 pos = xpOrb.m_20182_();
                xpOrb.f_20770_ = 0;
                xpOrb.m_146870_();
                if (amountToTransfer > amountAdded) {
                    world.m_7967_((Entity)new ExperienceOrb(world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), XpHelper.liquidToExperience(amountToTransfer - amountAdded)));
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    private int pickupItems(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        List itemEntities = world.m_142425_((EntityTypeTest)EntityType.f_20461_, new AABB(pos).m_82400_((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (itemEntities.isEmpty()) {
            return 10;
        }
        int cooldown = 40;
        for (ItemEntity itemEntity : itemEntities) {
            if (!itemEntity.m_6084_() || !this.filterLogic.matchesFilter(itemEntity.m_32055_()) || this.canNotPickup((Entity)itemEntity, entity) || !this.tryToInsertItem(itemEntity)) continue;
            cooldown = 10;
        }
        return cooldown;
    }

    private boolean isBlockedBySomething(Entity entity) {
        for (IMagnetPreventionChecker checker : magnetCheckers) {
            if (!checker.isBlocked(entity)) continue;
            return true;
        }
        return false;
    }

    private boolean canNotPickup(Entity entity, @Nullable LivingEntity player) {
        if (this.isBlockedBySomething(entity)) {
            return true;
        }
        CompoundTag data = entity.getPersistentData();
        return player != null ? data.m_128441_(PREVENT_REMOTE_MOVEMENT) : data.m_128441_(PREVENT_REMOTE_MOVEMENT) && !data.m_128441_(ALLOW_MACHINE_MOVEMENT);
    }

    private boolean tryToInsertItem(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        IItemHandlerSimpleInserter inventory = this.backpackWrapper.getInventoryForUpgradeProcessing();
        ItemStack remaining = inventory.insertItem(stack, true);
        boolean insertedSomething = false;
        if (remaining.m_41613_() != stack.m_41613_()) {
            insertedSomething = true;
            remaining = inventory.insertItem(stack, false);
            itemEntity.m_32045_(remaining);
        }
        return insertedSomething;
    }

    public void setPickupItems(boolean pickupItems) {
        NBTHelper.setBoolean(this.upgrade, "pickupItems", pickupItems);
        this.save();
    }

    public boolean shouldPickupItems() {
        return NBTHelper.getBoolean(this.upgrade, "pickupItems").orElse(true);
    }

    public void setPickupXp(boolean pickupXp) {
        NBTHelper.setBoolean(this.upgrade, "pickupXp", pickupXp);
        this.save();
    }

    public boolean shouldPickupXp() {
        return NBTHelper.getBoolean(this.upgrade, "pickupXp").orElse(true);
    }
}

