/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class FluidFilterLogic {
    private final List<Fluid> fluidFilters;
    private final ItemStack upgrade;
    private final Consumer<ItemStack> saveHandler;
    private boolean noFilter = true;

    public FluidFilterLogic(int filterSlots, ItemStack upgrade, Consumer<ItemStack> saveHandler) {
        this.fluidFilters = NonNullList.m_122780_((int)filterSlots, (Object)Fluids.f_76191_);
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.deserializeFluidFilters();
        this.updateNoFilter();
    }

    private void deserializeFluidFilters() {
        NBTHelper.getTagValue(this.upgrade, "", "fluids", (c, n1) -> c.m_128437_(n1, 8)).ifPresent(listNbt -> {
            int i = 0;
            for (Tag elementNbt : listNbt) {
                Fluid value = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(elementNbt.m_7916_()));
                if (value != null) {
                    this.fluidFilters.set(i, value);
                }
                if (++i < this.fluidFilters.size()) continue;
                break;
            }
        });
    }

    private void updateNoFilter() {
        this.noFilter = true;
        for (Fluid fluidFilter : this.fluidFilters) {
            if (fluidFilter == Fluids.f_76191_) continue;
            this.noFilter = false;
            return;
        }
    }

    public boolean fluidMatches(Fluid fluid) {
        return this.noFilter || this.matchesFluidFilter(fluid);
    }

    private boolean matchesFluidFilter(Fluid fluid) {
        for (Fluid fluidFilter : this.fluidFilters) {
            if (fluidFilter != fluid) continue;
            return true;
        }
        return false;
    }

    private void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public void setFluid(int index, Fluid fluid) {
        this.fluidFilters.set(index, fluid);
        this.serializeFluidFilters();
        this.updateNoFilter();
        this.save();
    }

    public Fluid getFluid(int index) {
        return this.fluidFilters.get(index);
    }

    public int getNumberOfFluidFilters() {
        return this.fluidFilters.size();
    }

    private void serializeFluidFilters() {
        ListTag fluids = new ListTag();
        this.fluidFilters.forEach(f -> fluids.add((Object)StringTag.m_129297_((String)f.getRegistryName().toString())));
        this.upgrade.m_41784_().m_128365_("fluids", (Tag)fluids);
    }
}

