/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump.FluidFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump.PumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.WorldHelper;

public class PumpUpgradeWrapper
extends UpgradeWrapperBase<PumpUpgradeWrapper, PumpUpgradeItem>
implements ITickableUpgrade {
    private static final int DID_NOTHING_COOLDOWN_TIME = 40;
    private static final int HAND_INTERACTION_COOLDOWN_TIME = 3;
    private static final int WORLD_INTERACTION_COOLDOWN_TIME = 20;
    private static final int FLUID_HANDLER_INTERACTION_COOLDOWN_TIME = 20;
    private static final int PLAYER_SEARCH_RANGE = 3;
    private static final int PUMP_IN_WORLD_RANGE = 4;
    private static final int PUMP_IN_WORLD_RANGE_SQR = 16;
    private long lastHandActionTime = -1L;
    private final FluidFilterLogic fluidFilterLogic;

    protected PumpUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.fluidFilterLogic = new FluidFilterLogic((Integer)Config.COMMON.pumpUpgrade.filterSlots.get(), upgrade, upgradeSaveHandler);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        if (this.isInCooldown(world)) {
            return;
        }
        this.setCooldown(world, this.backpackWrapper.getFluidHandler().map(backpackFluidHandler -> this.tick((IFluidHandlerItem)backpackFluidHandler, entity, world, pos)).orElse(40));
    }

    private int tick(IFluidHandlerItem backpackFluidHandler, @Nullable LivingEntity entity, Level world, BlockPos pos) {
        Player player;
        if (entity == null) {
            Optional<Integer> newCooldown = this.handleInWorldInteractions(backpackFluidHandler, world, pos);
            if (newCooldown.isPresent()) {
                return newCooldown.get();
            }
        } else if (this.shouldInteractWithHand() && entity instanceof Player && this.handleFluidContainerInHands(player = (Player)entity, (IFluidHandler)backpackFluidHandler)) {
            this.lastHandActionTime = world.m_46467_();
            return 3;
        }
        return this.lastHandActionTime + 30L > world.m_46467_() ? 3 : 40;
    }

    private Optional<Integer> handleInWorldInteractions(IFluidHandlerItem backpackFluidHandler, Level world, BlockPos pos) {
        Optional<Integer> newCooldown;
        if (this.shouldInteractWithHand() && this.handleFluidContainersInHandsOfNearbyPlayers(world, pos, (IFluidHandler)backpackFluidHandler)) {
            this.lastHandActionTime = world.m_46467_();
            return Optional.of(3);
        }
        if (this.shouldInteractWithWorld() && (newCooldown = this.interactWithWorld(world, pos, (IFluidHandler)backpackFluidHandler)).isPresent()) {
            return newCooldown;
        }
        return this.interactWithAttachedFluidHandlers(world, pos, (IFluidHandler)backpackFluidHandler);
    }

    private Optional<Integer> interactWithAttachedFluidHandlers(Level world, BlockPos pos, IFluidHandler backpackFluidHandler) {
        for (Direction dir : Direction.values()) {
            boolean successful = WorldHelper.getTile((BlockGetter)world, pos.m_141952_(dir.m_122436_())).map(te -> te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.m_122424_()).map(fluidHandler -> {
                if (this.isInput()) {
                    return this.fillFromFluidHandler((IFluidHandler)fluidHandler, backpackFluidHandler, this.getMaxInOut());
                }
                return this.fillFluidHandler((IFluidHandler)fluidHandler, backpackFluidHandler, this.getMaxInOut());
            }).orElse(false)).orElse(false);
            if (!successful) continue;
            return Optional.of(20);
        }
        return Optional.empty();
    }

    private int getMaxInOut() {
        return Math.max(1000, (Integer)Config.COMMON.pumpUpgrade.maxInputOutput.get() * this.backpackWrapper.getNumberOfSlotRows() * PumpUpgradeWrapper.getAdjustedStackMultiplier(this.backpackWrapper));
    }

    public static int getAdjustedStackMultiplier(IBackpackWrapper backpackWrapper) {
        return 1 + (int)((Double)Config.COMMON.pumpUpgrade.stackMultiplierRatio.get() * (double)(backpackWrapper.getInventoryHandler().getStackSizeMultiplier() - 1));
    }

    private Optional<Integer> interactWithWorld(Level world, BlockPos pos, IFluidHandler backpackFluidHandler) {
        if (this.isInput()) {
            return this.fillFromBlockInRange(world, pos, backpackFluidHandler);
        }
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = pos.m_141952_(dir.m_122436_());
            if (!this.placeFluidInWorld(world, backpackFluidHandler, dir, offsetPos)) continue;
            return Optional.of(20);
        }
        return Optional.empty();
    }

    private boolean placeFluidInWorld(Level world, IFluidHandler backpackFluidHandler, Direction dir, BlockPos offsetPos) {
        if (dir != Direction.UP) {
            for (int tank = 0; tank < backpackFluidHandler.getTanks(); ++tank) {
                FluidStack tankFluid = backpackFluidHandler.getFluidInTank(tank);
                if (tankFluid.isEmpty() || !this.fluidFilterLogic.fluidMatches(tankFluid.getFluid()) || !this.isValidForFluidPlacement(world, offsetPos) || !FluidUtil.tryPlaceFluid(null, (Level)world, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)offsetPos, (IFluidHandler)backpackFluidHandler, (FluidStack)tankFluid)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidForFluidPlacement(Level world, BlockPos offsetPos) {
        BlockState blockState = world.m_8055_(offsetPos);
        return blockState.m_60795_() || !blockState.m_60819_().m_76178_() && !blockState.m_60819_().m_76170_();
    }

    private Optional<Integer> fillFromBlockInRange(Level world, BlockPos basePos, IFluidHandler backpackFluidHandler) {
        LinkedList<BlockPos> nextPositions = new LinkedList<BlockPos>();
        HashSet<BlockPos> searchedPositions = new HashSet<BlockPos>();
        nextPositions.add(basePos);
        while (!nextPositions.isEmpty()) {
            BlockPos pos = (BlockPos)nextPositions.poll();
            if (this.fillFromBlock(world, pos, backpackFluidHandler)) {
                return Optional.of((int)(Math.max(1.0, Math.sqrt(basePos.m_123331_((Vec3i)pos))) * 20.0));
            }
            for (Direction dir : Direction.values()) {
                BlockPos offsetPos = pos.m_141952_(dir.m_122436_());
                if (searchedPositions.contains(offsetPos)) continue;
                searchedPositions.add(offsetPos);
                if (!(basePos.m_123331_((Vec3i)offsetPos) < 16.0)) continue;
                nextPositions.add(offsetPos);
            }
        }
        return Optional.empty();
    }

    private boolean fillFromBlock(Level world, BlockPos pos, IFluidHandler backpackFluidHandler) {
        FluidState fluidState = world.m_6425_(pos);
        if (!fluidState.m_76178_()) {
            FluidBlockWrapper targetFluidHandler;
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof IFluidBlock) {
                IFluidBlock fluidBlock = (IFluidBlock)block;
                targetFluidHandler = new FluidBlockWrapper(fluidBlock, world, pos);
            } else if (block instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)block;
                targetFluidHandler = new BucketPickupHandlerWrapper(bucketPickup, world, pos);
            } else {
                return false;
            }
            return this.fillFromFluidHandler((IFluidHandler)targetFluidHandler, backpackFluidHandler);
        }
        return false;
    }

    private boolean handleFluidContainersInHandsOfNearbyPlayers(Level world, BlockPos pos, IFluidHandler backpackFluidHandler) {
        AABB searchBox = new AABB(pos).m_82400_(3.0);
        for (Player player : world.m_6907_()) {
            if (!searchBox.m_82393_(player.m_20185_(), player.m_20186_(), player.m_20189_()) || !this.handleFluidContainerInHands(player, backpackFluidHandler)) continue;
            return true;
        }
        return false;
    }

    private boolean handleFluidContainerInHands(Player player, IFluidHandler backpackFluidHandler) {
        return this.handleFluidContainerInHand(backpackFluidHandler, player, InteractionHand.MAIN_HAND) || this.handleFluidContainerInHand(backpackFluidHandler, player, InteractionHand.OFF_HAND);
    }

    private boolean handleFluidContainerInHand(IFluidHandler backpackFluidHandler, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (itemInHand.m_41613_() > 1 || itemInHand == this.backpackWrapper.getBackpack()) {
            return false;
        }
        return itemInHand.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(itemFluidHandler -> {
            if (this.isInput()) {
                return this.fillFromHand(player, hand, (IFluidHandlerItem)itemFluidHandler, backpackFluidHandler);
            }
            return this.fillContainerInHand(player, hand, (IFluidHandlerItem)itemFluidHandler, backpackFluidHandler);
        }).orElse(false);
    }

    private boolean fillContainerInHand(Player player, InteractionHand hand, IFluidHandlerItem itemFluidHandler, IFluidHandler backpackFluidHandler) {
        boolean ret = this.fillFluidHandler((IFluidHandler)itemFluidHandler, backpackFluidHandler);
        if (ret) {
            player.m_21008_(hand, itemFluidHandler.getContainer());
        }
        return ret;
    }

    private boolean fillFluidHandler(IFluidHandler fluidHandler, IFluidHandler backpackFluidHandler) {
        return this.fillFluidHandler(fluidHandler, backpackFluidHandler, 1000);
    }

    private boolean fillFluidHandler(IFluidHandler fluidHandler, IFluidHandler backpackFluidHandler, int maxFill) {
        boolean ret = false;
        for (int tank = 0; tank < backpackFluidHandler.getTanks(); ++tank) {
            FluidStack tankFluid = backpackFluidHandler.getFluidInTank(tank);
            if (tankFluid.isEmpty() || !this.fluidFilterLogic.fluidMatches(tankFluid.getFluid()) || FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)backpackFluidHandler, (FluidStack)new FluidStack(tankFluid.getFluid(), maxFill), (boolean)true).isEmpty()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean fillFromHand(Player player, InteractionHand hand, IFluidHandlerItem itemFluidHandler, IFluidHandler backpackFluidHandler) {
        if (this.fillFromFluidHandler((IFluidHandler)itemFluidHandler, backpackFluidHandler)) {
            player.m_21008_(hand, itemFluidHandler.getContainer());
            return true;
        }
        return false;
    }

    private boolean fillFromFluidHandler(IFluidHandler fluidHandler, IFluidHandler backpackFluidHandler) {
        return this.fillFromFluidHandler(fluidHandler, backpackFluidHandler, 1000);
    }

    private boolean fillFromFluidHandler(IFluidHandler fluidHandler, IFluidHandler backpackFluidHandler, int maxDrain) {
        FluidStack containedFluid = fluidHandler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
        if (!containedFluid.isEmpty() && this.fluidFilterLogic.fluidMatches(containedFluid.getFluid())) {
            return !FluidUtil.tryFluidTransfer((IFluidHandler)backpackFluidHandler, (IFluidHandler)fluidHandler, (FluidStack)containedFluid, (boolean)true).isEmpty();
        }
        return false;
    }

    public void setIsInput(boolean input) {
        NBTHelper.setBoolean(this.upgrade, "input", input);
        this.save();
    }

    public boolean isInput() {
        return NBTHelper.getBoolean(this.upgrade, "input").orElse(true);
    }

    public FluidFilterLogic getFluidFilterLogic() {
        return this.fluidFilterLogic;
    }

    public void setInteractWithHand(boolean interactWithHand) {
        NBTHelper.setBoolean(this.upgrade, "interactWithHand", interactWithHand);
        this.save();
    }

    public boolean shouldInteractWithHand() {
        return NBTHelper.getBoolean(this.upgrade, "interactWithHand").orElse(((PumpUpgradeItem)this.upgradeItem).getInteractWithHandDefault());
    }

    public void setInteractWithWorld(boolean interactWithWorld) {
        NBTHelper.setBoolean(this.upgrade, "interactWithWorld", interactWithWorld);
        this.save();
    }

    public boolean shouldInteractWithWorld() {
        return NBTHelper.getBoolean(this.upgrade, "interactWithWorld").orElse(((PumpUpgradeItem)this.upgradeItem).getInteractWithWorldDefault());
    }
}

