/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.restock;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IItemHandlerInteractionUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.FilteredItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IContentsFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.restock.RestockUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class RestockUpgradeWrapper
extends UpgradeWrapperBase<RestockUpgradeWrapper, RestockUpgradeItem>
implements IContentsFilteredUpgrade,
IItemHandlerInteractionUpgrade {
    private final ContentsFilterLogic filterLogic;

    public RestockUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((RestockUpgradeItem)this.upgradeItem).getFilterSlotCount(), backpackWrapper::getInventoryHandler);
    }

    @Override
    public ContentsFilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public void onHandlerInteract(IItemHandler itemHandler, Player player) {
        AtomicInteger stacksAdded = new AtomicInteger(0);
        InventoryHelper.transfer(itemHandler, new FilteredItemHandler<IItemHandlerSimpleInserter>(this.backpackWrapper.getInventoryForUpgradeProcessing(), Collections.singletonList(this.filterLogic), Collections.emptyList()), s -> stacksAdded.incrementAndGet());
        int stacksRestocked = stacksAdded.get();
        String translKey = stacksRestocked > 0 ? "gui.sophisticatedbackpacks.status.stacks_restocked" : "gui.sophisticatedbackpacks.status.nothing_to_restock";
        player.m_5661_((Component)new TranslatableComponent(translKey, new Object[]{stacksRestocked}), true);
    }
}

