/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.AutoSmeltingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.ISmeltingUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.SmeltingLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.SmeltingUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RecipeHelper;

public class AutoSmeltingUpgradeWrapper
extends UpgradeWrapperBase<AutoSmeltingUpgradeWrapper, AutoSmeltingUpgradeItem>
implements ITickableUpgrade,
ISmeltingUpgrade {
    private static final int NOTHING_TO_DO_COOLDOWN = 10;
    private static final int NO_INVENTORY_SPACE_COOLDOWN = 60;
    private final FilterLogic inputFilterLogic;
    private final FilterLogic fuelFilterLogic;
    private final SmeltingLogic smeltingLogic;
    private final Predicate<ItemStack> isValidInput;
    private final Predicate<ItemStack> isValidFuel;
    private int outputCooldown = 0;
    private int fuelCooldown = 0;
    private int inputCooldown = 0;

    public AutoSmeltingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.inputFilterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)Config.COMMON.autoSmeltingUpgrade.inputFilterSlots.get(), s -> RecipeHelper.getSmeltingRecipe(s).isPresent(), "inputFilter");
        this.fuelFilterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)Config.COMMON.autoSmeltingUpgrade.fuelFilterSlots.get(), s -> ForgeHooks.getBurnTime((ItemStack)s, (RecipeType)RecipeType.f_44108_) > 0, "fuelFilter");
        this.fuelFilterLogic.setAllowByDefault();
        this.fuelFilterLogic.setEmptyAllowListMatchesEverything();
        this.isValidInput = s -> RecipeHelper.getSmeltingRecipe(s).isPresent() && this.inputFilterLogic.matchesFilter((ItemStack)s);
        this.isValidFuel = s -> ForgeHooks.getBurnTime((ItemStack)s, (RecipeType)RecipeType.f_44108_) > 0 && this.fuelFilterLogic.matchesFilter((ItemStack)s);
        this.smeltingLogic = new SmeltingLogic(upgrade, upgradeSaveHandler, this.isValidFuel, this.isValidInput, (Double)Config.COMMON.autoSmeltingUpgrade.smeltingSpeedMultiplier.get(), (Double)Config.COMMON.autoSmeltingUpgrade.fuelEfficiencyMultiplier.get());
    }

    private void tryPushingOutput() {
        if (this.outputCooldown > 0) {
            --this.outputCooldown;
            return;
        }
        ItemStack output = this.smeltingLogic.getCookOutput();
        IItemHandlerSimpleInserter inventory = this.backpackWrapper.getInventoryForUpgradeProcessing();
        if (!output.m_41619_() && inventory.insertItem(output, true).m_41613_() < output.m_41613_()) {
            ItemStack ret = inventory.insertItem(output, false);
            this.smeltingLogic.getSmeltingInventory().extractItem(2, output.m_41613_() - ret.m_41613_(), false);
        } else {
            this.outputCooldown = 60;
        }
        ItemStack fuel = this.smeltingLogic.getFuel();
        if (!fuel.m_41619_() && ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44108_) <= 0 && inventory.insertItem(fuel, true).m_41613_() < fuel.m_41613_()) {
            ItemStack ret = inventory.insertItem(fuel, false);
            this.smeltingLogic.getSmeltingInventory().extractItem(1, fuel.m_41613_() - ret.m_41613_(), false);
        }
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        if (this.isInCooldown(world)) {
            return;
        }
        this.tryPushingOutput();
        this.tryPullingFuel();
        this.tryPullingInput();
        if (!this.smeltingLogic.tick(world) && this.outputCooldown <= 0 && this.fuelCooldown <= 0 && this.inputCooldown <= 0) {
            this.setCooldown(world, 10);
        }
        boolean isBurning = this.smeltingLogic.isBurning(world);
        BackpackRenderInfo renderInfo = this.backpackWrapper.getRenderInfo();
        if (renderInfo.getUpgradeRenderData(SmeltingUpgradeRenderData.TYPE).map(SmeltingUpgradeRenderData::isBurning).orElse(false) != isBurning) {
            if (isBurning) {
                renderInfo.setUpgradeRenderData(SmeltingUpgradeRenderData.TYPE, new SmeltingUpgradeRenderData(true));
            } else {
                renderInfo.removeUpgradeRenderData(SmeltingUpgradeRenderData.TYPE);
            }
        }
    }

    private void tryPullingInput() {
        if (this.inputCooldown > 0) {
            --this.inputCooldown;
            return;
        }
        if (this.tryPullingGetUnsucessful(this.smeltingLogic.getCookInput(), this.smeltingLogic::setCookInput, this.isValidInput)) {
            this.inputCooldown = 60;
        }
    }

    private void tryPullingFuel() {
        if (this.fuelCooldown > 0) {
            --this.fuelCooldown;
            return;
        }
        if (this.tryPullingGetUnsucessful(this.smeltingLogic.getFuel(), this.smeltingLogic::setFuel, this.isValidFuel)) {
            this.fuelCooldown = 60;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryPullingGetUnsucessful(ItemStack stack, Consumer<ItemStack> setSlot, Predicate<ItemStack> isItemValid) {
        ItemStack toExtract;
        IItemHandlerSimpleInserter inventory = this.backpackWrapper.getInventoryForUpgradeProcessing();
        if (stack.m_41619_()) {
            AtomicReference<ItemStack> ret = new AtomicReference<ItemStack>(ItemStack.f_41583_);
            InventoryHelper.iterate((IItemHandler)inventory, (slot, st) -> {
                if (isItemValid.test((ItemStack)st)) {
                    ret.set(st.m_41777_());
                }
            }, () -> !((ItemStack)ret.get()).m_41619_());
            if (ret.get().m_41619_()) return true;
            toExtract = ret.get();
            toExtract.m_41764_(toExtract.m_41741_());
        } else {
            if (stack.m_41613_() == stack.m_41741_() || !isItemValid.test(stack)) {
                return true;
            }
            toExtract = stack.m_41777_();
            toExtract.m_41764_(stack.m_41741_() - stack.m_41613_());
        }
        if (InventoryHelper.extractFromInventory(toExtract, (IItemHandler)inventory, true).m_41613_() <= 0) {
            return true;
        }
        ItemStack toSet = InventoryHelper.extractFromInventory(toExtract, (IItemHandler)inventory, false);
        toSet.m_41769_(stack.m_41613_());
        setSlot.accept(toSet);
        return false;
    }

    @Override
    public SmeltingLogic getSmeltingLogic() {
        return this.smeltingLogic;
    }

    public FilterLogic getInputFilterLogic() {
        return this.inputFilterLogic;
    }

    public FilterLogic getFuelFilterLogic() {
        return this.fuelFilterLogic;
    }
}

