/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RecipeHelper;

public class SmeltingLogic {
    private final ItemStack upgrade;
    private final Consumer<ItemStack> saveHandler;
    private ItemStackHandler smeltingInventory = null;
    public static final int COOK_INPUT_SLOT = 0;
    public static final int COOK_OUTPUT_SLOT = 2;
    public static final int FUEL_SLOT = 1;
    @Nullable
    private SmeltingRecipe smeltingRecipe = null;
    private boolean smeltingRecipeInitialized = false;
    private final Predicate<ItemStack> isFuel;
    private final Predicate<ItemStack> isInput;
    private final double smeltingSpeedMultiplier;
    private final double fuelEfficiencyMultiplier;

    public SmeltingLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, double smeltingSpeedMultiplier, double fuelEfficiencyMultiplier) {
        this(upgrade, saveHandler, s -> SmeltingLogic.getBurnTime(s) > 0, s -> RecipeHelper.getSmeltingRecipe(s).isPresent(), smeltingSpeedMultiplier, fuelEfficiencyMultiplier);
    }

    public SmeltingLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, Predicate<ItemStack> isFuel, Predicate<ItemStack> isInput, double smeltingSpeedMultiplier, double fuelEfficiencyMultiplier) {
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.isFuel = isFuel;
        this.isInput = isInput;
        this.smeltingSpeedMultiplier = smeltingSpeedMultiplier;
        this.fuelEfficiencyMultiplier = fuelEfficiencyMultiplier;
    }

    private void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public boolean tick(Level world) {
        AtomicBoolean didSomething = new AtomicBoolean(true);
        if (this.isBurning(world) || this.readyToStartCooking()) {
            Optional<SmeltingRecipe> fr = this.getSmeltingRecipe();
            if (fr.isEmpty() && this.isCooking()) {
                this.setIsCooking(false);
            }
            fr.ifPresent(recipe -> {
                this.updateFuel(world, (SmeltingRecipe)recipe);
                if (this.isBurning(world) && this.canSmelt((Recipe<?>)recipe)) {
                    this.updateCookingProgress(world, (SmeltingRecipe)recipe);
                } else if (!this.isBurning(world)) {
                    didSomething.set(false);
                }
            });
        }
        if (!this.isBurning(world) && this.isCooking()) {
            this.updateCookingCooldown(world);
        } else {
            didSomething.set(false);
        }
        return didSomething.get();
    }

    public boolean isBurning(Level world) {
        return this.getBurnTimeFinish() >= world.m_46467_();
    }

    private Optional<SmeltingRecipe> getSmeltingRecipe() {
        if (!this.smeltingRecipeInitialized) {
            this.smeltingRecipe = RecipeHelper.getSmeltingRecipe(this.getCookInput()).orElse(null);
            this.smeltingRecipeInitialized = true;
        }
        return Optional.ofNullable(this.smeltingRecipe);
    }

    private void updateCookingCooldown(Level world) {
        if (this.getRemainingCookTime(world) + 2 > this.getCookTimeTotal()) {
            this.setIsCooking(false);
        } else {
            this.setCookTimeFinish(world.m_46467_() + (long)Math.min(this.getRemainingCookTime(world) + 2, this.getCookTimeTotal()));
        }
    }

    private void updateCookingProgress(Level world, SmeltingRecipe smeltingRecipe) {
        if (this.isCooking() && this.finishedCooking(world)) {
            this.smelt((Recipe<?>)smeltingRecipe);
            if (this.canSmelt((Recipe<?>)smeltingRecipe)) {
                this.setCookTime(world, (int)((double)smeltingRecipe.m_43753_() * (1.0 / this.smeltingSpeedMultiplier)));
            } else {
                this.setIsCooking(false);
            }
        } else if (!this.isCooking()) {
            this.setIsCooking(true);
            this.setCookTime(world, (int)((double)smeltingRecipe.m_43753_() * (1.0 / this.smeltingSpeedMultiplier)));
        }
    }

    private boolean finishedCooking(Level world) {
        return this.getCookTimeFinish() <= world.m_46467_();
    }

    private boolean readyToStartCooking() {
        return !this.getFuel().m_41619_() && !this.getCookInput().m_41619_();
    }

    private void smelt(Recipe<?> recipe) {
        if (!this.canSmelt(recipe)) {
            return;
        }
        ItemStack input = this.getCookInput();
        ItemStack recipeOutput = recipe.m_8043_();
        ItemStack output = this.getCookOutput();
        if (output.m_41619_()) {
            this.setCookOutput(recipeOutput.m_41777_());
        } else if (output.m_41720_() == recipeOutput.m_41720_()) {
            output.m_41769_(recipeOutput.m_41613_());
            this.setCookOutput(output);
        }
        if (input.m_41720_() == Blocks.f_50057_.m_5456_() && !this.getFuel().m_41619_() && this.getFuel().m_41720_() == Items.f_42446_) {
            this.setFuel(new ItemStack((ItemLike)Items.f_42447_));
        }
        input.m_41774_(1);
        this.setCookInput(input);
    }

    public void setCookInput(ItemStack input) {
        this.smeltingInventory.setStackInSlot(0, input);
    }

    private void setCookOutput(ItemStack stack) {
        this.getSmeltingInventory().setStackInSlot(2, stack);
    }

    private int getRemainingCookTime(Level world) {
        return (int)(this.getCookTimeFinish() - world.m_46467_());
    }

    private void setCookTime(Level world, int cookTime) {
        this.setCookTimeFinish(world.m_46467_() + (long)cookTime);
        this.setCookTimeTotal(cookTime);
    }

    private void updateFuel(Level world, SmeltingRecipe smeltingRecipe) {
        ItemStack fuel = this.getFuel();
        if (!this.isBurning(world) && this.canSmelt((Recipe<?>)smeltingRecipe)) {
            if (SmeltingLogic.getBurnTime(fuel) <= 0) {
                return;
            }
            this.setBurnTime(world, (int)((double)SmeltingLogic.getBurnTime(fuel) * this.fuelEfficiencyMultiplier / this.smeltingSpeedMultiplier));
            if (this.isBurning(world)) {
                if (fuel.hasContainerItem()) {
                    this.setFuel(fuel.getContainerItem());
                } else if (!fuel.m_41619_()) {
                    fuel.m_41774_(1);
                    this.setFuel(fuel);
                    if (fuel.m_41619_()) {
                        this.setFuel(fuel.getContainerItem());
                    }
                }
            }
        }
    }

    private void setBurnTime(Level world, int burnTime) {
        this.setBurnTimeFinish(world.m_46467_() + (long)burnTime);
        this.setBurnTimeTotal(burnTime);
    }

    protected boolean canSmelt(Recipe<?> smeltingRecipe) {
        if (this.getCookInput().m_41619_()) {
            return false;
        }
        ItemStack recipeOutput = smeltingRecipe.m_8043_();
        if (recipeOutput.m_41619_()) {
            return false;
        }
        ItemStack output = this.getCookOutput();
        if (output.m_41619_()) {
            return true;
        }
        if (!output.m_41656_(recipeOutput)) {
            return false;
        }
        if (output.m_41613_() + recipeOutput.m_41613_() <= 64 && output.m_41613_() + recipeOutput.m_41613_() <= output.m_41741_()) {
            return true;
        }
        return output.m_41613_() + recipeOutput.m_41613_() <= recipeOutput.m_41741_();
    }

    private static int getBurnTime(ItemStack fuel) {
        return ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44108_);
    }

    public ItemStack getCookOutput() {
        return this.getSmeltingInventory().getStackInSlot(2);
    }

    public ItemStack getCookInput() {
        return this.getSmeltingInventory().getStackInSlot(0);
    }

    public ItemStack getFuel() {
        return this.getSmeltingInventory().getStackInSlot(1);
    }

    public void setFuel(ItemStack fuel) {
        this.getSmeltingInventory().setStackInSlot(1, fuel);
    }

    public ItemStackHandler getSmeltingInventory() {
        if (this.smeltingInventory == null) {
            this.smeltingInventory = new ItemStackHandler(3){

                protected void onContentsChanged(int slot) {
                    super.onContentsChanged(slot);
                    SmeltingLogic.this.upgrade.m_41700_("smeltingInventory", (Tag)this.serializeNBT());
                    SmeltingLogic.this.save();
                    if (slot == 0) {
                        SmeltingLogic.this.smeltingRecipeInitialized = false;
                    }
                }

                public boolean isItemValid(int slot, ItemStack stack) {
                    return switch (slot) {
                        case 0 -> SmeltingLogic.this.isInput.test(stack);
                        case 1 -> SmeltingLogic.this.isFuel.test(stack);
                        default -> true;
                    };
                }
            };
            NBTHelper.getCompound(this.upgrade, "smeltingInventory").ifPresent(arg_0 -> ((ItemStackHandler)this.smeltingInventory).deserializeNBT(arg_0));
        }
        return this.smeltingInventory;
    }

    public long getBurnTimeFinish() {
        return NBTHelper.getLong(this.upgrade, "burnTimeFinish").orElse(0L);
    }

    private void setBurnTimeFinish(long burnTimeFinish) {
        NBTHelper.setLong(this.upgrade, "burnTimeFinish", burnTimeFinish);
        this.save();
    }

    public int getBurnTimeTotal() {
        return NBTHelper.getInt(this.upgrade, "burnTimeTotal").orElse(0);
    }

    private void setBurnTimeTotal(int burnTimeTotal) {
        NBTHelper.setInteger(this.upgrade, "burnTimeTotal", burnTimeTotal);
        this.save();
    }

    public long getCookTimeFinish() {
        return NBTHelper.getLong(this.upgrade, "cookTimeFinish").orElse(-1L);
    }

    private void setCookTimeFinish(long cookTimeFinish) {
        NBTHelper.setLong(this.upgrade, "cookTimeFinish", cookTimeFinish);
        this.save();
    }

    public int getCookTimeTotal() {
        return NBTHelper.getInt(this.upgrade, "cookTimeTotal").orElse(0);
    }

    private void setCookTimeTotal(int cookTimeTotal) {
        NBTHelper.setInteger(this.upgrade, "cookTimeTotal", cookTimeTotal);
        this.save();
    }

    public boolean isCooking() {
        return NBTHelper.getBoolean(this.upgrade, "isCooking").orElse(false);
    }

    private void setIsCooking(boolean isCooking) {
        NBTHelper.setBoolean(this.upgrade, "isCooking", isCooking);
        this.save();
    }
}

