/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeWrapper;

public class TankClickMessage {
    private final int upgradeSlot;

    public TankClickMessage(int upgradeSlot) {
        this.upgradeSlot = upgradeSlot;
    }

    public static void encode(TankClickMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.upgradeSlot);
    }

    public static TankClickMessage decode(FriendlyByteBuf packetBuffer) {
        return new TankClickMessage(packetBuffer.readInt());
    }

    public static void onMessage(TankClickMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> TankClickMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer sender, TankClickMessage msg) {
        if (sender == null || !(sender.f_36096_ instanceof BackpackContainer)) {
            return;
        }
        AbstractContainerMenu containerMenu = sender.f_36096_;
        UpgradeContainerBase<?, ?> upgradeContainer = ((BackpackContainer)containerMenu).getUpgradeContainers().get(msg.upgradeSlot);
        if (!(upgradeContainer instanceof TankUpgradeContainer)) {
            return;
        }
        TankUpgradeContainer tankContainer = (TankUpgradeContainer)upgradeContainer;
        ItemStack cursorStack = containerMenu.m_142621_();
        cursorStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandler -> {
            TankUpgradeWrapper tankWrapper = (TankUpgradeWrapper)tankContainer.getUpgradeWrapper();
            FluidStack tankContents = tankWrapper.getContents();
            if (tankContents.isEmpty()) {
                TankClickMessage.drainHandler(sender, containerMenu, fluidHandler, tankWrapper);
            } else if (!tankWrapper.fillHandler((IFluidHandlerItem)fluidHandler, itemStackIn -> {
                containerMenu.m_142503_(itemStackIn);
                sender.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(-1, containerMenu.m_182425_(), -1, containerMenu.m_142621_()));
            })) {
                TankClickMessage.drainHandler(sender, containerMenu, fluidHandler, tankWrapper);
            }
        });
    }

    private static void drainHandler(ServerPlayer sender, AbstractContainerMenu containerMenu, IFluidHandlerItem fluidHandler, TankUpgradeWrapper tankWrapper) {
        tankWrapper.drainHandler(fluidHandler, itemStackIn -> {
            containerMenu.m_142503_(itemStackIn);
            sender.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(-1, containerMenu.m_182425_(), -1, containerMenu.m_142621_()));
        });
    }
}

