/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.util.Collections;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.ItemStackKey;

public interface ISlotTracker {
    public Set<ItemStackKey> getFullStacks();

    public Set<ItemStackKey> getPartialStacks();

    public void removeAndSetSlotIndexes(BackpackInventoryHandler var1, int var2, ItemStack var3);

    public void clear();

    public void refreshSlotIndexesFrom(BackpackInventoryHandler var1);

    public ItemStack insertItemIntoHandler(BackpackInventoryHandler var1, IItemHandlerInserter var2, ItemStack var3, boolean var4);

    public ItemStack insertItemIntoHandler(BackpackInventoryHandler var1, IItemHandlerInserter var2, int var3, ItemStack var4, boolean var5);

    public static class Noop
    implements ISlotTracker {
        @Override
        public Set<ItemStackKey> getFullStacks() {
            return Collections.emptySet();
        }

        @Override
        public Set<ItemStackKey> getPartialStacks() {
            return Collections.emptySet();
        }

        @Override
        public void removeAndSetSlotIndexes(BackpackInventoryHandler inventoryHandler, int slot, ItemStack stack) {
        }

        @Override
        public void clear() {
        }

        @Override
        public void refreshSlotIndexesFrom(BackpackInventoryHandler itemHandler) {
        }

        @Override
        public ItemStack insertItemIntoHandler(BackpackInventoryHandler itemHandler, IItemHandlerInserter inserter, ItemStack stack, boolean simulate) {
            ItemStack remainingStack = stack.m_41777_();
            int slots = itemHandler.getSlots();
            for (int slot = 0; slot < slots && !remainingStack.m_41619_(); ++slot) {
                remainingStack = inserter.insertItem(slot, remainingStack, simulate);
            }
            return remainingStack;
        }

        @Override
        public ItemStack insertItemIntoHandler(BackpackInventoryHandler itemHandler, IItemHandlerInserter inserter, int slot, ItemStack stack, boolean simulate) {
            return inserter.insertItem(slot, stack, simulate);
        }
    }

    public static interface IItemHandlerInserter {
        public ItemStack insertItem(int var1, ItemStack var2, boolean var3);
    }
}

