/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.jei;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.crafting.BackpackDyeRecipe;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;

public class DyeRecipesMaker {
    private DyeRecipesMaker() {
    }

    public static Collection<CraftingRecipe> getRecipes() {
        HashSet<CraftingRecipe> recipes = new HashSet<CraftingRecipe>();
        DyeRecipesMaker.addSingleColorRecipes(recipes);
        DyeRecipesMaker.addMultipleColorsRecipe(recipes);
        return recipes;
    }

    private static void addMultipleColorsRecipe(Set<CraftingRecipe> recipes) {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)Ingredient.m_43911_((Tag)DyeColor.YELLOW.getTag()));
        ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BACKPACK.get()}));
        ingredients.add((Object)Ingredient.f_43901_);
        ingredients.add((Object)Ingredient.m_43911_((Tag)DyeColor.LIME.getTag()));
        ingredients.add((Object)Ingredient.m_43911_((Tag)DyeColor.BLUE.getTag()));
        ingredients.add((Object)Ingredient.m_43911_((Tag)DyeColor.BLACK.getTag()));
        ItemStack backpackOutput = new ItemStack((ItemLike)ModItems.BACKPACK.get());
        int clothColor = BackpackDyeRecipe.calculateColor(13394234, 13394234, List.of(DyeColor.BLUE, DyeColor.YELLOW, DyeColor.LIME));
        int trimColor = BackpackDyeRecipe.calculateColor(6434330, 6434330, List.of(DyeColor.BLUE, DyeColor.BLACK));
        backpackOutput.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> wrapper.setColors(clothColor, trimColor));
        ResourceLocation id = new ResourceLocation("sophisticatedbackpacks", "multiple_colors");
        recipes.add((CraftingRecipe)new ShapedRecipe(id, "", 3, 1, ingredients, backpackOutput));
    }

    private static void addSingleColorRecipes(Set<CraftingRecipe> recipes) {
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation id = new ResourceLocation("sophisticatedbackpacks", "single_color_" + color.m_7912_());
            ItemStack backpackOutput = new ItemStack((ItemLike)ModItems.BACKPACK.get());
            backpackOutput.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> wrapper.setColors(ColorHelper.getColor(color.m_41068_()), ColorHelper.getColor(color.m_41068_())));
            NonNullList ingredients = NonNullList.m_122779_();
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BACKPACK.get()}));
            ingredients.add((Object)Ingredient.m_43911_((Tag)color.getTag()));
            recipes.add((CraftingRecipe)new ShapedRecipe(id, "", 1, 2, ingredients, backpackOutput));
        }
    }
}

