/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;

public class UpgradeToggleMessage {
    private final int upgradeSlot;

    public UpgradeToggleMessage(int upgradeSlot) {
        this.upgradeSlot = upgradeSlot;
    }

    public static void encode(UpgradeToggleMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.upgradeSlot);
    }

    public static UpgradeToggleMessage decode(FriendlyByteBuf packetBuffer) {
        return new UpgradeToggleMessage(packetBuffer.readInt());
    }

    static void onMessage(UpgradeToggleMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> UpgradeToggleMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer player, UpgradeToggleMessage msg) {
        if (player == null) {
            return;
        }
        PlayerInventoryProvider.get().runOnBackpacks((Player)player, (backpack, inventoryName, slot) -> {
            backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(w -> {
                IUpgradeWrapper upgradeWrapper;
                Map slotWrappers = w.getUpgradeHandler().getSlotWrappers();
                if (slotWrappers.containsKey(msg.upgradeSlot) && (upgradeWrapper = (IUpgradeWrapper)slotWrappers.get(msg.upgradeSlot)).canBeDisabled()) {
                    upgradeWrapper.setEnabled(!upgradeWrapper.isEnabled());
                    String translKey = upgradeWrapper.isEnabled() ? "gui.sophisticatedbackpacks.status.upgrade_switched_on" : "gui.sophisticatedbackpacks.status.upgrade_switched_off";
                    player.m_5661_((Component)new TranslatableComponent(translKey, new Object[]{upgradeWrapper.getUpgradeStack().m_41786_()}), true);
                }
            });
            return true;
        });
    }
}

