/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.misc;

import biomesoplenty.common.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class ShortBambooFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.m_8055_(pos).m_60734_() == Blocks.f_50440_;
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos);
    private static final BlockState BAMBOO_TRUNK = (BlockState)((BlockState)((BlockState)Blocks.f_50571_.m_49966_().m_61124_((Property)BambooStalkBlock.f_260603_, (Comparable)Integer.valueOf(1))).m_61124_((Property)BambooStalkBlock.f_260716_, (Comparable)BambooLeaves.NONE)).m_61124_((Property)BambooStalkBlock.f_260694_, (Comparable)Integer.valueOf(0));
    private static final BlockState BAMBOO_FINAL_LARGE = (BlockState)((BlockState)BAMBOO_TRUNK.m_61124_((Property)BambooStalkBlock.f_260716_, (Comparable)BambooLeaves.LARGE)).m_61124_((Property)BambooStalkBlock.f_260694_, (Comparable)Integer.valueOf(1));
    private static final BlockState BAMBOO_TOP_LARGE = (BlockState)BAMBOO_TRUNK.m_61124_((Property)BambooStalkBlock.f_260716_, (Comparable)BambooLeaves.LARGE);
    private static final BlockState BAMBOO_TOP_SMALL = (BlockState)BAMBOO_TRUNK.m_61124_((Property)BambooStalkBlock.f_260716_, (Comparable)BambooLeaves.SMALL);

    public ShortBambooFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource rand = context.m_225041_();
        while (pos.m_123342_() > 1 && this.replace.matches(world, pos)) {
            pos = pos.m_7495_();
        }
        if (!this.placeOn.matches(world, pos.m_7918_(2, 0, 2))) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos((pos = pos.m_7494_()).m_123341_(), pos.m_123342_(), pos.m_123343_());
        if (world.m_46859_((BlockPos)blockpos$mutableblockpos) && Blocks.f_50571_.m_49966_().m_60710_((LevelReader)world, (BlockPos)blockpos$mutableblockpos)) {
            int j = rand.m_188503_(2) + 3;
            for (int l1 = 0; l1 < j && world.m_46859_((BlockPos)blockpos$mutableblockpos); ++l1) {
                world.m_7731_((BlockPos)blockpos$mutableblockpos, BAMBOO_TRUNK, 2);
                blockpos$mutableblockpos.m_122175_(Direction.UP, 1);
            }
            if (blockpos$mutableblockpos.m_123342_() - pos.m_123342_() >= 3) {
                world.m_7731_((BlockPos)blockpos$mutableblockpos, BAMBOO_FINAL_LARGE, 2);
                world.m_7731_((BlockPos)blockpos$mutableblockpos.m_122175_(Direction.DOWN, 1), BAMBOO_TOP_LARGE, 2);
                world.m_7731_((BlockPos)blockpos$mutableblockpos.m_122175_(Direction.DOWN, 1), BAMBOO_TOP_SMALL, 2);
            }
        }
        return true;
    }
}

