/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.datagen;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.util.worldgen.BOPFeatureUtils;
import biomesoplenty.common.util.worldgen.BOPPlacementUtils;
import biomesoplenty.common.worldgen.carver.BOPConfiguredCarvers;
import biomesoplenty.common.worldgen.feature.BOPCaveFeatures;
import biomesoplenty.common.worldgen.feature.BOPMiscOverworldFeatures;
import biomesoplenty.common.worldgen.feature.BOPNetherFeatures;
import biomesoplenty.common.worldgen.feature.BOPTreeFeatures;
import biomesoplenty.common.worldgen.feature.BOPVegetationFeatures;
import biomesoplenty.common.worldgen.placement.BOPCavePlacements;
import biomesoplenty.common.worldgen.placement.BOPMiscOverworldPlacements;
import biomesoplenty.common.worldgen.placement.BOPNetherPlacements;
import biomesoplenty.common.worldgen.placement.BOPTreePlacements;
import biomesoplenty.common.worldgen.placement.BOPVegetationPlacements;
import biomesoplenty.core.BiomesOPlenty;
import biomesoplenty.init.ModBiomes;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerationHandler {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        HolderLookup.Provider lookupProvider = new RegistrySetBuilder().m_254916_(Registries.f_257003_, BOPConfiguredCarvers::bootstrap).m_254916_(Registries.f_256911_, BOPFeatureUtils::bootstrap).m_254916_(Registries.f_256988_, BOPPlacementUtils::bootstrap).m_254916_(Registries.f_256952_, ModBiomes::bootstrapBiomes).m_254929_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_), VanillaRegistries.m_255371_());
        RegistryOps registryOps = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)lookupProvider);
        Map configuredWorldCarverMap = DataGenerationHandler.createMap(Registries.f_257003_, lookupProvider, BOPConfiguredCarvers.class);
        Map configuredFeatureMap = DataGenerationHandler.createMap(Registries.f_256911_, lookupProvider, BOPCaveFeatures.class, BOPMiscOverworldFeatures.class, BOPNetherFeatures.class, BOPTreeFeatures.class, BOPVegetationFeatures.class);
        Map placedFeatureMap = DataGenerationHandler.createMap(Registries.f_256988_, lookupProvider, BOPCavePlacements.class, BOPMiscOverworldPlacements.class, BOPNetherPlacements.class, BOPTreePlacements.class, BOPVegetationPlacements.class);
        Map biomeMap = DataGenerationHandler.createMap(Registries.f_256952_, lookupProvider, BOPBiomes.class);
        generator.addProvider(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"biomesoplenty", (RegistryOps)registryOps, (ResourceKey)Registries.f_257003_, configuredWorldCarverMap));
        generator.addProvider(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"biomesoplenty", (RegistryOps)registryOps, (ResourceKey)Registries.f_256911_, configuredFeatureMap));
        generator.addProvider(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"biomesoplenty", (RegistryOps)registryOps, (ResourceKey)Registries.f_256988_, placedFeatureMap));
        generator.addProvider(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"biomesoplenty", (RegistryOps)registryOps, (ResourceKey)Registries.f_256952_, biomeMap));
    }

    private static <T> Map<ResourceLocation, T> createMap(ResourceKey<? extends Registry<? extends T>> registry, HolderLookup.Provider lookupProvider, Class ... classes) {
        HashMap map = new HashMap();
        List.of(classes).forEach(clazz -> {
            for (Field field : clazz.getFields()) {
                if (field.getType() != ResourceKey.class) continue;
                try {
                    ResourceKey key = (ResourceKey)field.get(null);
                    HolderLookup.RegistryLookup lookup = lookupProvider.m_255025_(registry);
                    map.put(key.m_135782_(), lookup.m_255043_(key).m_203334_());
                }
                catch (IllegalAccessException e) {
                    BiomesOPlenty.LOGGER.error((Object)e);
                }
            }
        });
        return map;
    }
}

