/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.entity;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.entity.BOPEntities;
import biomesoplenty.api.item.BOPItems;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BoatBOP
extends Boat {
    public BoatBOP(EntityType<? extends BoatBOP> type, Level level) {
        super(type, level);
        this.blocksBuilding = true;
    }

    public BoatBOP(Level level, double x, double y, double z) {
        this(BOPEntities.BOAT, level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, serverEntity);
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putString("model", this.getModel().getName());
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.contains("model", 8)) {
            this.entityData.set(DATA_ID_TYPE, (Object)ModelType.byName(nbt.getString("model")).ordinal());
        }
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.lastYd = this.getDeltaMovement().y;
        if (!this.isPassenger()) {
            if (onGround) {
                if (this.fallDistance > 3.0f) {
                    if (this.status != Boat.Status.ON_LAND) {
                        this.resetFallDistance();
                        return;
                    }
                    this.causeFallDamage(this.fallDistance, 1.0f, this.damageSources().fall());
                    if (!this.level().isClientSide && !this.isRemoved()) {
                        this.kill();
                        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            for (int i = 0; i < 3; ++i) {
                                this.spawnAtLocation((ItemLike)this.getModel().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.spawnAtLocation((ItemLike)Items.STICK);
                            }
                        }
                    }
                }
                this.resetFallDistance();
            } else if (!this.level().getFluidState(this.blockPosition().below()).is(FluidTags.WATER) && y < 0.0) {
                this.fallDistance -= (float)y;
            }
        }
    }

    public Item getDropItem() {
        switch (ModelType.byId((Integer)this.entityData.get(DATA_ID_TYPE)).ordinal()) {
            case 0: {
                return BOPItems.FIR_BOAT;
            }
            case 1: {
                return BOPItems.PINE_BOAT;
            }
            case 2: {
                return BOPItems.MAPLE_BOAT;
            }
            case 3: {
                return BOPItems.REDWOOD_BOAT;
            }
            case 4: {
                return BOPItems.MAHOGANY_BOAT;
            }
            case 5: {
                return BOPItems.JACARANDA_BOAT;
            }
            case 6: {
                return BOPItems.PALM_BOAT;
            }
            case 7: {
                return BOPItems.WILLOW_BOAT;
            }
            case 8: {
                return BOPItems.DEAD_BOAT;
            }
            case 9: {
                return BOPItems.MAGIC_BOAT;
            }
            case 10: {
                return BOPItems.UMBRAN_BOAT;
            }
            case 11: {
                return BOPItems.HELLBARK_BOAT;
            }
            case 12: {
                return BOPItems.EMPYREAL_BOAT;
            }
        }
        return Items.OAK_BOAT;
    }

    public void setModel(ModelType type) {
        this.entityData.set(DATA_ID_TYPE, (Object)type.ordinal());
    }

    public ModelType getModel() {
        return ModelType.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    @Deprecated
    public void setVariant(Boat.Type vanillaType) {
    }

    @Deprecated
    public Boat.Type getVariant() {
        return Boat.Type.OAK;
    }

    public static enum ModelType {
        FIR("fir", BOPBlocks.FIR_PLANKS),
        PINE("pine", BOPBlocks.PINE_PLANKS),
        MAPLE("maple", BOPBlocks.MAPLE_PLANKS),
        REDWOOD("redwood", BOPBlocks.REDWOOD_PLANKS),
        MAHOGANY("mahogany", BOPBlocks.MAHOGANY_PLANKS),
        JACARANDA("jacaranda", BOPBlocks.JACARANDA_PLANKS),
        PALM("palm", BOPBlocks.PALM_PLANKS),
        WILLOW("willow", BOPBlocks.WILLOW_PLANKS),
        DEAD("dead", BOPBlocks.DEAD_PLANKS),
        MAGIC("magic", BOPBlocks.MAGIC_PLANKS),
        UMBRAN("umbran", BOPBlocks.UMBRAN_PLANKS),
        HELLBARK("hellbark", BOPBlocks.HELLBARK_PLANKS),
        EMPYREAL("empyreal", BOPBlocks.EMPYREAL_PLANKS);

        private final String name;
        private final Block planks;

        private ModelType(String name, Block planks) {
            this.name = name;
            this.planks = planks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static ModelType byId(int id) {
            ModelType[] type = ModelType.values();
            return type[id < 0 || id >= type.length ? 0 : id];
        }

        public static ModelType byName(String aName) {
            ModelType[] type = ModelType.values();
            return Arrays.stream(type).filter(t -> t.getName().equals(aName)).findFirst().orElse(type[0]);
        }
    }
}

