/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.util.ParticleUtil;
import com.lothrazar.cyclic.util.SoundUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.ForgeEventFactory;

public class CandleWaterBlock
extends BlockCyclic {
    public static ForgeConfigSpec.IntValue TICK_RATE;
    public static ForgeConfigSpec.IntValue RADIUS;
    private MobCategory type = MobCategory.MONSTER;
    private static final double BOUNDS = 3.0;
    private static final VoxelShape AABB;
    private static final double CHANCE_SOUND = 0.3;

    public CandleWaterBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.8f).m_60955_().m_60977_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        boolean old = (Boolean)state.m_61143_((Property)LIT);
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!old)));
        SoundUtil.playSound(world, pos, old ? SoundEvents.f_11937_ : SoundEvents.f_11936_);
        ParticleUtil.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123769_, pos.m_7494_(), 12);
        return InteractionResult.SUCCESS;
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue() && rand.m_188500_() < 0.3) {
            SoundUtil.playSound(worldIn, pos, SoundEvents.f_11936_);
        }
        super.m_214162_(stateIn, worldIn, pos, rand);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        this.triggerUpdate((Level)worldIn, pos, rand);
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        this.triggerUpdate((Level)worldIn, pos, random);
    }

    private void triggerUpdate(Level world, BlockPos pos, RandomSource rand) {
        try {
            if (world instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)world;
                if (!world.f_46443_ && ((Boolean)world.m_8055_(pos).m_61143_((Property)LIT)).booleanValue()) {
                    this.trySpawn(sl, pos, rand);
                }
            }
        }
        catch (Exception exception) {
            ModCyclic.LOGGER.error("Error spawning monster ", exception);
        }
    }

    private void trySpawn(ServerLevel world, BlockPos pos, RandomSource rand) throws Exception {
        float z;
        float y;
        float x = pos.m_123341_() + Mth.m_216271_((RandomSource)rand, (int)(-1 * (Integer)RADIUS.get()), (int)((Integer)RADIUS.get()));
        BlockPos posTarget = new BlockPos((int)x, (int)(y = (float)pos.m_123342_()), (int)(z = (float)(pos.m_123343_() + Mth.m_216271_((RandomSource)rand, (int)(-1 * (Integer)RADIUS.get()), (int)((Integer)RADIUS.get())))));
        Mob monster = this.findMonsterToSpawn((Level)world, posTarget, rand);
        if (monster == null || !world.m_46859_(posTarget)) {
            return;
        }
        monster.m_7678_((double)x, (double)y, (double)z, world.f_46441_.m_188501_() * 360.0f, 0.0f);
        SpawnGroupData canSpawn = ForgeEventFactory.onFinalizeSpawn((Mob)monster, (ServerLevelAccessor)world, (DifficultyInstance)world.m_6436_(posTarget), (MobSpawnType)MobSpawnType.SPAWNER, (SpawnGroupData)null, (CompoundTag)null);
        if (canSpawn == null || !monster.m_5545_((LevelAccessor)world, MobSpawnType.SPAWNER)) {
            this.afterSpawnFailure((Level)world, pos);
        } else if (world.m_7967_((Entity)monster)) {
            this.afterSpawnSuccess(monster, (Level)world, pos, rand);
        }
    }

    private void afterSpawnFailure(Level world, BlockPos pos) {
        world.m_186460_(pos, (Block)this, ((Integer)TICK_RATE.get()).intValue());
    }

    private void afterSpawnSuccess(Mob monster, Level world, BlockPos pos, RandomSource rand) {
        ForgeEventFactory.onFinalizeSpawn((Mob)monster, (ServerLevelAccessor)world.m_7654_().m_129880_(world.m_46472_()), (DifficultyInstance)world.m_6436_(pos), (MobSpawnType)MobSpawnType.SPAWNER, null, null);
        world.m_186460_(pos, (Block)this, ((Integer)TICK_RATE.get()).intValue());
    }

    private Mob findMonsterToSpawn(Level world, BlockPos pos, RandomSource rand) {
        WeightedRandomList spawners = ((Biome)world.m_204166_(pos).m_203334_()).m_47518_().m_151798_(this.type);
        if (spawners.m_146337_()) {
            return null;
        }
        MobSpawnSettings.SpawnerData spawner = spawners.m_216829_(rand).orElse(null);
        if (spawner == null) {
            return null;
        }
        Mob monster = null;
        Entity ent = spawner.f_48404_.m_20615_(world);
        if (ent instanceof Mob) {
            monster = (Mob)ent;
        }
        return monster;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.m_61143_((Property)LIT)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    static {
        AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    }
}

