/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.crafter;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.crafter.ContainerCrafter;
import com.lothrazar.cyclic.capabilities.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.capabilities.block.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCrafter
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 64000;
    public static final int TIMER_FULL = 40;
    public static ForgeConfigSpec.IntValue POWERCONF;
    private CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    ItemStackHandler inputHandler = new ItemStackHandler(10);
    ItemStackHandler outHandler = new ItemStackHandler(10);
    private final LazyOptional<IItemHandler> input = LazyOptional.of(() -> this.inputHandler);
    private final LazyOptional<IItemHandler> output = LazyOptional.of(() -> this.outHandler);
    private final LazyOptional<IItemHandler> gridCap = LazyOptional.of(() -> new ItemStackHandler(9));
    private final LazyOptional<IItemHandler> preview = LazyOptional.of(() -> new ItemStackHandler(1));
    private ItemStackHandlerWrapper inventoryWrapper = new ItemStackHandlerWrapper(this.inputHandler, this.outHandler);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventoryWrapper);
    public static final int IO_NUM_ROWS = 5;
    public static final int IO_NUM_COLS = 2;
    public static final int GRID_NUM_ROWS = 3;
    public static final int GRID_NUM_COLS = 3;
    public static final int IO_SIZE = 10;
    public static final int GRID_SIZE = 9;
    public static final int PREVIEW_SLOT = 29;
    public static final int OUTPUT_SLOT_START = 19;
    public static final int OUTPUT_SLOT_STOP = 28;
    public static final int GRID_SLOT_START = 10;
    public static final int GRID_SLOT_STOP = 18;
    private final TransientCraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)new FakeContainer(MenuType.f_39968_, 18291238), 3, 3);

    public TileCrafter(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.CRAFTER.get(), pos, state);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index != 29 && (index < 19 || index > 28)) {
            super.m_7013_(index, stack);
        }
        return false;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileCrafter tile) {
        tile.serverTick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileCrafter tile) {
        tile.serverTick();
    }

    public void serverTick() {
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.f_58857_.f_46443_) {
            return;
        }
        IEnergyStorage cap = (IEnergyStorage)this.energyCap.orElse(null);
        if (cap == null) {
            return;
        }
        this.syncEnergy();
        int cost = (Integer)POWERCONF.get();
        if (cap.getEnergyStored() < cost && cost > 0) {
            return;
        }
        if (this.timer < 0) {
            this.timer = 0;
        }
        if (--this.timer > 0) {
            return;
        }
        Recipe<CraftingContainer> lastValidRecipe = this.findMatchingRecipe(null);
        if (lastValidRecipe == null) {
            this.timer = 40;
            this.setPreviewSlot(ItemStack.f_41583_);
        } else {
            ItemStack recipeOutput = lastValidRecipe.m_8043_(this.f_58857_.m_9598_()).m_41777_();
            this.setPreviewSlot(recipeOutput);
            if (this.hasFreeSpace((IItemHandler)this.outHandler, recipeOutput) && this.doCraft(lastValidRecipe)) {
                this.timer = 40;
                this.energy.extractEnergy(cost, false);
                this.depositOutput(recipeOutput, this.outHandler);
                NonNullList rem = lastValidRecipe.m_7457_((Container)this.craftMatrix);
                for (int i = 0; i < rem.size(); ++i) {
                    ItemStack s = (ItemStack)rem.get(i);
                    if (!s.m_41619_() && s.m_41720_() == this.craftMatrix.m_8020_(i).m_41720_()) {
                        s = this.depositOutput(s, this.inputHandler);
                    }
                    this.depositOutput(s, this.outHandler);
                }
            }
        }
    }

    private ItemStack depositOutput(ItemStack recipeOutput, ItemStackHandler dest) {
        if (recipeOutput.m_41619_()) {
            return recipeOutput;
        }
        for (int slotId = 0; slotId < dest.getSlots() && !(recipeOutput = dest.insertItem(slotId, recipeOutput, false)).m_41619_(); ++slotId) {
        }
        return recipeOutput;
    }

    private void setPreviewSlot(ItemStack itemStack) {
        IItemHandler previewHandler = (IItemHandler)this.preview.orElse(null);
        if (previewHandler != null) {
            previewHandler.extractItem(0, 64, false);
            previewHandler.insertItem(0, itemStack, false);
        }
    }

    private boolean hasFreeSpace(IItemHandler inv, ItemStack output) {
        ItemStack test = output.m_41777_();
        for (int slotId = 0; slotId < inv.getSlots(); ++slotId) {
            test = inv.insertItem(slotId, test, true);
        }
        return test.m_41619_();
    }

    private boolean doCraft(Recipe<CraftingContainer> lastValidRecipe) {
        HashMap<Integer, List<ItemStack>> putbackStacks = new HashMap<Integer, List<ItemStack>>();
        for (Ingredient ingredient : lastValidRecipe.m_7527_()) {
            if (ingredient.m_43947_()) continue;
            boolean matched = false;
            for (int index = 0; index < this.inputHandler.getSlots(); ++index) {
                ItemStack itemStack = this.inputHandler.getStackInSlot(index);
                if (!ingredient.test(itemStack)) continue;
                if (putbackStacks.containsKey(index)) {
                    putbackStacks.get(index).add(this.inputHandler.getStackInSlot(index).m_41777_());
                } else {
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                    list.add(this.inputHandler.getStackInSlot(index).m_41777_());
                    putbackStacks.put(index, list);
                }
                matched = true;
                this.inputHandler.extractItem(index, 1, false);
                break;
            }
            if (matched) continue;
            this.putbackStacks(putbackStacks, (IItemHandler)this.inputHandler);
            return false;
        }
        return true;
    }

    private void putbackStacks(HashMap<Integer, List<ItemStack>> putbackStacks, IItemHandler itemHandler) {
        for (Map.Entry<Integer, List<ItemStack>> entry : putbackStacks.entrySet()) {
            for (ItemStack stack : entry.getValue()) {
                itemHandler.insertItem(entry.getKey().intValue(), stack, false);
            }
        }
    }

    private Recipe<CraftingContainer> findMatchingRecipe(ArrayList<ItemStack> itemStacksInGrid) {
        IItemHandler gridHandler = (IItemHandler)this.gridCap.orElse(null);
        for (int i = 0; i < gridHandler.getSlots(); ++i) {
            this.craftMatrix.m_6836_(i, gridHandler.getStackInSlot(i).m_41777_());
        }
        List recipes = this.f_58857_.m_7465_().m_44013_(RecipeType.f_44107_);
        for (CraftingRecipe rec : recipes) {
            if (!rec.m_5818_((Container)this.craftMatrix, this.f_58857_)) continue;
            return rec;
        }
        return null;
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.CRAFTER.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerCrafter(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, ItemHandlers type) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            switch (type) {
                case INPUT: {
                    return this.input.cast();
                }
                case OUTPUT: {
                    return this.output.cast();
                }
                case GRID: {
                    return this.gridCap.cast();
                }
                case PREVIEW: {
                    return this.preview.cast();
                }
            }
        }
        return null;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.energyCap.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)tag.m_128469_("energy")));
        this.input.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)tag.m_128469_("input")));
        this.output.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)tag.m_128469_("output")));
        this.gridCap.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)tag.m_128469_("grid")));
        this.preview.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)tag.m_128469_("preview")));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        this.energyCap.ifPresent(h -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            tag.m_128365_("energy", (Tag)compound);
        });
        this.input.ifPresent(h -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            tag.m_128365_("input", (Tag)compound);
        });
        this.output.ifPresent(h -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            tag.m_128365_("output", (Tag)compound);
        });
        this.gridCap.ifPresent(h -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            tag.m_128365_("grid", (Tag)compound);
        });
        this.preview.ifPresent(h -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            tag.m_128365_("preview", (Tag)compound);
        });
        super.m_183515_(tag);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
        }
        return -1;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    public static class FakeContainer
    extends AbstractContainerMenu {
        protected FakeContainer(MenuType<?> type, int id) {
            super(type, id);
        }

        public boolean m_6875_(Player playerIn) {
            return true;
        }

        public ItemStack m_7648_(Player p_38941_, int p_38942_) {
            return ItemStack.f_41583_;
        }
    }

    public static enum ItemHandlers {
        INPUT,
        OUTPUT,
        GRID,
        PREVIEW;

    }

    public static enum Fields {
        TIMER,
        REDSTONE,
        RENDER;

    }
}

