/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.enderitemshelf;

import com.lothrazar.cyclic.block.enderitemshelf.TileItemShelf;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.render.UtilRenderText;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ItemShelfRenderer
implements BlockEntityRenderer<TileItemShelf> {
    public ItemShelfRenderer(BlockEntityRendererProvider.Context d) {
    }

    public void render(TileItemShelf tile, float partialTicks, PoseStack ms, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Direction side = tile.getCurrentFacing();
        UtilRenderText.alignRendering(ms, side);
        for (int i = 0; i < tile.inventory.getSlots(); ++i) {
            this.renderSlot(tile, i, tile.inventory.getStackInSlot(i), ms, buffer, combinedLightIn, combinedOverlayIn);
        }
    }

    private void renderSlot(TileItemShelf tile, int slot, ItemStack stack, PoseStack ms, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (stack.m_41619_()) {
            return;
        }
        float sh = 16.0f;
        boolean color = false;
        double x = 0.09375;
        double y = (float)(3 * slot + 2) / 16.0f;
        double z = 1.01;
        float scaleNum = 0.094f;
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        if (tile.renderStyle == TileEnderShelf.RenderTextType.STACK) {
            float sp = 0.19f;
            float xf = 0.16f + (float)slot * 0.19f / 1.5f;
            float yf = 1.0f - (0.88f - (float)slot * 0.19f);
            float size = 0.12f;
            ms.m_85836_();
            ms.m_252880_(0.0f, 0.0f, 1.0f);
            ms.m_252880_(xf, yf, 0.0f);
            ms.m_85841_(size, size, size);
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.NONE, combinedLightIn, combinedOverlayIn, ms, buffer, tile.m_58904_(), combinedLightIn);
            ms.m_85849_();
        } else if (tile.renderStyle == TileEnderShelf.RenderTextType.TEXT) {
            String displayName = stack.m_41786_().getString();
            float scaleName = 0.02832999f + 0.1f * this.getScaleFactor(displayName);
            ms.m_85836_();
            ms.m_85837_(0.07375, y + 0.06, 1.01);
            ms.m_85841_(0.0625f * scaleName, -0.0625f * scaleName, 5.0E-5f);
            fontRenderer.m_271703_(displayName, 0.0f, 0.0f, 0, false, ms.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, combinedLightIn);
            ms.m_85849_();
        }
        if (tile.renderStyle != TileEnderShelf.RenderTextType.NONE) {
            ms.m_85836_();
            ms.m_85837_((double)0.17475f, y, 1.01);
            ms.m_85841_(0.005875f, -0.005875f, 5.0E-5f);
            String displayCount = "x" + stack.m_41613_();
            fontRenderer.m_271703_(displayCount, 110.0f, 0.0f, 0, false, ms.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, combinedLightIn);
            ms.m_85849_();
        }
    }

    private float getScaleFactor(String displayName) {
        int lv = 17;
        if (displayName.length() > lv) {
            return 1.0f - 0.027777778f * (float)(displayName.length() - lv);
        }
        return 1.0f;
    }
}

