/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.soundrecord;

import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.soundrecord.ScreenSoundRecorder;
import com.lothrazar.cyclic.block.soundrecord.TileSoundRecorder;
import com.lothrazar.cyclic.net.PacketRecordSound;
import com.lothrazar.cyclic.registry.MenuTypeRegistry;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.BlockstatesUtil;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockSoundRecorder
extends BlockCyclic {
    public static ForgeConfigSpec.IntValue RADIUS;

    public BlockSoundRecorder(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.0f).m_60918_(SoundType.f_56756_));
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setHasGui();
    }

    @Override
    public void registerClient() {
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeRegistry.SOUND_RECORDER.get()), ScreenSoundRecorder::new);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileSoundRecorder(pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        if (event.getSound() == null || event.getSound().m_7904_() == null || event.getSound() instanceof TickableSoundInstance || clientWorld == null) {
            return;
        }
        boolean isPowered = false;
        ArrayList<BlockPos> blocks = BlockstatesUtil.findBlocks((Level)clientWorld, new BlockPos((int)event.getSound().m_7772_(), (int)event.getSound().m_7780_(), (int)event.getSound().m_7778_()), (Block)this, (Integer)RADIUS.get(), false);
        for (BlockPos nearby : blocks) {
            String sid = event.getSound().m_7904_().toString();
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketRecordSound(sid, nearby));
            BlockEntity tile = clientWorld.m_7702_(nearby);
            if (!(tile instanceof TileSoundRecorder)) continue;
            ((TileSoundRecorder)tile).onSoundHeard(sid);
        }
    }
}

