/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.tankcask;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.tankcask.TileCask;
import com.lothrazar.cyclic.capabilities.item.FluidHandlerCapabilityStack;
import com.lothrazar.cyclic.util.ItemStackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BlockCask
extends BlockCyclic {
    public BlockCask(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.2f));
        this.setHasFluidInteract();
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileCask(pos, state);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        try {
            IFluidHandler storageTile;
            IFluidHandlerItem storage = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse(null);
            BlockEntity container = world.m_7702_(pos);
            if (storage != null && container != null && (storageTile = (IFluidHandler)container.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)) != null) {
                storageTile.fill(storage.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error during fill from item ", e);
        }
        world.m_46597_(pos, state);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity ent, ItemStack stack) {
        IFluidHandler fluidInStack;
        super.m_6240_(world, player, pos, state, ent, stack);
        ItemStack tankStack = new ItemStack((ItemLike)this);
        if (ent != null && (fluidInStack = (IFluidHandler)tankStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse(null)) != null && ent instanceof TileCask) {
            TileCask cask = (TileCask)ent;
            FluidStack fs = cask.tank.getFluid();
            ((FluidHandlerCapabilityStack)fluidInStack).setFluid(fs);
        }
        ItemStackUtil.dropItemStackMotionless(world, pos, tankStack);
    }
}

