/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.tp;

import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.tp.ScreenTeleport;
import com.lothrazar.cyclic.block.tp.TileTeleport;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.registry.MenuTypeRegistry;
import com.lothrazar.cyclic.util.LevelWorldUtil;
import com.lothrazar.cyclic.world.DimensionTransit;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.ITeleporter;

public class BlockTeleport
extends BlockCyclic {
    public static ForgeConfigSpec.IntValue POWERCONF;
    public static ForgeConfigSpec.IntValue COSTDIM;
    public static final VoxelShape AABB;

    public BlockTeleport(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.2f).m_60955_());
        this.setHasGui();
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!player.m_6047_()) {
            return;
        }
        TileTeleport tile = (TileTeleport)worldIn.m_7702_(pos);
        BlockPosDim dimpos = tile.getTargetInSlot(0);
        if (dimpos != null && worldIn instanceof ServerLevel) {
            int pay = LevelWorldUtil.dimensionIsEqual(dimpos, worldIn) ? (Integer)POWERCONF.get() : (Integer)COSTDIM.get();
            int sim = tile.energy.extractEnergy(pay, true);
            if (pay == 0 || sim == pay) {
                tile.energy.extractEnergy(pay, false);
                DimensionTransit transit = new DimensionTransit((ServerLevel)worldIn, dimpos);
                transit.teleport((Player)player);
                player.changeDimension(transit.getTargetLevel(), (ITeleporter)transit);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @Override
    public void registerClient() {
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeRegistry.TELEPORT.get()), ScreenTeleport::new);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileTeleport(pos, state);
    }

    static {
        AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)0.5, (double)15.0);
    }
}

