/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.wireless.energy;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.wireless.energy.ContainerWirelessEnergy;
import com.lothrazar.cyclic.capabilities.block.CustomEnergyStorage;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.LevelWorldUtil;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;

public class TileWirelessEnergy
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 64000;
    private int transferRate = 8000;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    ItemStackHandler gpsSlots = new ItemStackHandler(8){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() instanceof LocationGpsCard;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };

    public TileWirelessEnergy(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.WIRELESS_ENERGY.get(), pos, state);
        this.needsRedstone = 0;
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.WIRELESS_ENERGY.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerWirelessEnergy(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.gpsSlots.deserializeNBT(tag.m_128469_("inv"));
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.gpsSlots.serializeNBT());
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        super.m_183515_(tag);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileWirelessEnergy e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileWirelessEnergy e) {
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        boolean moved = false;
        HashSet<BlockPosDim> used = new HashSet<BlockPosDim>();
        for (int slot = 0; slot < this.gpsSlots.getSlots(); ++slot) {
            BlockPosDim loc = this.getTargetInSlot(slot);
            if (used.contains(loc) || loc == null || !LevelWorldUtil.dimensionIsEqual(loc, this.f_58857_) || !this.moveEnergy(loc.getSide(), loc.getPos(), this.transferRate)) continue;
            used.add(loc);
            moved = true;
        }
        this.setLitProperty(moved);
    }

    BlockPosDim getTargetInSlot(int s) {
        return LocationGpsCard.getPosition(this.gpsSlots.getStackInSlot(s));
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
                break;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    public float getRed() {
        return 0.89f;
    }

    public float getBlue() {
        return 0.0f;
    }

    public float getGreen() {
        return 0.12f;
    }

    public float getAlpha() {
        return 0.9f;
    }

    public float getThick() {
        return 0.065f;
    }

    static enum Fields {
        RENDER,
        TRANSFER_RATE,
        REDSTONE;

    }
}

