/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.crusher.RecipeCrusher;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.ChatUtil;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class CrusherRecipeCategory
implements IRecipeCategory<RecipeCrusher> {
    private static final int FONT = 0x404040;
    private static final ResourceLocation ID = new ResourceLocation("cyclic", "crusher");
    static final RecipeType<RecipeCrusher> TYPE = new RecipeType(ID, RecipeCrusher.class);
    private IDrawable gui;
    private IDrawable icon;

    public CrusherRecipeCategory(IGuiHelper helper) {
        this.gui = helper.drawableBuilder(new ResourceLocation("cyclic", "textures/jei/crusher.png"), 0, 0, 155, 49).setTextureSize(155, 49).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.CRUSHER.get()));
    }

    public Component getTitle() {
        return ChatUtil.ilang(((Block)BlockRegistry.CRUSHER.get()).m_7705_());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.gui;
    }

    public RecipeType<RecipeCrusher> getRecipeType() {
        return TYPE;
    }

    public void draw(RecipeCrusher recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics ms, double mouseX, double mouseY) {
        int x = 78;
        Font font = Minecraft.m_91087_().f_91062_;
        if (recipe.energy.getTicks() < 40) {
            ms.m_280488_(font, recipe.energy.getTicks() + " t", x, 6, 0x404040);
        } else {
            int sec = recipe.energy.getTicks() / 20;
            ms.m_280488_(font, sec + " s", x, 6, 0x404040);
        }
        ms.m_280488_(font, recipe.energy.getRfPertick() + " RF/t", x, 16, 0x404040);
        ms.m_280488_(font, recipe.energy.getEnergyTotal() + " RF", x, 26, 0x404040);
        if (!recipe.randOutput.bonus.m_41619_() && recipe.randOutput.percent > 0) {
            ms.m_280488_(font, recipe.randOutput.percent + "%", 56, 36, 0x404040);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeCrusher recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 14).addIngredients(recipe.at(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 35, 6).addItemStack(recipe.result);
        if (!recipe.randOutput.bonus.m_41619_() && recipe.randOutput.percent > 0) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 34, 31).addItemStack(recipe.randOutput.bonus);
        }
    }
}

