/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import com.lothrazar.cyclic.util.EntityUtil;
import com.lothrazar.cyclic.util.SoundUtil;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnderPearlEnchant
extends EnchantmentCyclic {
    public static final int COOLDOWN = 120;
    private static final float VELOCITY = 1.5f;
    private static final float INNACCURACY = 1.0f;
    public static final String ID = "ender";
    public static ForgeConfigSpec.BooleanValue CFG;

    public EnderPearlEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public int m_6586_() {
        return 3;
    }

    public boolean m_6081_(ItemStack stack) {
        return this.isEnabled() && stack.m_41720_() instanceof SwordItem;
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        int level;
        if (!this.isEnabled()) {
            return;
        }
        Level world = event.getLevel();
        if (!world.f_46443_ && event.getResult() != Event.Result.DENY && (level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)this, (ItemStack)event.getItemStack())) > 0) {
            int adjustedCooldown = 120 / level;
            Player player = event.getEntity();
            if (player.m_36335_().m_41519_(event.getItemStack().m_41720_())) {
                return;
            }
            ThrownEnderpearl pearl = new ThrownEnderpearl(world, (LivingEntity)player);
            Vec3 lookVector = player.m_20154_();
            pearl.m_6686_(lookVector.m_7096_(), lookVector.m_7098_(), lookVector.m_7094_(), 1.5f, 1.0f);
            EntityUtil.setCooldownItem(player, event.getItemStack().m_41720_(), adjustedCooldown);
            SoundUtil.playSound((Entity)player, SoundEvents.f_11857_, 0.5f, 0.4f / (world.f_46441_.m_188501_() * 0.4f + 0.8f));
            world.m_7967_((Entity)pearl);
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }
}

