/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.generatorexpl.BlockDestruction;
import com.lothrazar.cyclic.block.spawntriggers.BlockAltarNoTraders;
import com.lothrazar.cyclic.block.spawntriggers.CandlePeaceBlock;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.LevelWorldUtil;
import com.lothrazar.cyclic.world.cache.ServerCacheHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockSpawnEvents {
    @SubscribeEvent
    public void onExplosionEvent(ExplosionEvent.Start event) {
        Level world = event.getLevel();
        Integer radius = (Integer)BlockDestruction.RADIUS.get();
        Integer height = (Integer)BlockDestruction.HEIGHT.get();
        Vec3 thanksMojang = event.getExplosion().getPosition();
        if (LevelWorldUtil.doesBlockExist(world, new BlockPos((int)thanksMojang.f_82479_, (int)thanksMojang.f_82480_, (int)thanksMojang.f_82481_), ((Block)BlockRegistry.ALTAR_DESTRUCTION.get()).m_49966_(), radius, height)) {
            ModCyclic.LOGGER.info(world.f_46443_ + " =clinet;Explosion cancelled " + event.getExplosion());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingSpawnEvent(MobSpawnEvent.FinalizeSpawn event) {
        MobSpawnType res = event.getSpawnType();
        if (res == MobSpawnType.NATURAL || res == MobSpawnType.REINFORCEMENT || res == MobSpawnType.EVENT) {
            Integer radius = (Integer)CandlePeaceBlock.RADIUS.get();
            Integer height = (Integer)CandlePeaceBlock.HEIGHT.get();
            Mob mob = event.getEntity();
            if (radius > 0 && height > 0 && CandlePeaceBlock.isBad((LivingEntity)mob, res) && ServerCacheHolder.PEACE_CANDLE.hasCollision(mob.m_9236_(), mob.m_20183_(), radius, height)) {
                ModCyclic.LOGGER.info(mob.m_20183_() + " Spawn cancelled by CacheCandle " + mob.m_6095_());
                event.setResult(Event.Result.DENY);
            }
            radius = (Integer)BlockAltarNoTraders.RADIUS.get();
            height = (Integer)BlockAltarNoTraders.HEIGHT.get();
            if (radius > 0 && height > 0 && BlockAltarNoTraders.isSpawnDenied((LivingEntity)mob, res) && ServerCacheHolder.NO_SOLICITING.hasCollision(mob.m_9236_(), mob.m_20183_(), radius, height)) {
                ModCyclic.LOGGER.info(mob.m_20183_() + " Spawn cancelled by cache-altar " + mob.m_6095_());
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

