/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.gui;

import com.lothrazar.cyclic.registry.TextureRegistry;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class EnergyBar {
    private int x = 154;
    private int y = 8;
    public int capacity;
    private int width = 16;
    private int height = 62;
    public int guiLeft;
    public int guiTop;
    public boolean visible = true;
    private final Font font;

    public EnergyBar(Font font, int cap) {
        this.capacity = cap;
        this.font = font;
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        return this.guiLeft + this.x < mouseX && mouseX < this.guiLeft + this.x + this.width && this.guiTop + this.y < mouseY && mouseY < this.guiTop + this.y + this.getHeight();
    }

    public void draw(GuiGraphics gg, float energ) {
        if (!this.visible) {
            return;
        }
        int relX = this.guiLeft + this.x;
        int relY = this.guiTop + this.y;
        gg.m_280163_(TextureRegistry.ENERGY_BAR, relX, relY, 16.0f, 0.0f, this.width, this.getHeight(), 32, this.getHeight());
        float pct = Math.min(energ / (float)this.capacity, 1.0f);
        gg.m_280163_(TextureRegistry.ENERGY_BAR, relX, relY, 0.0f, 0.0f, this.width, this.getHeight() - (int)((float)this.getHeight() * pct), 32, this.getHeight());
    }

    public void renderHoveredToolTip(GuiGraphics ms, int mouseX, int mouseY, int energ) {
        if (this.visible && this.isMouseover(mouseX, mouseY)) {
            String tt = energ + "/" + this.capacity;
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)tt));
            ms.m_280666_(this.font, list, mouseX, mouseY);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

