/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.gui;

import com.lothrazar.cyclic.registry.TextureRegistry;
import com.lothrazar.cyclic.render.FluidRenderMap;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class FluidBar {
    public String emtpyTooltip = "0";
    private Font font;
    private int x;
    private int y;
    private int capacity;
    private int width = 18;
    private int height = 62;
    public int guiLeft;
    public int guiTop;

    public FluidBar(Font p, int cap) {
        this(p, 132, 8, cap);
    }

    public FluidBar(Font p, int x, int y, int cap) {
        this.font = p;
        this.x = x;
        this.y = y;
        this.capacity = cap;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void draw(GuiGraphics gg, FluidStack fluid) {
        boolean u = false;
        boolean v = false;
        int x = this.guiLeft + this.getX();
        int y = this.guiTop + this.getY();
        gg.m_280163_(TextureRegistry.FLUID_WIDGET, x, y, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        if (fluid == null || this.getCapacity() == 0 || fluid.getAmount() == 0) {
            return;
        }
        float capacity = this.getCapacity();
        float amount = fluid.getAmount();
        float scale = amount / capacity;
        int fluidAmount = (int)(scale * (float)this.height);
        TextureAtlasSprite sprite = FluidRenderMap.getFluidTexture(fluid, FluidRenderMap.FluidFlow.STILL);
        if (fluid.getFluid() == Fluids.f_76193_) {
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        }
        int xPosition = x + 1;
        int yPosition = y + 1;
        int maximum = this.height - 2;
        int desiredWidth = this.width - 2;
        int desiredHeight = fluidAmount - 2;
        gg.m_280159_(xPosition, yPosition + (maximum - desiredHeight), 0, desiredWidth, desiredHeight, sprite);
        if (fluid.getFluid() == Fluids.f_76193_) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        return this.guiLeft + this.x <= mouseX && mouseX <= this.guiLeft + this.x + this.width && this.guiTop + this.y <= mouseY && mouseY <= this.guiTop + this.y + this.height;
    }

    public void renderHoveredToolTip(GuiGraphics ms, int mouseX, int mouseY, FluidStack current) {
        if (this.isMouseover(mouseX, mouseY)) {
            this.renderTooltip(ms, mouseX, mouseY, current);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void renderTooltip(GuiGraphics gg, int mouseX, int mouseY, FluidStack current) {
        Object tt = this.emtpyTooltip;
        if (current != null && !current.isEmpty()) {
            tt = current.getAmount() + "/" + this.getCapacity() + " " + current.getDisplayName().getString();
        }
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        list.add(Component.m_237115_((String)tt));
        gg.m_280666_(this.font, list, mouseX, mouseY);
    }
}

