/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.util.ItemStackUtil;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public class SleepingMatItem
extends ItemBaseCyclic {
    public static final String CYCLIC_SLEEPING = "cyclic_sleeping";

    public SleepingMatItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41503_(256));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack itemstack = player.m_21120_(handIn);
        BlockPos pos = player.m_20183_();
        if (!worldIn.m_46461_()) {
            this.trySleep(player, pos, itemstack).ifLeft(p -> {
                if (p != null) {
                    player.m_5661_(p.m_36423_(), true);
                }
            });
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public Either<Player.BedSleepingProblem, Unit> trySleep(Player player, BlockPos at, ItemStack itemstack) {
        Optional<BlockPos> optAt = Optional.of(at);
        Player.BedSleepingProblem ret = ForgeEventFactory.onPlayerSleepInBed((Player)player, optAt);
        if (ret != null) {
            return Either.left((Object)ret);
        }
        Level world = player.m_9236_();
        if (!world.f_46443_) {
            boolean isoverworld;
            if (player.m_5803_() || !player.m_6084_()) {
                return Either.left((Object)Player.BedSleepingProblem.OTHER_PROBLEM);
            }
            boolean bl = isoverworld = world.m_46472_() == Level.f_46428_;
            if (!isoverworld) {
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
            }
            if (!ForgeEventFactory.fireSleepingTimeCheck((Player)player, optAt)) {
                player.m_21250_(at);
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
            }
            player.m_5802_(at);
            player.getPersistentData().m_128379_(CYCLIC_SLEEPING, true);
            player.f_36110_ = 0;
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                sl.m_8878_();
            }
            ItemStackUtil.damageItem((LivingEntity)player, itemstack);
        }
        return Either.right((Object)Unit.INSTANCE);
    }
}

