/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.boomerang;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.item.boomerang.BoomerangItem;
import com.lothrazar.cyclic.registry.PotionEffectRegistry;
import com.lothrazar.cyclic.util.EntityUtil;
import com.lothrazar.cyclic.util.ItemStackUtil;
import com.lothrazar.cyclic.util.LevelWorldUtil;
import com.lothrazar.cyclic.util.SoundUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class BoomerangEntity
extends ThrowableItemProjectile {
    private static final int STUN_SECONDS = 7;
    private static final int TICKS_UNTIL_RETURN = 15;
    private static final int TICKS_UNTIL_DEATH = 900;
    private static final double SPEED = 0.95;
    static final float DAMAGE_MIN = 1.5f;
    static final float DAMAGE_MAX = 3.8f;
    private static final EntityDataAccessor<Byte> IS_RETURNING = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> REDSTONE_TRIGGERED = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<String> OWNER = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private ItemStack boomerangThrown = ItemStack.f_41583_;
    private Player targetEntity;
    protected BoomerangItem.Boomer boomerangType;

    public BoomerangEntity(EntityType<? extends ThrowableItemProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public BoomerangEntity(EntityType<? extends ThrowableItemProjectile> type, LivingEntity et, Level worldIn) {
        super(type, et, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_RETURNING, (Object)0);
        this.f_19804_.m_135372_(REDSTONE_TRIGGERED, (Object)0);
        this.f_19804_.m_135372_(OWNER, (Object)"");
    }

    public void setBoomerangThrown(ItemStack boomerangThrown) {
        this.boomerangThrown = boomerangThrown;
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128359_("OWNER", (String)this.f_19804_.m_135370_(OWNER));
        tag.m_128344_("returning", ((Byte)this.f_19804_.m_135370_(IS_RETURNING)).byteValue());
        tag.m_128344_("REDSTONE_TRIGGERED", ((Byte)this.f_19804_.m_135370_(REDSTONE_TRIGGERED)).byteValue());
        this.boomerangThrown.m_41739_(tag);
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        this.f_19804_.m_135381_(OWNER, (Object)tag.m_128461_("OWNER"));
        this.f_19804_.m_135381_(IS_RETURNING, (Object)tag.m_128445_("returning"));
        this.f_19804_.m_135381_(REDSTONE_TRIGGERED, (Object)tag.m_128445_("REDSTONE_TRIGGERED"));
        this.boomerangThrown = ItemStack.m_41712_((CompoundTag)tag);
        super.m_7378_(tag);
    }

    public void setOwner(Player ent) {
        this.targetEntity = ent;
        if (ent != null && ent.m_20148_() != null) {
            this.f_19804_.m_135381_(OWNER, (Object)ent.m_20148_().toString());
        }
    }

    private void movementReturnCheck() {
        boolean returning;
        boolean bl = returning = (Byte)this.f_19804_.m_135370_(IS_RETURNING) == 1;
        if (returning && this.targetEntity != null) {
            this.moveTowardsTarget();
        }
    }

    private void moveTowardsTarget() {
        float newyRot = (float)Math.toRadians(EntityUtil.yawDegreesBetweenPoints(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.targetEntity.m_20185_(), this.targetEntity.m_20186_(), this.targetEntity.m_20189_()));
        float newxRot = (float)Math.toRadians(EntityUtil.pitchDegreesBetweenPoints(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.targetEntity.m_20185_(), this.targetEntity.m_20186_(), this.targetEntity.m_20189_()));
        this.m_146922_(newyRot);
        this.m_146926_(newxRot);
        Vec3 moveVec = EntityUtil.lookVector(this.m_146908_(), this.m_146909_()).m_82490_(0.95);
        this.m_20334_(0.5 * this.m_20184_().m_7096_() + 0.5 * moveVec.f_82479_, 0.5 * this.m_20184_().m_7098_() + (double)0.503f * moveVec.f_82480_, 0.5 * this.m_20184_().m_7094_() + 0.5 * moveVec.f_82481_);
    }

    private void tryPickupNearby() {
        Entity owner = this.m_19749_();
        if (owner == null || this.m_9236_().f_46443_) {
            return;
        }
        boolean range = true;
        List list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82383_(this.m_20184_()).m_82377_((double)range, (double)range, (double)range));
        for (Entity entityHit : list) {
            if (!(entityHit instanceof ItemEntity) && !(entityHit instanceof ExperienceOrb)) continue;
            entityHit.m_6021_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
        }
    }

    private void tryToggleRedstone(BlockPos pos) {
        Entity owner = this.m_19749_();
        if (owner instanceof Player) {
            try {
                boolean hasTriggered;
                BlockState blockState = this.m_9236_().m_8055_(pos);
                Block block = blockState.m_60734_();
                InteractionResult t = block.m_6227_(blockState, this.m_9236_(), pos, (Player)owner, InteractionHand.MAIN_HAND, null);
                boolean bl = hasTriggered = t == InteractionResult.SUCCESS;
                if (hasTriggered) {
                    this.setRedstoneHasTriggered();
                }
            }
            catch (Throwable e) {
                ModCyclic.LOGGER.error("Error on activate block", e);
            }
        }
    }

    private void setIsReturning() {
        this.f_19804_.m_135381_(IS_RETURNING, (Object)1);
    }

    private void setRedstoneHasTriggered() {
        this.f_19804_.m_135381_(REDSTONE_TRIGGERED, (Object)1);
    }

    private boolean hasTriggeredRedstoneAlready() {
        return (Byte)this.f_19804_.m_135370_(REDSTONE_TRIGGERED) > 0;
    }

    private void dropAsItem() {
        if (!this.boomerangThrown.m_41619_()) {
            Entity owner = this.m_19749_();
            if (owner instanceof Player) {
                Player pl = (Player)owner;
                if (pl.m_21205_().m_41619_()) {
                    pl.m_21008_(InteractionHand.MAIN_HAND, this.boomerangThrown);
                    this.boomerangThrown = ItemStack.f_41583_;
                } else {
                    owner.m_5552_(this.boomerangThrown, 0.5f);
                    this.boomerangThrown = ItemStack.f_41583_;
                }
            } else {
                ItemStackUtil.drop(this.m_9236_(), this.m_20183_().m_7494_(), this.boomerangThrown);
                this.boomerangThrown = ItemStack.f_41583_;
            }
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 900) {
            this.dropAsItem();
            return;
        }
        if (this.f_19797_ > 15) {
            this.setIsReturning();
        }
        BlockPos pos = this.m_20183_();
        Entity owner = this.m_19749_();
        if (owner != null && LevelWorldUtil.distanceBetweenHorizontal(pos, owner.m_20183_()) < 1.0) {
            this.dropAsItem();
            return;
        }
        if (!this.hasTriggeredRedstoneAlready() && !this.m_9236_().m_46859_(pos)) {
            this.tryToggleRedstone(pos);
        }
        this.tryPickupNearby();
        this.movementReturnCheck();
    }

    protected void m_6532_(HitResult result) {
        switch (result.m_6662_()) {
            case BLOCK: {
                this.onImpactBlock((BlockHitResult)result);
                break;
            }
            case ENTITY: {
                this.onImpactEntity((EntityHitResult)result);
                break;
            }
        }
    }

    private void onImpactBlock(BlockHitResult mop) {
        BlockState block = this.m_9236_().m_8055_(mop.m_82425_());
        if (mop.m_82434_() != Direction.UP && block.m_60783_((BlockGetter)this.m_20193_(), mop.m_82425_(), mop.m_82434_())) {
            this.setIsReturning();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onImpactEntity(EntityHitResult entityRayTrace) {
        Entity entityHit = entityRayTrace.m_82443_();
        if (entityHit == null || !entityHit.m_6084_()) {
            return;
        }
        Entity owner = this.m_19749_();
        if (owner == entityHit) {
            this.dropAsItem();
            return;
        }
        switch (this.boomerangType) {
            case CARRY: {
                if (entityHit.m_9236_().f_46443_) return;
                entityHit.m_20329_((Entity)this);
                return;
            }
            case DAMAGE: {
                if (!(entityHit instanceof LivingEntity)) return;
                LivingEntity live = (LivingEntity)entityHit;
                float damage = Mth.m_216267_((RandomSource)this.m_9236_().f_46441_, (float)1.5f, (float)3.8f);
                boolean attackSucc = live.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, owner), damage);
                if (attackSucc && live.m_6084_()) return;
            }
            case STUN: {
                LivingEntity live;
                if (entityHit == owner || !(entityHit instanceof LivingEntity) || entityHit instanceof Player || (live = (LivingEntity)entityHit).m_21023_((MobEffect)PotionEffectRegistry.STUN.get())) return;
                live.m_7292_(new MobEffectInstance((MobEffect)PotionEffectRegistry.STUN.get(), 140, 1));
                SoundUtil.playSound((Entity)live, SoundEvents.f_12057_);
                return;
            }
        }
    }

    protected float m_7139_() {
        return -0.02f;
    }

    protected Item m_7881_() {
        return null;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

